/*
 * Decompiled with CFR 0.152.
 */
import com.pi4j.component.servo.Servo;
import com.pi4j.component.servo.impl.GenericServo;
import com.pi4j.component.servo.impl.PCA9685GpioServoProvider;
import com.pi4j.gpio.extension.pca.PCA9685GpioProvider;
import com.pi4j.gpio.extension.pca.PCA9685Pin;
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinPwmOutput;
import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Scanner;

public class PCA9685GpioServoExample {
    private final PCA9685GpioProvider gpioProvider = this.createProvider();
    private final PCA9685GpioServoProvider gpioServoProvider;
    private final Servo[] servos;
    private int activeServo;

    public static void main(String[] args) throws Exception {
        System.out.println("<--Pi4J--> PCA9685 Servo Tester Example ... started.");
        PCA9685GpioServoExample example = new PCA9685GpioServoExample();
        Scanner scanner = new Scanner(System.in);
        char command = ' ';
        block12: while (command != 'x') {
            PCA9685GpioServoExample.printUsage();
            command = PCA9685GpioServoExample.readCommand(scanner);
            switch (command) {
                case 'c': {
                    example.chooseChannel(scanner);
                    continue block12;
                }
                case 'n': {
                    example.approachNeutralPosition();
                    continue block12;
                }
                case 'm': {
                    example.move(scanner);
                    continue block12;
                }
                case 's': {
                    example.subtrim(scanner);
                    continue block12;
                }
                case 'r': {
                    example.reverse();
                    continue block12;
                }
                case 't': {
                    example.travel(scanner);
                    continue block12;
                }
                case 'p': {
                    example.sweep(scanner);
                    continue block12;
                }
                case 'i': {
                    example.info();
                    continue block12;
                }
                case 'x': {
                    System.out.println("Servo Example - END.");
                    continue block12;
                }
                case ' ': {
                    System.err.println("Invalid input.");
                    continue block12;
                }
            }
            System.err.println("Unknown command [" + command + "].");
        }
        System.out.println("Exiting PCA9685GpioServoExample");
    }

    private static char readCommand(Scanner scanner) {
        char result = ' ';
        String input = scanner.nextLine();
        if (!input.trim().isEmpty()) {
            result = input.trim().toLowerCase().charAt(0);
        }
        return result;
    }

    private static void printUsage() {
        System.out.println("");
        System.out.println("|- Commands ---------------------------------------------------------------------");
        System.out.println("| c : choose active servo channel                                                ");
        System.out.println("| n : neutral - approach neutral position                                        ");
        System.out.println("| m : move servo position                                                        ");
        System.out.println("| s : subtrim                                                                    ");
        System.out.println("| r : reverse servo direction                                                    ");
        System.out.println("| t : travel - adjust endpoints                                                  ");
        System.out.println("| p : sweep - continuously move between max left and max right position)         ");
        System.out.println("| i : info - provide info for all servo channels                                 ");
        System.out.println("| x : exit                                                                       ");
        System.out.println("|--------------------------------------------------------------------------------");
    }

    public PCA9685GpioServoExample() throws Exception {
        this.provisionPwmOutputs(this.gpioProvider);
        this.gpioServoProvider = new PCA9685GpioServoProvider(this.gpioProvider);
        this.servos = new Servo[16];
        this.servos[0] = new GenericServo(this.gpioServoProvider.getServoDriver(PCA9685Pin.PWM_00), "Servo_1 (default settings)");
        this.servos[1] = new GenericServo(this.gpioServoProvider.getServoDriver(PCA9685Pin.PWM_01), "Servo_2 (max. endpoints)");
        this.servos[1].setProperty("endPointLeft", Float.toString(150.0f));
        this.servos[1].setProperty("endPointRight", Float.toString(150.0f));
        this.servos[2] = new GenericServo(this.gpioServoProvider.getServoDriver(PCA9685Pin.PWM_02), "Servo_3 (subtrim)");
        this.servos[2].setProperty("subtrim", Float.toString(-200.0f));
        this.servos[3] = new GenericServo(this.gpioServoProvider.getServoDriver(PCA9685Pin.PWM_03), "Servo_4 (reverse)");
        this.servos[3].setProperty("isReverse", Boolean.toString(true));
        this.activeServo = 0;
    }

    public void chooseChannel(Scanner scanner) {
        System.out.println("");
        System.out.println("|- Choose channel ---------------------------------------------------------------");
        System.out.println("| Choose active servo channel [0..15]                                            ");
        System.out.println("| Example: 0<Enter>                                                              ");
        System.out.println("|--------------------------------------------------------------------------------");
        int channel = -1;
        boolean isValidChannel = false;
        while (!isValidChannel) {
            String input = null;
            try {
                input = scanner.nextLine();
                channel = Integer.parseInt(input);
                if (channel >= 0 && channel <= 15) {
                    isValidChannel = true;
                    continue;
                }
                System.err.println("Unsupported servo channel [" + channel + "], provide number between 0 and 15.");
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid input [" + input + "], provide number between 0 and 15.");
            }
        }
        this.activeServo = channel;
        System.out.println("Active servo channel: " + this.activeServo);
    }

    public void approachNeutralPosition() {
        System.out.println("Approach neutral position");
        this.servos[this.activeServo].setPosition(0.0f);
    }

    public void move(Scanner scanner) {
        System.out.println("");
        System.out.println("|- Move Position ----------------------------------------------------------------");
        System.out.println("| Move servo position to the left or to the right.                               ");
        System.out.println("| Example: l10<Enter> this would move the servo from its current position to the ");
        System.out.println("|          left by 10%                                                           ");
        System.out.println("| Example: r<Enter> this would move the servo from its current position to the   ");
        System.out.println("|          right by 1%                                                           ");
        System.out.println("| -> subsequent single <Enter> will repeat the previous command                  ");
        System.out.println("| -> max travel to either side is 100%                                           ");
        System.out.println("| Exit command: x<Enter>                                                         ");
        System.out.println("|--------------------------------------------------------------------------------");
        String command = null;
        while (!"x".equals(command)) {
            int sign;
            float currentPosition = this.servos[this.activeServo].getPosition();
            System.out.println("Current servo position: " + currentPosition);
            String input = scanner.nextLine();
            if (!input.trim().isEmpty()) {
                command = input.trim().toLowerCase();
            }
            if (command == null) continue;
            if (command.startsWith("l")) {
                sign = -1;
            } else if (command.startsWith("r")) {
                sign = 1;
            } else {
                if (command.equals("x")) continue;
                System.err.println("Unknown command [" + command + "].");
                command = null;
                continue;
            }
            int moveAmount = 1;
            try {
                moveAmount = Integer.parseInt(command.substring(1));
                if (moveAmount < 0 || moveAmount > 100) {
                    moveAmount = 1;
                    System.out.println("Move amount is out of range - defaulted to [1].");
                }
                System.out.println("Move amount is [" + moveAmount + "].");
            }
            catch (Exception e) {
                System.out.println("Move amount defaulted to [1].");
            }
            float newPosition = currentPosition + (float)(moveAmount * sign);
            if (newPosition < -100.0f) {
                newPosition = -100.0f;
                System.out.println("Max left position exceeded - set position to -100.0%");
            } else if (newPosition > 100.0f) {
                newPosition = 100.0f;
                System.out.println("Max right position exceeded - set position to 100.0%");
            }
            this.servos[this.activeServo].setPosition(newPosition);
            command = (sign == 1 ? "r" : "l") + moveAmount;
        }
    }

    public void subtrim(Scanner scanner) {
        System.out.println("");
        System.out.println("|- Subtrim, adjust servo neutral position ---------------------------------------");
        System.out.println("| Example: r<Enter> this would move the servos neutral position by one step to   ");
        System.out.println("|          the right                                                             ");
        System.out.println("| Example: l<Enter> this would move the servos neutral position by one step to   ");
        System.out.println("|          the left                                                              ");
        System.out.println("| -> subsequent single <Enter> will repeat the previous command                  ");
        System.out.println("| -> max adjustment to either side is 200 steps                                  ");
        System.out.println("| Exit command: x<Enter>                                                         ");
        System.out.println("|--------------------------------------------------------------------------------");
        System.out.println("| Current Servo position: " + this.servos[this.activeServo].getPosition() + "]             ");
        System.out.println("|--------------------------------------------------------------------------------");
        String command = null;
        while (!"x".equals(command)) {
            int moveAmount;
            String propertySubtrim = this.servos[this.activeServo].getProperty("subtrim", Servo.PROP_SUBTRIM_DEFAULT);
            int currentSubtrim = Integer.parseInt(propertySubtrim);
            System.out.println("Current subtrim: " + currentSubtrim);
            String input = scanner.nextLine();
            if (!input.trim().isEmpty()) {
                command = input.trim().toLowerCase();
            }
            if (command == null) continue;
            if (command.startsWith("l")) {
                moveAmount = -1;
            } else if (command.startsWith("r")) {
                moveAmount = 1;
            } else {
                if (command.equals("x")) continue;
                System.err.println("Unknown command [" + command + "].");
                command = null;
                continue;
            }
            float newSubtrim = currentSubtrim + moveAmount;
            if (newSubtrim < -200.0f) {
                newSubtrim = -200.0f;
                System.out.println("Max left subtrim exceeded - set value to -200.0");
            } else if (newSubtrim > 200.0f) {
                newSubtrim = 200.0f;
                System.out.println("Max right subtrim exceeded - set value to 200.0");
            }
            this.servos[this.activeServo].setProperty("subtrim", Float.toString(newSubtrim));
        }
    }

    public void reverse() {
        boolean isReverse = Boolean.parseBoolean(this.servos[this.activeServo].getProperty("isReverse"));
        Boolean newValue = isReverse ? Boolean.FALSE : Boolean.TRUE;
        this.servos[this.activeServo].setProperty("isReverse", newValue.toString());
        System.out.println("is reverse: " + newValue);
    }

    public void travel(Scanner scanner) {
        System.out.println("");
        System.out.println("|- Travel -----------------------------------------------------------------------");
        System.out.println("| Adjust endpoints.                                                              ");
        System.out.println("| Example: r125<Enter>  adjust RIGHT endpoint to 125                             ");
        System.out.println("| -> min: 0, max: 150, default 100                                               ");
        System.out.println("| Exit command: x<Enter>                                                         ");
        System.out.println("|--------------------------------------------------------------------------------");
        String command = null;
        while (!"x".equals(command)) {
            int newEndpointValue;
            String propertyToAdjust;
            String propertyEndpointLeft = this.servos[this.activeServo].getProperty("endPointLeft", "100.0");
            String propertyEndpointRight = this.servos[this.activeServo].getProperty("endPointRight", "100.0");
            System.out.println("Current endpoints: LEFT [" + propertyEndpointLeft + "], RIGHT [" + propertyEndpointRight + "]");
            String input = scanner.nextLine();
            if (!input.trim().isEmpty()) {
                command = input.trim().toLowerCase();
            }
            if (command == null) continue;
            if (command.startsWith("l")) {
                propertyToAdjust = "endPointLeft";
            } else if (command.startsWith("r")) {
                propertyToAdjust = "endPointRight";
            } else {
                if (command.equals("x")) continue;
                System.err.println("Unknown command [" + command + "].");
                command = null;
                continue;
            }
            try {
                newEndpointValue = Integer.parseInt(command.substring(1));
                if ((float)newEndpointValue < 0.0f || (float)newEndpointValue > 150.0f) {
                    System.out.println("Endpoint value is out of range - defaulted to [100.0].");
                    newEndpointValue = Integer.parseInt("100.0");
                }
                System.out.println("New value for property [" + propertyToAdjust + "]: " + newEndpointValue + "");
            }
            catch (Exception e) {
                System.out.println("Endpoint value for property [" + propertyToAdjust + "] defaulted to [" + "100.0" + "].");
                newEndpointValue = Integer.parseInt("100.0");
            }
            this.servos[this.activeServo].setProperty(propertyToAdjust, Integer.toString(newEndpointValue));
        }
    }

    public void sweep(Scanner scanner) throws Exception {
        System.out.println("");
        System.out.println("|- Sweep ------------------------------------------------------------------------");
        System.out.println("| Continuously moves the servo between POS_MAX_LEFT and POS_MAX_RIGHT.           ");
        System.out.println("| To change speed provide value between 1 and 10 (10 for max speed)              ");
        System.out.println("| Example: 7<Enter>                                                              ");
        System.out.println("| Default speed: 5                                                               ");
        System.out.println("| Exit command: x<Enter>                                                         ");
        System.out.println("|--------------------------------------------------------------------------------");
        Sweeper sweeper = new Sweeper();
        sweeper.start();
        String command = null;
        while (!"x".equals(command)) {
            String input = scanner.nextLine();
            if (!input.trim().isEmpty()) {
                command = input.trim().toLowerCase();
            }
            if (command == null || command.equals("x")) continue;
            try {
                int speed = Integer.parseInt(command);
                sweeper.setSpeed(speed);
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid speed value [" + command + "]. Allowed values [1..10] ");
            }
        }
        sweeper.interrupt();
        this.servos[this.activeServo].setPosition(0.0f);
    }

    public void info() {
        for (int i = 0; i < this.servos.length; ++i) {
            Servo servo = this.servos[i];
            System.out.println("Channel " + (i < 10 ? " " : "") + i + ": " + (servo != null ? servo.toString() : "N.A."));
        }
    }

    private PCA9685GpioProvider createProvider() throws I2CFactory.UnsupportedBusNumberException, IOException {
        BigDecimal frequency = PCA9685GpioProvider.ANALOG_SERVO_FREQUENCY;
        BigDecimal frequencyCorrectionFactor = new BigDecimal("1.0578");
        I2CBus bus = I2CFactory.getInstance((int)1);
        return new PCA9685GpioProvider(bus, 64, frequency, frequencyCorrectionFactor);
    }

    private GpioPinPwmOutput[] provisionPwmOutputs(PCA9685GpioProvider gpioProvider) {
        GpioController gpio = GpioFactory.getInstance();
        GpioPinPwmOutput[] myOutputs = new GpioPinPwmOutput[]{gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_00, "Servo 00"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_01, "not used"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_02, "not used"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_03, "not used"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_04, "not used"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_05, "not used"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_06, "not used"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_07, "not used"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_08, "not used"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_09, "not used"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_10, "not used"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_11, "not used"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_12, "not used"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_13, "not used"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_14, "not used"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_15, "not used")};
        return myOutputs;
    }

    private class Sweeper
    extends Thread {
        private int speed = 5;
        private final int step = 1;
        private final int maxSleepBetweenSteps = 100;

        private Sweeper() {
        }

        @Override
        public void run() {
            int position = 0;
            GenericServo.Orientation orientation = GenericServo.Orientation.RIGHT;
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    if (orientation == GenericServo.Orientation.RIGHT) {
                        if ((float)position < 100.0f) {
                            ++position;
                        } else {
                            orientation = GenericServo.Orientation.LEFT;
                            --position;
                        }
                    } else if (orientation == GenericServo.Orientation.LEFT) {
                        if ((float)position > -100.0f) {
                            --position;
                        } else {
                            orientation = GenericServo.Orientation.RIGHT;
                            ++position;
                        }
                    } else {
                        System.err.println("Unsupported value for enum <ServoBase.Orientation>: [" + orientation + "].");
                    }
                    PCA9685GpioServoExample.this.servos[PCA9685GpioServoExample.this.activeServo].setPosition((float)position);
                    Thread.currentThread();
                    if (position % 10 == 0) {
                        System.out.println("Position: " + position);
                    }
                    Thread.sleep(100 / this.speed);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        public void setSpeed(int speed) {
            this.speed = speed < 1 ? 1 : (speed > 10 ? 10 : speed);
        }
    }
}

