/*
 * Decompiled with CFR 0.152.
 */
import com.pi4j.gpio.extension.pcf.PCF8574GpioProvider;
import com.pi4j.gpio.extension.pcf.PCF8574Pin;
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.GpioPinInput;
import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;
import com.pi4j.io.i2c.I2CFactory;
import java.io.IOException;

public class PCF8574GpioExample {
    public static void main(String[] args) throws InterruptedException, I2CFactory.UnsupportedBusNumberException, IOException {
        System.out.println("<--Pi4J--> PCF8574 GPIO Example ... started.");
        GpioController gpio = GpioFactory.getInstance();
        PCF8574GpioProvider provider = new PCF8574GpioProvider(1, 63);
        GpioPinDigitalInput[] myInputs = new GpioPinDigitalInput[]{gpio.provisionDigitalInputPin((GpioProvider)provider, PCF8574Pin.GPIO_00), gpio.provisionDigitalInputPin((GpioProvider)provider, PCF8574Pin.GPIO_01), gpio.provisionDigitalInputPin((GpioProvider)provider, PCF8574Pin.GPIO_02)};
        gpio.addListener((GpioPinListener)new GpioPinListenerDigital(){

            public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
                System.out.println(" --> GPIO PIN STATE CHANGE: " + event.getPin() + " = " + event.getState());
            }
        }, (GpioPinInput[])myInputs);
        GpioPinDigitalOutput[] myOutputs = new GpioPinDigitalOutput[]{gpio.provisionDigitalOutputPin((GpioProvider)provider, PCF8574Pin.GPIO_04, PinState.LOW), gpio.provisionDigitalOutputPin((GpioProvider)provider, PCF8574Pin.GPIO_05, PinState.LOW), gpio.provisionDigitalOutputPin((GpioProvider)provider, PCF8574Pin.GPIO_06, PinState.LOW)};
        gpio.setShutdownOptions(Boolean.valueOf(true), PinState.HIGH, (GpioPin[])myOutputs);
        for (int count = 0; count < 10; ++count) {
            gpio.setState(true, myOutputs);
            Thread.sleep(1000L);
            gpio.setState(false, myOutputs);
            Thread.sleep(1000L);
        }
        gpio.shutdown();
        System.out.println("Exiting PCF8574GpioExample");
    }
}

