/*
 * Decompiled with CFR 0.152.
 */
import com.pi4j.component.button.ButtonEvent;
import com.pi4j.component.button.ButtonPressedListener;
import com.pi4j.component.button.ButtonReleasedListener;
import com.pi4j.device.pibrella.Pibrella;
import com.pi4j.device.pibrella.PibrellaLed;
import com.pi4j.device.pibrella.impl.PibrellaDevice;
import java.io.IOException;

public class PibrellaExample {
    static final Pibrella pibrella = new PibrellaDevice();
    static int pulseRate = 100;
    static SampleTuneThread sampleTuneThread = new SampleTuneThread();

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) throws InterruptedException, IOException {
        System.out.println("<--Pi4J--> Pibrella Example ... started.");
        PibrellaExample.pibrella.button().addListener(new ButtonPressedListener[]{new ButtonPressedListener(){

            public void onButtonPressed(ButtonEvent event) {
                System.out.println("[BUTTON PRESSED]");
                pulseRate = 30;
                if (sampleTuneThread.isAlive()) {
                    PibrellaExample.stopSampleTune();
                } else {
                    PibrellaExample.playSampleTune();
                }
            }
        }});
        PibrellaExample.pibrella.button().addListener(new ButtonReleasedListener[]{new ButtonReleasedListener(){

            public void onButtonReleased(ButtonEvent event) {
                System.out.println("[BUTTON RELEASED]");
                pulseRate = 100;
            }
        }});
        while (true) {
            for (index = PibrellaLed.RED.getIndex(); index <= PibrellaLed.GREEN.getIndex(); ++index) {
                PibrellaExample.pibrella.getLed(index).pulse((long)PibrellaExample.pulseRate, true);
            }
            index = PibrellaLed.GREEN.getIndex();
            while (true) {
                if (index < PibrellaLed.RED.getIndex()) ** continue;
                PibrellaExample.pibrella.getLed(index).pulse((long)PibrellaExample.pulseRate, true);
                --index;
            }
            break;
        }
    }

    public static void playSampleTune() {
        if (!sampleTuneThread.isAlive()) {
            sampleTuneThread = new SampleTuneThread();
            sampleTuneThread.start();
        }
    }

    public static void stopSampleTune() {
        if (sampleTuneThread.isAlive()) {
            sampleTuneThread.terminate();
        }
    }

    public static class SampleTuneThread
    extends Thread {
        private final int[] scale = new int[]{262, 294, 330, 349, 392, 440, 494, 525};
        private final int[] tune = new int[]{0, 6, 1, 2, 2, 6, 0, 2, 2, 4, 0, 4, 2, 8, 1, 6, 2, 2, 3, 2, 3, 2, 2, 2, 1, 2, 3, 14, -1, 2, 2, 6, 3, 2, 4, 6, 2, 2, 4, 4, 2, 4, 4, 8, 3, 6, 4, 2, 5, 2, 5, 2, 4, 2, 3, 2, 5, 16, 4, 6, 0, 2, 1, 2, 2, 2, 3, 2, 4, 2, 5, 14, -1, 2, 5, 6, 1, 2, 2, 2, 3, 2, 4, 2, 5, 2, 6, 14, -1, 2, 6, 6, 2, 2, 3, 2, 4, 2, 5, 2, 6, 2, 7, 12, -1, 4, 6, 2, 6, 2, 5, 4, 4, 4, 6, 4, 4, 4, 7, 4, 4, 4, 2, 4, 1, 4, -1, 16, -1, -1};
        private final int TEMPO = 120;
        private final int MS_PER_BEAT = 125;
        private boolean stop = false;

        public void terminate() {
            this.stop = true;
        }

        @Override
        public void run() {
            int i = 0;
            while (!this.stop && !Thread.interrupted()) {
                int note = this.tune[i];
                int duration = this.tune[i + 1];
                if (note <= -1 && duration <= -1) break;
                if (note >= 0) {
                    pibrella.buzzer().buzz(this.scale[note], 125 * duration - 5);
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                i += 2;
            }
        }
    }
}

