/*
 * Decompiled with CFR 0.152.
 */
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinPwmOutput;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.RaspiPin;
import com.pi4j.util.CommandArgumentParser;
import com.pi4j.util.Console;
import com.pi4j.wiringpi.Gpio;

public class PwmExample {
    public static void main(String[] args) throws InterruptedException {
        Console console = new Console();
        console.title(new String[]{"<-- The Pi4J Project -->", "PWM Example"});
        console.promptForExit();
        GpioController gpio = GpioFactory.getInstance();
        Pin pin = CommandArgumentParser.getPin(RaspiPin.class, (Pin)RaspiPin.GPIO_01, (String[])args);
        GpioPinPwmOutput pwm = gpio.provisionPwmOutputPin(pin);
        Gpio.pwmSetMode((int)0);
        Gpio.pwmSetRange((int)1000);
        Gpio.pwmSetClock((int)500);
        pwm.setPwm(500);
        console.println("PWM rate is: " + pwm.getPwm());
        console.println("Press ENTER to set the PWM to a rate of 250");
        System.console().readLine();
        pwm.setPwm(250);
        console.println("PWM rate is: " + pwm.getPwm());
        console.println("Press ENTER to set the PWM to a rate to 0 (stop PWM)");
        System.console().readLine();
        pwm.setPwm(0);
        console.println("PWM rate is: " + pwm.getPwm());
        gpio.shutdown();
    }
}

