/*
 * Decompiled with CFR 0.152.
 */
import com.pi4j.io.spi.SpiChannel;
import com.pi4j.io.spi.SpiDevice;
import com.pi4j.io.spi.SpiFactory;
import com.pi4j.io.spi.SpiMode;
import com.pi4j.util.Console;
import java.io.IOException;

public class SpiExample {
    public static SpiDevice spi = null;
    public static short ADC_CHANNEL_COUNT = (short)8;
    protected static final Console console = new Console();

    public static void main(String[] args) throws InterruptedException, IOException {
        console.title(new String[]{"<-- The Pi4J Project -->", "SPI test program using MCP3004/MCP3008 AtoD Chip"});
        console.promptForExit();
        spi = SpiFactory.getInstance((SpiChannel)SpiChannel.CS0, (int)1000000, (SpiMode)SpiDevice.DEFAULT_SPI_MODE);
        while (console.isRunning()) {
            SpiExample.read();
            Thread.sleep(1000L);
        }
        console.emptyLine();
    }

    public static void read() throws IOException, InterruptedException {
        for (short channel = 0; channel < ADC_CHANNEL_COUNT; channel = (short)(channel + 1)) {
            int conversion_value = SpiExample.getConversionValue(channel);
            console.print(String.format(" | %04d", conversion_value));
        }
        console.print(" |\r");
        Thread.sleep(250L);
    }

    public static int getConversionValue(short channel) throws IOException {
        byte[] data = new byte[]{1, (byte)(0x80 | (channel & 7) << 4), 0};
        byte[] result = spi.write(data);
        int value = result[1] << 8 & 0x300;
        return value |= result[2] & 0xFF;
    }
}

