/*
 * Decompiled with CFR 0.152.
 */
import com.pi4j.component.motor.impl.GpioStepperMotorComponent;
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.RaspiPin;

public class StepperMotorGpioExample {
    public static void main(String[] args) throws InterruptedException {
        System.out.println("<--Pi4J--> GPIO Stepper Motor Example ... started.");
        GpioController gpio = GpioFactory.getInstance();
        GpioPinDigitalOutput[] pins = new GpioPinDigitalOutput[]{gpio.provisionDigitalOutputPin(RaspiPin.GPIO_00, PinState.LOW), gpio.provisionDigitalOutputPin(RaspiPin.GPIO_01, PinState.LOW), gpio.provisionDigitalOutputPin(RaspiPin.GPIO_02, PinState.LOW), gpio.provisionDigitalOutputPin(RaspiPin.GPIO_03, PinState.LOW)};
        gpio.setShutdownOptions(Boolean.valueOf(true), PinState.LOW, (GpioPin[])pins);
        GpioStepperMotorComponent motor = new GpioStepperMotorComponent(pins);
        byte[] single_step_sequence = new byte[]{1, 2, 4, 8};
        byte[] double_step_sequence = new byte[]{3, 6, 12, 9};
        byte[] half_step_sequence = new byte[]{1, 3, 2, 6, 4, 12, 8, 9};
        motor.setStepInterval(2L);
        motor.setStepSequence(single_step_sequence);
        motor.setStepsPerRevolution(2038);
        System.out.println("   Motor FORWARD for 2038 steps.");
        motor.step(2038L);
        System.out.println("   Motor STOPPED for 2 seconds.");
        Thread.sleep(2000L);
        System.out.println("   Motor REVERSE for 2038 steps.");
        motor.step(-2038L);
        System.out.println("   Motor STOPPED for 2 seconds.");
        Thread.sleep(2000L);
        System.out.println("   Motor FORWARD for 2 revolutions.");
        motor.rotate(2.0);
        System.out.println("   Motor STOPPED for 2 seconds.");
        Thread.sleep(2000L);
        System.out.println("   Motor REVERSE for 2 revolutions.");
        motor.rotate(-2.0);
        System.out.println("   Motor STOPPED for 2 seconds.");
        Thread.sleep(2000L);
        System.out.println("   Motor FORWARD for 5 seconds.");
        motor.forward(5000L);
        System.out.println("   Motor STOPPED for 2 seconds.");
        Thread.sleep(2000L);
        System.out.println("   Motor REVERSE for 5 seconds.");
        motor.reverse(5000L);
        System.out.println("   Motor STOPPED for 2 seconds.");
        Thread.sleep(2000L);
        System.out.println("   Motor FORWARD with slower speed and higher torque for 1 revolution.");
        motor.setStepSequence(double_step_sequence);
        motor.setStepInterval(10L);
        motor.rotate(1.0);
        System.out.println("   Motor STOPPED.");
        motor.stop();
        gpio.shutdown();
        System.out.println("Exiting StepperMotorGpioExample");
    }
}

