/*
 * Decompiled with CFR 0.152.
 */
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.RaspiPin;
import com.pi4j.io.gpio.trigger.GpioCallbackTrigger;
import com.pi4j.io.gpio.trigger.GpioPulseStateTrigger;
import com.pi4j.io.gpio.trigger.GpioSetStateTrigger;
import com.pi4j.io.gpio.trigger.GpioSyncStateTrigger;
import com.pi4j.io.gpio.trigger.GpioTrigger;
import java.util.concurrent.Callable;

public class TriggerGpioExample {
    public static void main(String[] args) throws InterruptedException {
        System.out.println("<--Pi4J--> GPIO Trigger Example ... started.");
        GpioController gpio = GpioFactory.getInstance();
        GpioPinDigitalInput myButton = gpio.provisionDigitalInputPin(RaspiPin.GPIO_02, PinPullResistance.PULL_DOWN);
        System.out.println(" ... complete the GPIO #02 circuit and see the triggers take effect.");
        GpioPinDigitalOutput[] myLed = new GpioPinDigitalOutput[]{gpio.provisionDigitalOutputPin(RaspiPin.GPIO_04, "LED #1", PinState.LOW), gpio.provisionDigitalOutputPin(RaspiPin.GPIO_05, "LED #2", PinState.LOW), gpio.provisionDigitalOutputPin(RaspiPin.GPIO_06, "LED #3", PinState.LOW)};
        myButton.addTrigger(new GpioTrigger[]{new GpioSetStateTrigger(PinState.HIGH, myLed[0], PinState.HIGH)});
        myButton.addTrigger(new GpioTrigger[]{new GpioSetStateTrigger(PinState.LOW, myLed[0], PinState.LOW)});
        myButton.addTrigger(new GpioTrigger[]{new GpioSyncStateTrigger(myLed[1])});
        myButton.addTrigger(new GpioTrigger[]{new GpioPulseStateTrigger(PinState.HIGH, myLed[2], 1000L)});
        myButton.addTrigger(new GpioTrigger[]{new GpioCallbackTrigger((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                System.out.println(" --> GPIO TRIGGER CALLBACK RECEIVED ");
                return null;
            }
        })});
        while (true) {
            Thread.sleep(500L);
        }
    }
}

