/*
 * Decompiled with CFR 0.152.
 */
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.RaspiPin;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;
import com.pi4j.io.gpio.trigger.GpioSyncStateTrigger;
import com.pi4j.io.gpio.trigger.GpioTrigger;

public class UsageGpioExample {
    public static void main(String[] args) throws InterruptedException {
        GpioController gpio = GpioFactory.getInstance();
        GpioPinDigitalInput myButton = gpio.provisionDigitalInputPin(RaspiPin.GPIO_02, "MyButton", PinPullResistance.PULL_DOWN);
        GpioPinDigitalOutput myLed = gpio.provisionDigitalOutputPin(RaspiPin.GPIO_04, "My LED", PinState.LOW);
        myLed.setShutdownOptions(Boolean.valueOf(true), PinState.LOW, PinPullResistance.OFF);
        myLed.setState(PinState.HIGH);
        myLed.low();
        myLed.high();
        myLed.toggle();
        myLed.pulse(1000L);
        PinState myButtonState = myButton.getState();
        boolean buttonPressed = myButton.isHigh();
        myButton.addListener(new GpioPinListener[]{new GpioUsageExampleListener()});
        myButton.addTrigger(new GpioTrigger[]{new GpioSyncStateTrigger(myLed)});
        while (true) {
            Thread.sleep(500L);
        }
    }

    public static class GpioUsageExampleListener
    implements GpioPinListenerDigital {
        public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
            System.out.println(" --> GPIO PIN STATE CHANGE: " + event.getPin() + " = " + event.getState());
        }
    }
}

