/*
 * Decompiled with CFR 0.152.
 */
import com.pi4j.wiringpi.Gpio;
import com.pi4j.wiringpi.GpioInterrupt;
import com.pi4j.wiringpi.GpioInterruptEvent;
import com.pi4j.wiringpi.GpioInterruptListener;
import com.pi4j.wiringpi.GpioUtil;

public class WiringPiGpioInterruptExample {
    public static void main(String[] args) throws InterruptedException {
        System.out.println("<--Pi4J--> GPIO INTERRUPT test program");
        GpioInterrupt.addListener((GpioInterruptListener)new GpioInterruptListener(){

            public void pinStateChange(GpioInterruptEvent event) {
                System.out.println("Raspberry Pi PIN [" + event.getPin() + "] is in STATE [" + event.getState() + "]");
                if (event.getPin() == 7) {
                    Gpio.digitalWrite((int)6, (int)event.getStateValue());
                }
                if (event.getPin() == 0) {
                    Gpio.digitalWrite((int)5, (int)event.getStateValue());
                }
            }
        });
        if (Gpio.wiringPiSetup() == -1) {
            System.out.println(" ==>> GPIO SETUP FAILED");
            return;
        }
        GpioUtil.export((int)0, (int)0);
        GpioUtil.export((int)7, (int)0);
        GpioUtil.export((int)5, (int)1);
        GpioUtil.export((int)6, (int)1);
        GpioUtil.setEdgeDetection((int)0, (int)1);
        GpioUtil.setEdgeDetection((int)7, (int)1);
        Gpio.pinMode((int)5, (int)1);
        Gpio.pinMode((int)6, (int)1);
        Gpio.pinMode((int)0, (int)0);
        Gpio.pullUpDnControl((int)0, (int)1);
        GpioInterrupt.enablePinStateChangeCallback((int)0);
        Gpio.pinMode((int)7, (int)0);
        Gpio.pullUpDnControl((int)7, (int)1);
        GpioInterrupt.enablePinStateChangeCallback((int)7);
        while (true) {
            Thread.sleep(5000L);
        }
    }
}

