/*
 * Decompiled with CFR 0.152.
 */
import com.pi4j.wiringpi.Gpio;
import com.pi4j.wiringpi.GpioInterruptCallback;

public class WiringPiGpioInterruptExample2 {
    public static void main(String[] args) throws InterruptedException {
        System.out.println("<--Pi4J--> GPIO interrupt test program");
        if (Gpio.wiringPiSetup() == -1) {
            System.out.println(" ==>> GPIO SETUP FAILED");
            return;
        }
        Gpio.pinMode((int)0, (int)0);
        Gpio.pinMode((int)1, (int)0);
        Gpio.pinMode((int)2, (int)0);
        Gpio.pullUpDnControl((int)0, (int)1);
        Gpio.pullUpDnControl((int)1, (int)1);
        Gpio.pullUpDnControl((int)2, (int)1);
        Gpio.wiringPiISR((int)0, (int)1, (GpioInterruptCallback)new GpioInterruptCallback(){

            public void callback(int pin) {
                System.out.println(" ==>> GPIO PIN " + pin + " - INTERRUPT DETECTED <FALLING>");
            }
        });
        Gpio.wiringPiISR((int)1, (int)3, (GpioInterruptCallback)new GpioInterruptCallback(){

            public void callback(int pin) {
                System.out.println(" ==>> GPIO PIN " + pin + " - INTERRUPT DETECTED <RISING|FALLING>");
            }
        });
        SampleCallbackClass risingCallbackInstance = new SampleCallbackClass("RISING");
        Gpio.wiringPiISR((int)2, (int)2, (GpioInterruptCallback)risingCallbackInstance);
        System.console().readLine("Press <ENTER> to exit program.\r\n", new Object[0]);
    }

    public static class SampleCallbackClass
    implements GpioInterruptCallback {
        private String direction = "UKNOWN";

        public SampleCallbackClass(String direction) {
            this.direction = direction;
        }

        public void callback(int pin) {
            System.out.println(" ==>> GPIO PIN " + pin + " - INTERRUPT DETECTED <" + this.direction.toUpperCase() + ">");
        }
    }
}

