/*
 * Decompiled with CFR 0.152.
 */
import com.pi4j.wiringpi.Gpio;
import com.pi4j.wiringpi.Lcd;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class WiringPiLcdExample {
    public static final int LCD_ROWS = 2;
    public static final int LCD_COLUMNS = 16;
    public static final int LCD_BITS = 4;

    public static void main(String[] args) throws InterruptedException, UnsupportedEncodingException {
        System.out.println("<--Pi4J--> Wiring Pi LCD test program");
        if (Gpio.wiringPiSetup() == -1) {
            System.out.println(" ==>> GPIO SETUP FAILED");
            return;
        }
        int lcdHandle = Lcd.lcdInit((int)2, (int)16, (int)4, (int)11, (int)10, (int)0, (int)1, (int)2, (int)3, (int)0, (int)0, (int)0, (int)0);
        if (lcdHandle == -1) {
            System.out.println(" ==>> LCD INIT FAILED");
            return;
        }
        Lcd.lcdClear((int)lcdHandle);
        Thread.sleep(1000L);
        Lcd.lcdHome((int)lcdHandle);
        Lcd.lcdPuts((int)lcdHandle, (String)"The Pi4J Project");
        Lcd.lcdPosition((int)lcdHandle, (int)0, (int)1);
        Lcd.lcdPuts((int)lcdHandle, (String)"----------------");
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        while (true) {
            Lcd.lcdPosition((int)lcdHandle, (int)0, (int)1);
            Lcd.lcdPuts((int)lcdHandle, (String)("--- " + formatter.format(new Date()) + " ---"));
            Thread.sleep(1000L);
        }
    }
}

