/*
 * Decompiled with CFR 0.152.
 */
import com.pi4j.wiringpi.Spi;

public class WiringPiSPIExample {
    public static byte WRITE_CMD = (byte)64;
    public static byte READ_CMD = (byte)65;

    public static void main(String[] args) throws InterruptedException {
        System.out.println("<--Pi4J--> SPI test program using MCP23S17 I/O Expander Chip");
        byte IODIRA = 0;
        byte IODIRB = 1;
        byte IOCON = 10;
        byte GPIOA = 18;
        int GPIOB = 19;
        int GPPUA = 12;
        byte GPPUB = 13;
        byte OUTPUT_PORT = GPIOA;
        int INPUT_PORT = GPIOB;
        byte INPUT_PULLUPS = GPPUB;
        int fd = Spi.wiringPiSPISetup((int)0, (int)10000000);
        if (fd <= -1) {
            System.out.println(" ==>> SPI SETUP FAILED");
            return;
        }
        WiringPiSPIExample.write(IOCON, 8);
        WiringPiSPIExample.write(GPIOA, 0);
        WiringPiSPIExample.write(IODIRA, 0);
        WiringPiSPIExample.write(IODIRB, 255);
        WiringPiSPIExample.write(GPPUB, 255);
        int pins = 1;
        while (true) {
            if (pins >= 255) {
                pins = 1;
            }
            WiringPiSPIExample.write(GPIOA, (byte)pins);
            pins <<= 1;
            Thread.sleep(1000L);
        }
    }

    public static void write(byte register, int data) {
        byte[] packet = new byte[]{WRITE_CMD, register, (byte)data};
        System.out.println("-----------------------------------------------");
        System.out.println("[TX] " + WiringPiSPIExample.bytesToHex(packet));
        Spi.wiringPiSPIDataRW((int)0, (byte[])packet, (int)3);
        System.out.println("[RX] " + WiringPiSPIExample.bytesToHex(packet));
        System.out.println("-----------------------------------------------");
    }

    public static void read(byte register) {
        byte[] packet = new byte[]{READ_CMD, register, 0};
        System.out.println("-----------------------------------------------");
        System.out.println("[TX] " + WiringPiSPIExample.bytesToHex(packet));
        Spi.wiringPiSPIDataRW((int)0, (byte[])packet, (int)3);
        System.out.println("[RX] " + WiringPiSPIExample.bytesToHex(packet));
        System.out.println("-----------------------------------------------");
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }
}

