/*
 * Decompiled with CFR 0.152.
 */
package bananapi;

import com.pi4j.io.gpio.BananaPiPin;
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.platform.Platform;
import com.pi4j.platform.PlatformAlreadyAssignedException;
import com.pi4j.platform.PlatformManager;
import com.pi4j.util.CommandArgumentParser;
import com.pi4j.util.Console;
import com.pi4j.util.ConsoleColor;

public class GpioInputExample {
    public static void main(String[] args) throws InterruptedException, PlatformAlreadyAssignedException {
        PlatformManager.setPlatform((Platform)Platform.BANANAPI);
        Console console = new Console();
        console.title(new String[]{"<-- The Pi4J Project -->", "GPIO Input Example"});
        console.promptForExit();
        GpioController gpio = GpioFactory.getInstance();
        Pin pin = CommandArgumentParser.getPin(BananaPiPin.class, (Pin)BananaPiPin.GPIO_01, (String[])args);
        PinPullResistance pull = CommandArgumentParser.getPinPullResistance((PinPullResistance)PinPullResistance.PULL_UP, (String[])args);
        GpioPinDigitalInput input = gpio.provisionDigitalInputPin(pin, "MyInput", pull);
        input.setShutdownOptions(Boolean.valueOf(true));
        console.println("Successfully provisioned [" + pin + "] with PULL resistance = [" + pull + "]");
        console.emptyLine();
        console.box(new String[]{"The GPIO input pin states will be displayed below."});
        console.emptyLine();
        console.emptyLine();
        console.println(" [" + input.toString() + "] digital state is: " + ConsoleColor.conditional((boolean)input.getState().isHigh(), (ConsoleColor)ConsoleColor.GREEN, (ConsoleColor)ConsoleColor.RED, (Object[])new Object[]{input.getState()}));
        console.emptyLine();
        gpio.shutdown();
    }
}

