/*
 * Decompiled with CFR 0.152.
 */
package odroid.c1;

import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinAnalogInput;
import com.pi4j.io.gpio.OdroidC1Pin;
import com.pi4j.platform.Platform;
import com.pi4j.platform.PlatformAlreadyAssignedException;
import com.pi4j.platform.PlatformManager;
import com.pi4j.util.Console;

public class AnalogInputExample {
    public static void main(String[] args) throws InterruptedException, PlatformAlreadyAssignedException {
        PlatformManager.setPlatform((Platform)Platform.ODROID);
        Console console = new Console();
        console.title(new String[]{"<-- The Pi4J Project -->", "Analog Input Example"});
        GpioController gpio = GpioFactory.getInstance();
        GpioPinAnalogInput[] inputs = new GpioPinAnalogInput[]{gpio.provisionAnalogInputPin(OdroidC1Pin.AIN0, "Analog Input 0"), gpio.provisionAnalogInputPin(OdroidC1Pin.AIN1, "Analog Input 1")};
        gpio.setShutdownOptions(Boolean.valueOf(true), (GpioPin[])inputs);
        console.println(" ... Successfully provisioned [" + inputs[0] + "]");
        console.println(" ... Successfully provisioned [" + inputs[1] + "]");
        console.emptyLine();
        console.box(new String[]{"Below is the 10-bit conversion value (a number ", "between 0 and 1023) from the two analog input ", "pins which represents a voltage applied to each", "pin between 0VDC (Ground) and +1.8VDC.  If no ", "voltage is currently applied to the analog input", "pins then they may 'float' between a value of 0", "to 1023."});
        console.emptyLine();
        console.println(" [" + inputs[0].toString() + "] value is: %4.0f (%2.1f VDC)", new Object[]{inputs[0].getValue(), AnalogInputExample.getVoltage(inputs[0].getValue())});
        console.println(" [" + inputs[1].toString() + "] value is: %4.0f (%2.1f VDC)", new Object[]{inputs[1].getValue(), AnalogInputExample.getVoltage(inputs[1].getValue())});
        console.emptyLine();
        console.goodbye();
        gpio.shutdown();
    }

    private static double getVoltage(double value) {
        return value / 1024.0 * (double)1.8f;
    }
}

