/*
 * Decompiled with CFR 0.152.
 */
package odroid.c1;

import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.OdroidC1Pin;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinMode;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.platform.Platform;
import com.pi4j.platform.PlatformAlreadyAssignedException;
import com.pi4j.platform.PlatformManager;
import com.pi4j.util.CommandArgumentParser;
import com.pi4j.util.Console;
import com.pi4j.util.ConsoleColor;
import java.util.ArrayList;

public class GpioInputAllExample {
    public static void main(String[] args) throws InterruptedException, PlatformAlreadyAssignedException {
        PlatformManager.setPlatform((Platform)Platform.ODROID);
        Console console = new Console();
        console.title(new String[]{"<-- The Pi4J Project -->", "GPIO Input (ALL PINS) Example"});
        console.promptForExit();
        GpioController gpio = GpioFactory.getInstance();
        PinPullResistance pull = CommandArgumentParser.getPinPullResistance((PinPullResistance)PinPullResistance.PULL_UP, (String[])args);
        ArrayList<GpioPinDigitalInput> provisionedPins = new ArrayList<GpioPinDigitalInput>();
        for (Pin pin : OdroidC1Pin.allPins((PinMode[])new PinMode[]{PinMode.DIGITAL_INPUT})) {
            try {
                GpioPinDigitalInput provisionedPin = gpio.provisionDigitalInputPin(pin, pull);
                provisionedPin.setShutdownOptions(Boolean.valueOf(true));
                provisionedPins.add(provisionedPin);
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
        }
        console.println(" ... Successfully provisioned all GPIO input pins");
        console.emptyLine();
        console.box(new String[]{"The GPIO input pins states will be displayed below."});
        console.emptyLine();
        for (GpioPinDigitalInput input : provisionedPins) {
            console.println(" [" + input.toString() + "] digital state is: " + ConsoleColor.conditional((boolean)input.getState().isHigh(), (ConsoleColor)ConsoleColor.GREEN, (ConsoleColor)ConsoleColor.RED, (Object[])new Object[]{input.getState()}));
        }
        gpio.shutdown();
    }
}

