/*
 * Decompiled with CFR 0.152.
 */
package odroid.c1;

import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioPinInput;
import com.pi4j.io.gpio.OdroidC1Pin;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;
import com.pi4j.platform.Platform;
import com.pi4j.platform.PlatformAlreadyAssignedException;
import com.pi4j.platform.PlatformManager;
import com.pi4j.util.CommandArgumentParser;
import com.pi4j.util.Console;
import com.pi4j.util.ConsoleColor;

public class GpioListenAllExample {
    public static void main(String[] args) throws InterruptedException, PlatformAlreadyAssignedException {
        PlatformManager.setPlatform((Platform)Platform.ODROID);
        final Console console = new Console();
        console.title(new String[]{"<-- The Pi4J Project -->", "GPIO Listen (All Pins) Example"});
        console.promptForExit();
        GpioController gpio = GpioFactory.getInstance();
        gpio.unexport(OdroidC1Pin.allPins());
        PinPullResistance pull = CommandArgumentParser.getPinPullResistance((PinPullResistance)PinPullResistance.PULL_UP, (String[])args);
        console.println(" ... please wait; provisioning GPIO pins with resistance [" + pull + "]");
        GpioPinDigitalInput[] event_pins = new GpioPinDigitalInput[]{gpio.provisionDigitalInputPin(OdroidC1Pin.GPIO_00, pull), gpio.provisionDigitalInputPin(OdroidC1Pin.GPIO_01, pull), gpio.provisionDigitalInputPin(OdroidC1Pin.GPIO_02, pull), gpio.provisionDigitalInputPin(OdroidC1Pin.GPIO_03, pull)};
        gpio.setShutdownOptions(Boolean.valueOf(true), (GpioPin[])event_pins);
        GpioPinDigitalInput[] polled_pins = new GpioPinDigitalInput[]{gpio.provisionDigitalInputPin(OdroidC1Pin.GPIO_04, pull), gpio.provisionDigitalInputPin(OdroidC1Pin.GPIO_05, pull), gpio.provisionDigitalInputPin(OdroidC1Pin.GPIO_06, pull), gpio.provisionDigitalInputPin(OdroidC1Pin.GPIO_07, pull), gpio.provisionDigitalInputPin(OdroidC1Pin.GPIO_10, pull), gpio.provisionDigitalInputPin(OdroidC1Pin.GPIO_11, pull), gpio.provisionDigitalInputPin(OdroidC1Pin.GPIO_12, pull), gpio.provisionDigitalInputPin(OdroidC1Pin.GPIO_13, pull), gpio.provisionDigitalInputPin(OdroidC1Pin.GPIO_14, pull), gpio.provisionDigitalInputPin(OdroidC1Pin.GPIO_21, pull), gpio.provisionDigitalInputPin(OdroidC1Pin.GPIO_22, pull), gpio.provisionDigitalInputPin(OdroidC1Pin.GPIO_23, pull), gpio.provisionDigitalInputPin(OdroidC1Pin.GPIO_24, pull), gpio.provisionDigitalInputPin(OdroidC1Pin.GPIO_26, pull), gpio.provisionDigitalInputPin(OdroidC1Pin.GPIO_27, pull)};
        gpio.setShutdownOptions(Boolean.valueOf(true), (GpioPin[])polled_pins);
        console.println(" ... GPIO pins provisioned and ready for use.");
        console.emptyLine();
        console.box(new String[]{"Please complete the GPIO circuit and see", "the listener feedback here in the console."});
        console.emptyLine();
        gpio.addListener((GpioPinListener)new GpioPinListenerDigital(){

            public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
                console.println(" --> GPIO PIN STATE CHANGE (EVENT): " + event.getPin() + " = " + ConsoleColor.conditional((boolean)event.getState().isHigh(), (ConsoleColor)ConsoleColor.GREEN, (ConsoleColor)ConsoleColor.RED, (Object[])new Object[]{event.getState()}));
            }
        }, (GpioPinInput[])event_pins);
        while (console.isRunning()) {
            Thread.sleep(50L);
            for (GpioPinDigitalInput pin : polled_pins) {
                if (pin.getState().name().equals(pin.getProperty("last_known_state"))) continue;
                if (pin.getProperty("last_known_state") != null) {
                    console.println(" --> GPIO PIN STATE CHANGE (POLLED): " + pin + " = " + ConsoleColor.conditional((boolean)pin.getState().isHigh(), (ConsoleColor)ConsoleColor.GREEN, (ConsoleColor)ConsoleColor.RED, (Object[])new Object[]{pin.getState()}));
                }
                pin.setProperty("last_known_state", pin.getState().name());
            }
        }
        gpio.shutdown();
    }
}

