/*
 * Decompiled with CFR 0.152.
 */
package odroid.c1;

import com.pi4j.io.serial.Baud;
import com.pi4j.io.serial.DataBits;
import com.pi4j.io.serial.FlowControl;
import com.pi4j.io.serial.Parity;
import com.pi4j.io.serial.Serial;
import com.pi4j.io.serial.SerialConfig;
import com.pi4j.io.serial.SerialDataEvent;
import com.pi4j.io.serial.SerialDataEventListener;
import com.pi4j.io.serial.SerialFactory;
import com.pi4j.io.serial.StopBits;
import com.pi4j.platform.Platform;
import com.pi4j.platform.PlatformAlreadyAssignedException;
import com.pi4j.platform.PlatformManager;
import com.pi4j.util.CommandArgumentParser;
import com.pi4j.util.Console;
import java.io.IOException;
import java.util.Date;

public class SerialExample {
    public static void main(String[] args) throws InterruptedException, IOException, PlatformAlreadyAssignedException {
        PlatformManager.setPlatform((Platform)Platform.ODROID);
        final Console console = new Console();
        console.title(new String[]{"<-- The Pi4J Project -->", "Serial Communication Example"});
        console.promptForExit();
        Serial serial = SerialFactory.createInstance();
        serial.addListener(new SerialDataEventListener[]{new SerialDataEventListener(){

            public void dataReceived(SerialDataEvent event) {
                try {
                    console.println("[HEX DATA]   " + event.getHexByteString());
                    console.println("[ASCII DATA] " + event.getAsciiString());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }});
        try {
            SerialConfig config = new SerialConfig();
            config.device("/dev/ttyS2").baud(Baud._38400).dataBits(DataBits._8).parity(Parity.NONE).stopBits(StopBits._1).flowControl(FlowControl.NONE);
            if (args.length > 0) {
                config = CommandArgumentParser.getSerialConfig((SerialConfig)config, (String[])args);
            }
            console.box(new String[]{" Connecting to: " + config.toString(), " We are sending ASCII data on the serial port every 1 second.", " Data received on serial port will be displayed below."});
            serial.open(config);
            while (console.isRunning()) {
                try {
                    serial.write(new CharSequence[]{"CURRENT TIME: " + new Date().toString()});
                    serial.write(new byte[]{13});
                    serial.write(new byte[]{10});
                    serial.write(new CharSequence[]{"Second Line"});
                    serial.write(new char[]{'\r'});
                    serial.write(new char[]{'\n'});
                    serial.writeln(new CharSequence[]{"Third Line"});
                }
                catch (IllegalStateException ex) {
                    ex.printStackTrace();
                }
                Thread.sleep(1000L);
            }
        }
        catch (IOException ex) {
            console.println(" ==>> SERIAL SETUP FAILED : " + ex.getMessage());
            return;
        }
    }
}

