/*
 * Decompiled with CFR 0.152.
 */
package odroid.c1;

import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinPwmOutput;
import com.pi4j.io.gpio.OdroidC1Pin;
import com.pi4j.io.gpio.Pin;
import com.pi4j.platform.Platform;
import com.pi4j.platform.PlatformAlreadyAssignedException;
import com.pi4j.platform.PlatformManager;
import com.pi4j.util.CommandArgumentParser;
import com.pi4j.util.Console;

public class SoftPwmExample {
    public static void main(String[] args) throws InterruptedException, PlatformAlreadyAssignedException {
        PlatformManager.setPlatform((Platform)Platform.ODROID);
        Console console = new Console();
        console.title(new String[]{"<-- The Pi4J Project -->", "SoftPWM Example (Software-driven PWM Emulation)"});
        console.promptForExit();
        GpioController gpio = GpioFactory.getInstance();
        Pin pin = CommandArgumentParser.getPin(OdroidC1Pin.class, (Pin)OdroidC1Pin.GPIO_01, (String[])args);
        GpioPinPwmOutput pwm = gpio.provisionSoftPwmOutputPin(pin);
        pwm.setPwmRange(100);
        console.println(" ... Successfully provisioned PWM pin: " + pwm.toString());
        console.emptyLine();
        pwm.setPwm(100);
        console.println("Software emulated PWM rate is: " + pwm.getPwm());
        console.println("Press ENTER to set the PWM to a rate of 50");
        System.console().readLine();
        pwm.setPwm(50);
        console.println("Software emulated PWM rate is: " + pwm.getPwm());
        console.println("Press ENTER to set the PWM to a rate to 0 (stop PWM)");
        System.console().readLine();
        pwm.setPwm(0);
        console.println("Software emulated PWM rate is: " + pwm.getPwm());
        gpio.shutdown();
    }
}

