/*
 * Decompiled with CFR 0.152.
 */
package odroid.xu4;

import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinAnalogInput;
import com.pi4j.io.gpio.GpioPinInput;
import com.pi4j.io.gpio.OdroidGpioProvider;
import com.pi4j.io.gpio.OdroidXU4Pin;
import com.pi4j.io.gpio.event.GpioPinAnalogValueChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerAnalog;
import com.pi4j.platform.Platform;
import com.pi4j.platform.PlatformAlreadyAssignedException;
import com.pi4j.platform.PlatformManager;
import com.pi4j.util.Console;

public class AnalogListenExample {
    public static void main(String[] args) throws InterruptedException, PlatformAlreadyAssignedException {
        PlatformManager.setPlatform((Platform)Platform.ODROID);
        final Console console = new Console();
        console.title(new String[]{"<-- The Pi4J Project -->", "Analog Listener Example"});
        console.promptForExit();
        GpioController gpio = GpioFactory.getInstance();
        OdroidGpioProvider.setAnalogInputPollingRate((int)100);
        OdroidGpioProvider.setAnalogInputListenerChangeThreshold((double)5.0);
        GpioPinAnalogInput[] inputs = new GpioPinAnalogInput[]{gpio.provisionAnalogInputPin(OdroidXU4Pin.AIN0, "Analog Input 0"), gpio.provisionAnalogInputPin(OdroidXU4Pin.AIN3, "Analog Input 3")};
        gpio.setShutdownOptions(Boolean.valueOf(true), (GpioPin[])inputs);
        console.println(" ... Successfully provisioned [" + inputs[0] + "]");
        console.println(" ... Successfully provisioned [" + inputs[1] + "]");
        console.emptyLine();
        console.box(new String[]{"Below is the 12-bit conversion value (a number ", "between 0 and 4095) from the two analog input ", "pins which represents a voltage applied to each", "pin between 0VDC (Ground) and +1.8VDC.  If no ", "voltage is currently applied to the analog input", "pins then they may 'float' between a value of 0", "to 4095."});
        gpio.addListener((GpioPinListener)new GpioPinListenerAnalog(){

            public void handleGpioPinAnalogValueChangeEvent(GpioPinAnalogValueChangeEvent event) {
                console.println(" [" + event.getPin().toString() + "] value is: %4.0f (%2.1f VDC)", new Object[]{event.getValue(), AnalogListenExample.getVoltage(event.getValue())});
            }
        }, (GpioPinInput[])inputs);
        console.waitForExit();
        gpio.shutdown();
    }

    private static double getVoltage(double value) {
        return value / 4096.0 * (double)1.8f;
    }
}

