/*
 * Decompiled with CFR 0.152.
 */
package odroid.xu4;

import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioPinInput;
import com.pi4j.io.gpio.OdroidXU4Pin;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;
import com.pi4j.platform.Platform;
import com.pi4j.platform.PlatformAlreadyAssignedException;
import com.pi4j.platform.PlatformManager;
import com.pi4j.util.CommandArgumentParser;
import com.pi4j.util.Console;
import com.pi4j.util.ConsoleColor;

public class GpioListenAllExample {
    public static void main(String[] args) throws InterruptedException, PlatformAlreadyAssignedException {
        PlatformManager.setPlatform((Platform)Platform.ODROID);
        final Console console = new Console();
        console.title(new String[]{"<-- The Pi4J Project -->", "GPIO Listen (All Pins) Example"});
        console.promptForExit();
        GpioController gpio = GpioFactory.getInstance();
        PinPullResistance pull = CommandArgumentParser.getPinPullResistance((PinPullResistance)PinPullResistance.PULL_UP, (String[])args);
        console.println(" ... please wait; provisioning GPIO pins with resistance [" + pull + "]");
        GpioPinDigitalInput[] pins = new GpioPinDigitalInput[]{gpio.provisionDigitalInputPin(OdroidXU4Pin.GPIO_00, pull), gpio.provisionDigitalInputPin(OdroidXU4Pin.GPIO_01, pull), gpio.provisionDigitalInputPin(OdroidXU4Pin.GPIO_02, pull), gpio.provisionDigitalInputPin(OdroidXU4Pin.GPIO_03, pull), gpio.provisionDigitalInputPin(OdroidXU4Pin.GPIO_04, pull), gpio.provisionDigitalInputPin(OdroidXU4Pin.GPIO_05, pull), gpio.provisionDigitalInputPin(OdroidXU4Pin.GPIO_06, pull), gpio.provisionDigitalInputPin(OdroidXU4Pin.GPIO_07, pull), gpio.provisionDigitalInputPin(OdroidXU4Pin.GPIO_08, pull), gpio.provisionDigitalInputPin(OdroidXU4Pin.GPIO_09, pull), gpio.provisionDigitalInputPin(OdroidXU4Pin.GPIO_10, pull), gpio.provisionDigitalInputPin(OdroidXU4Pin.GPIO_11, pull), gpio.provisionDigitalInputPin(OdroidXU4Pin.GPIO_12, pull), gpio.provisionDigitalInputPin(OdroidXU4Pin.GPIO_13, pull), gpio.provisionDigitalInputPin(OdroidXU4Pin.GPIO_14, pull), gpio.provisionDigitalInputPin(OdroidXU4Pin.GPIO_15, pull), gpio.provisionDigitalInputPin(OdroidXU4Pin.GPIO_16, pull), gpio.provisionDigitalInputPin(OdroidXU4Pin.GPIO_21, pull), gpio.provisionDigitalInputPin(OdroidXU4Pin.GPIO_22, pull), gpio.provisionDigitalInputPin(OdroidXU4Pin.GPIO_23, pull), gpio.provisionDigitalInputPin(OdroidXU4Pin.GPIO_26, pull), gpio.provisionDigitalInputPin(OdroidXU4Pin.GPIO_27, pull), gpio.provisionDigitalInputPin(OdroidXU4Pin.GPIO_30, pull), gpio.provisionDigitalInputPin(OdroidXU4Pin.GPIO_31, pull)};
        gpio.setShutdownOptions(Boolean.valueOf(true), (GpioPin[])pins);
        console.println(" ... GPIO pins provisioned and ready for use.");
        console.emptyLine();
        console.box(new String[]{"Please complete the GPIO circuit and see", "the listener feedback here in the console."});
        console.emptyLine();
        gpio.addListener((GpioPinListener)new GpioPinListenerDigital(){

            public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
                console.println(" --> GPIO PIN STATE CHANGE (EVENT): " + event.getPin() + " = " + ConsoleColor.conditional((boolean)event.getState().isHigh(), (ConsoleColor)ConsoleColor.GREEN, (ConsoleColor)ConsoleColor.RED, (Object[])new Object[]{event.getState()}));
            }
        }, (GpioPinInput[])pins);
        console.waitForExit();
        gpio.shutdown();
    }
}

