/*
 * Decompiled with CFR 0.152.
 */
package odroid.xu4;

import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.OdroidXU4Pin;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;
import com.pi4j.platform.Platform;
import com.pi4j.platform.PlatformAlreadyAssignedException;
import com.pi4j.platform.PlatformManager;
import com.pi4j.util.CommandArgumentParser;
import com.pi4j.util.Console;
import com.pi4j.util.ConsoleColor;

public class GpioListenExample {
    public static void main(String[] args) throws InterruptedException, PlatformAlreadyAssignedException {
        PlatformManager.setPlatform((Platform)Platform.ODROID);
        final Console console = new Console();
        console.title(new String[]{"<-- The Pi4J Project -->", "GPIO Listen Example"});
        console.promptForExit();
        GpioController gpio = GpioFactory.getInstance();
        Pin pin = CommandArgumentParser.getPin(OdroidXU4Pin.class, (Pin)OdroidXU4Pin.GPIO_01, (String[])args);
        PinPullResistance pull = CommandArgumentParser.getPinPullResistance((PinPullResistance)PinPullResistance.PULL_UP, (String[])args);
        GpioPinDigitalInput myButton = gpio.provisionDigitalInputPin(pin, pull);
        myButton.setShutdownOptions(Boolean.valueOf(true));
        console.println(" ... Successfully provisioned [" + pin + "] with PULL resistance = [" + pull + "]");
        console.emptyLine();
        console.box(new String[]{"Please complete the [" + pin + "] circuit and see", "the listener feedback here in the console."});
        console.emptyLine();
        myButton.addListener(new GpioPinListener[]{new GpioPinListenerDigital(){

            public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
                console.println(" --> GPIO PIN STATE CHANGE: " + event.getPin() + " = " + ConsoleColor.conditional((boolean)event.getState().isHigh(), (ConsoleColor)ConsoleColor.GREEN, (ConsoleColor)ConsoleColor.RED, (Object[])new Object[]{event.getState()}));
            }
        }});
        console.waitForExit();
        gpio.shutdown();
    }
}

