/*
 * Decompiled with CFR 0.152.
 */
package odroid.xu4;

import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.OdroidXU4Pin;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;
import com.pi4j.platform.Platform;
import com.pi4j.platform.PlatformAlreadyAssignedException;
import com.pi4j.platform.PlatformManager;
import com.pi4j.util.CommandArgumentParser;
import com.pi4j.util.Console;
import com.pi4j.util.ConsoleColor;
import java.util.concurrent.Future;

public class GpioOutputExample {
    public static void main(String[] args) throws InterruptedException, PlatformAlreadyAssignedException {
        PlatformManager.setPlatform((Platform)Platform.ODROID);
        final Console console = new Console();
        console.title(new String[]{"<-- The Pi4J Project -->", "GPIO Output Example"});
        console.promptForExit();
        GpioController gpio = GpioFactory.getInstance();
        Pin pin = CommandArgumentParser.getPin(OdroidXU4Pin.class, (Pin)OdroidXU4Pin.GPIO_01, (String[])args);
        GpioPinDigitalOutput output = gpio.provisionDigitalOutputPin(pin, "My Output", PinState.HIGH);
        output.setShutdownOptions(Boolean.valueOf(false), PinState.LOW);
        output.addListener(new GpioPinListener[]{new GpioPinListenerDigital(){

            public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
                console.println(" --> GPIO PIN STATE CHANGE: " + event.getPin() + " = " + ConsoleColor.conditional((boolean)event.getState().isHigh(), (ConsoleColor)ConsoleColor.GREEN, (ConsoleColor)ConsoleColor.RED, (Object[])new Object[]{event.getState()}));
            }
        }});
        console.println(" ... Successfully provisioned output pin: " + output.toString());
        console.emptyLine();
        console.box(new String[]{"The GPIO output pin states will cycle HIGH and LOW states now."});
        console.emptyLine();
        console.println("--> [" + output.toString() + "] state was provisioned with state = " + ConsoleColor.conditional((boolean)output.getState().isHigh(), (ConsoleColor)ConsoleColor.GREEN, (ConsoleColor)ConsoleColor.RED, (Object[])new Object[]{output.getState()}));
        Thread.sleep(500L);
        console.emptyLine();
        console.println("Setting output pin state is set to LOW.");
        output.low();
        Thread.sleep(500L);
        console.emptyLine();
        console.println("Setting output pin state from LOW to HIGH.");
        output.setState(PinState.HIGH);
        Thread.sleep(500L);
        console.emptyLine();
        console.println("Toggling output pin state from HIGH to LOW.");
        output.toggle();
        Thread.sleep(500L);
        console.emptyLine();
        console.println("Pulsing output pin state HIGH for 1 second.");
        output.pulse(1000L, true);
        Thread.sleep(50L);
        console.emptyLine();
        console.println("Blinking output pin state between HIGH and LOW for 3 seconds with a blink rate of 250ms.");
        Future future = output.blink(250L, 3000L);
        while (!future.isDone()) {
            Thread.sleep(50L);
        }
        gpio.shutdown();
    }
}

