/*
 * Decompiled with CFR 0.152.
 */
package odroid.xu4;

import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CDevice;
import com.pi4j.io.i2c.I2CFactory;
import com.pi4j.platform.Platform;
import com.pi4j.platform.PlatformAlreadyAssignedException;
import com.pi4j.platform.PlatformManager;
import com.pi4j.util.Console;
import java.io.IOException;

public class I2CExample {
    public static final int TSL2561_ADDR = 57;
    public static final byte TSL2561_REG_ID = -118;
    public static final byte TSL2561_REG_DATA_0 = -116;
    public static final byte TSL2561_REG_DATA_1 = -114;
    public static final byte TSL2561_REG_CONTROL = -128;
    public static final byte TSL2561_POWER_UP = 3;
    public static final byte TSL2561_POWER_DOWN = 0;

    public static void main(String[] args) throws InterruptedException, PlatformAlreadyAssignedException, IOException, I2CFactory.UnsupportedBusNumberException {
        PlatformManager.setPlatform((Platform)Platform.ODROID);
        Console console = new Console();
        console.title(new String[]{"<-- The Pi4J Project -->", "I2C Example"});
        console.promptForExit();
        I2CBus i2c = I2CFactory.getInstance((int)3);
        I2CDevice device = i2c.getDevice(57);
        console.println("... reading ID register from TSL2561");
        int response = device.read(-118);
        console.println("TSL2561 ID = " + String.format("0x%02x", response) + " (should be 0x50)");
        console.println("... powering up TSL2561");
        device.write(-128, (byte)3);
        Thread.sleep(500L);
        console.println("... reading DATA registers from TSL2561");
        int data0 = device.read(-116);
        int data1 = device.read(-114);
        console.println("TSL2561 DATA 0 = " + String.format("0x%02x", data0));
        console.println("TSL2561 DATA 1 = " + String.format("0x%02x", data1));
        console.println("... powering down TSL2561");
        device.write(-128, (byte)0);
    }
}

