/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.gpio.extension.mcp;

import com.pi4j.gpio.extension.base.AdcGpioProvider;
import com.pi4j.gpio.extension.base.AdcGpioProviderBase;
import com.pi4j.gpio.extension.mcp.MCP3424Pin;
import com.pi4j.io.gpio.GpioPinAnalogInput;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CDevice;
import com.pi4j.io.i2c.I2CFactory;
import java.io.IOException;

public class MCP3424GpioProvider
extends AdcGpioProviderBase
implements AdcGpioProvider {
    public static final String NAME = "com.pi4j.gpio.extension.mcp.MCP3424GpioProvider";
    public static final String DESCRIPTION = "MCP3424 GPIO Provider";
    private int configuration = 144;
    private boolean i2cBusOwner = false;
    private final I2CBus bus;
    private final I2CDevice device;

    public MCP3424GpioProvider(int busNumber, int address) throws I2CFactory.UnsupportedBusNumberException, IOException {
        this(busNumber, address, 12, 1);
    }

    public MCP3424GpioProvider(int busNumber, int address, int resolution, int gain) throws I2CFactory.UnsupportedBusNumberException, IOException {
        this(I2CFactory.getInstance((int)busNumber), address, resolution, gain);
        this.i2cBusOwner = true;
    }

    public MCP3424GpioProvider(I2CBus bus, int address) throws I2CFactory.UnsupportedBusNumberException, IOException {
        this(bus, address, 12, 1);
    }

    public MCP3424GpioProvider(I2CBus bus, int address, int resolution, int gain) throws I2CFactory.UnsupportedBusNumberException, IOException {
        super(MCP3424Pin.ALL_PINS);
        if (resolution != 12 && resolution != 14 && resolution != 16 && resolution != 18) {
            throw new IllegalArgumentException("Invalid resolution: " + resolution);
        }
        if (gain != 1 && gain != 2 && gain != 4 && gain != 8) {
            throw new IllegalArgumentException("Invalid gain: " + gain);
        }
        gain = 31 - Integer.numberOfLeadingZeros(gain);
        this.configuration = (resolution - 12 << 1 | gain | this.configuration) & 0xFF;
        this.bus = bus;
        this.device = bus.getDevice(address);
        byte[] reset = new byte[]{0, 6};
        this.device.write(reset, 0, reset.length);
    }

    public void setGain(int gain) throws IllegalArgumentException {
        if (gain != 1 && gain != 2 && gain != 4 && gain != 8) {
            throw new IllegalArgumentException("Invalid gain: " + gain);
        }
        this.configuration &= 0xFC;
        this.configuration |= 31 - Integer.numberOfLeadingZeros(gain);
        this.configuration |= 0x80;
    }

    public void setResolution(int resolution) throws IllegalArgumentException {
        if (resolution != 12 && resolution != 14 && resolution != 16 && resolution != 18) {
            throw new IllegalArgumentException("Invalid resolution: " + resolution);
        }
        this.configuration &= 0xF3;
        this.configuration |= resolution - 12 << 1;
        this.configuration |= 0x80;
    }

    @Override
    public void shutdown() {
        if (this.isShutdown()) {
            return;
        }
        super.shutdown();
        if (this.i2cBusOwner) {
            try {
                this.bus.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getName() {
        return NAME;
    }

    public double getAnalogValue(Pin pin) {
        double value = this.getValue(pin);
        switch (this.configuration & 0xC) {
            case 0: {
                break;
            }
            case 4: {
                value *= 0.25;
                break;
            }
            case 8: {
                value *= 0.0625;
                break;
            }
            case 12: {
                value *= 0.015625;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return 0.001 * value;
    }

    public double getAnalogValue(GpioPinAnalogInput pin) {
        return this.getAnalogValue(pin.getPin());
    }

    @Override
    public double getImmediateValue(Pin pin) throws IOException {
        double weight;
        int command = this.configuration & 0x9F | pin.getAddress() << 5;
        this.device.write((byte)command);
        double rate = 0.0;
        byte[] data = null;
        switch (this.configuration & 0xC) {
            case 0: {
                data = new byte[3];
                rate = 176.0;
                break;
            }
            case 4: {
                data = new byte[3];
                rate = 44.0;
                break;
            }
            case 8: {
                data = new byte[3];
                rate = 11.0;
                break;
            }
            case 12: {
                data = new byte[4];
                rate = 2.75;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        try {
            Thread.sleep((long)Math.ceil(1000.0 / rate));
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this.device.read(data, 0, data.length);
        int answer = data[data.length - 1] & 0xFF;
        double d = weight = (data[0] & 0x80) == 0 ? 1.0 : -1.0;
        if ((answer & 0x60) == (command & 0x60) && (answer & 0x80) == 0) {
            if (weight < 0.0) {
                for (int i = 0; i < data.length - 1; ++i) {
                    data[i] = (byte)(~data[i] & 0xFF);
                }
                data[data.length - 2] = (byte)(data[data.length - 2] + 1);
            }
            switch (this.configuration & 0xC) {
                case 0: {
                    data[0] = (byte)(data[0] & 7);
                    break;
                }
                case 4: {
                    data[0] = (byte)(data[0] & 0x1F);
                    break;
                }
                case 8: {
                    data[0] = (byte)(data[0] & 0x7F);
                    break;
                }
                case 12: {
                    data[0] = (byte)(data[0] & 1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            int buffer = data[0] & 0xFF;
            for (int i = 1; i < data.length - 1; ++i) {
                buffer = buffer << 8 | data[i] & 0xFF;
            }
            double value = (double)buffer * weight;
            if (value >= this.getMinSupportedValue() && value <= this.getMaxSupportedValue()) {
                this.getPinCache(pin).setAnalogValue(value);
                return value;
            }
        }
        return -2.147483648E9;
    }

    @Override
    public double getMinSupportedValue() {
        switch (this.configuration & 0xC) {
            case 0: {
                return -2048.0;
            }
            case 4: {
                return -8192.0;
            }
            case 8: {
                return -32768.0;
            }
            case 12: {
                return -131072.0;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double getMaxSupportedValue() {
        switch (this.configuration & 0xC) {
            case 0: {
                return 2047.0;
            }
            case 4: {
                return 8191.0;
            }
            case 8: {
                return 32767.0;
            }
            case 12: {
                return 131071.0;
            }
        }
        throw new IllegalArgumentException();
    }
}

