/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.gpio.extension.olimex;

import com.pi4j.gpio.extension.olimex.OlimexAVRIOPin;
import com.pi4j.gpio.extension.serial.SerialCommandQueueProcessingThread;
import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.GpioProviderBase;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinMode;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.PinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.PinEvent;
import com.pi4j.io.gpio.event.PinListener;
import com.pi4j.io.serial.Serial;
import com.pi4j.io.serial.SerialDataEvent;
import com.pi4j.io.serial.SerialDataEventListener;
import com.pi4j.io.serial.SerialFactory;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class OlimexAVRIOGpioProvider
extends GpioProviderBase
implements GpioProvider {
    public static final String NAME = "com.pi4j.gpio.extension.olimex.OlimexAVRIOGpioProvider";
    public static final String DESCRIPTION = "Olimex AVR-IO GPIO Provider";
    private Serial com = SerialFactory.createInstance();
    private int currentStates = 0;
    private SerialCommandQueueProcessingThread queue;

    public OlimexAVRIOGpioProvider(String serialDevice) throws IOException {
        SerialExampleListener listener = new SerialExampleListener();
        this.com.addListener(new SerialDataEventListener[]{listener});
        this.com.open(serialDevice, 19200);
        this.queue = new SerialCommandQueueProcessingThread(this.com, 50);
        this.queue.start();
        this.queue.put("?");
    }

    public String getName() {
        return NAME;
    }

    public void setMode(Pin pin, PinMode mode) {
        super.setMode(pin, mode);
    }

    public PinMode getMode(Pin pin) {
        super.getMode(pin);
        Iterator iterator = pin.getSupportedPinModes().iterator();
        if (iterator.hasNext()) {
            PinMode mode = (PinMode)iterator.next();
            return mode;
        }
        return null;
    }

    public void setState(Pin pin, PinState state) {
        super.setState(pin, state);
        if (state == PinState.HIGH) {
            this.queue.put("+" + pin.getAddress());
        } else {
            this.queue.put("-" + pin.getAddress());
        }
    }

    public PinState getState(Pin pin) {
        super.getState(pin);
        int bit = (int)Math.pow(2.0, pin.getAddress() - 1);
        int state = this.currentStates & bit;
        return state == bit ? PinState.HIGH : PinState.LOW;
    }

    public void shutdown() {
        if (this.isShutdown()) {
            return;
        }
        super.shutdown();
        if (this.queue != null) {
            this.queue.shutdown();
            this.queue = null;
        }
        try {
            this.com.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SerialFactory.shutdown();
    }

    class SerialExampleListener
    implements SerialDataEventListener {
        private StringBuilder buffer = new StringBuilder();

        SerialExampleListener() {
        }

        public void dataReceived(SerialDataEvent event) {
            try {
                String data = event.getAsciiString();
                if (data != null && !data.isEmpty()) {
                    this.buffer.append(data);
                }
                int start = this.buffer.indexOf("$");
                int stop = this.buffer.indexOf("\n");
                while (stop >= 0) {
                    if (start >= 0 && stop > start) {
                        String command = this.buffer.substring(start, stop + 1);
                        this.buffer.delete(start, stop + 1).toString();
                        command = command.replace("$", "");
                        command = command.replace("\n", "");
                        command = command.replace("\r", "");
                        int value = Integer.parseInt(command, 16);
                        for (Pin pin : OlimexAVRIOPin.INPUTS) {
                            this.evaluatePinForChange(pin, value);
                        }
                        OlimexAVRIOGpioProvider.this.currentStates = value;
                    } else if (stop >= 0) {
                        this.buffer.delete(0, stop + 1);
                    }
                    start = this.buffer.indexOf("$");
                    stop = this.buffer.indexOf("\n");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void evaluatePinForChange(Pin pin, int value) {
            int bit = (int)Math.pow(2.0, pin.getAddress() - 1);
            if ((value & bit) != (OlimexAVRIOGpioProvider.this.currentStates & bit)) {
                this.dispatchPinChangeEvent(pin.getAddress(), (value & bit) == bit ? PinState.HIGH : PinState.LOW);
            }
        }

        private void dispatchPinChangeEvent(int pinAddress, PinState state) {
            for (Pin pin : OlimexAVRIOGpioProvider.this.listeners.keySet()) {
                if (pin.getAddress() != pinAddress) continue;
                for (PinListener listener : (List)OlimexAVRIOGpioProvider.this.listeners.get(pin)) {
                    listener.handlePinEvent((PinEvent)new PinDigitalStateChangeEvent((Object)this, pin, state));
                }
            }
        }
    }
}

