/*
 * Decompiled with CFR 0.152.
 */
package com.serialpundit.hid;

import com.serialpundit.core.SerialComException;
import com.serialpundit.hid.IHIDInputReportListener;
import com.serialpundit.hid.SerialComRawHID;
import com.serialpundit.hid.internal.InputReportListenerState;

final class HIDInputReportReader
implements Runnable {
    private final long handle;
    private final long context;
    private final IHIDInputReportListener listener;
    private byte[] inputReportBuffer;
    private final SerialComRawHID scrh;
    private final InputReportListenerState irls;
    private int ret;

    public HIDInputReportReader(InputReportListenerState irls, long handle, IHIDInputReportListener listener, byte[] inputReportBuffer, long context, SerialComRawHID scrh) {
        this.irls = irls;
        this.handle = handle;
        this.listener = listener;
        this.inputReportBuffer = inputReportBuffer;
        this.context = context;
        this.scrh = scrh;
    }

    @Override
    public void run() {
        do {
            try {
                this.ret = 0;
                this.ret = this.scrh.readInputReportR(this.handle, this.inputReportBuffer, this.context);
                if (this.ret <= 0) continue;
                this.listener.onNewInputReportAvailable(this.ret, this.inputReportBuffer);
            }
            catch (SerialComException e) {
                if ("I/O operation unblocked !".equals(e.getExceptionMsg())) {
                    return;
                }
                this.listener.onNewInputReportAvailableError((Exception)((Object)e));
            }
            catch (Exception e1) {
                this.listener.onNewInputReportAvailableError(e1);
            }
        } while (!this.irls.shouldInputReportListenerExit());
    }
}

