/*
 * Decompiled with CFR 0.152.
 */
package com.serialpundit.hid;

import com.serialpundit.core.SerialComException;
import com.serialpundit.core.SerialComPlatform;
import com.serialpundit.core.SerialComSystemProperty;
import com.serialpundit.core.util.SerialComUtil;
import com.serialpundit.hid.HIDInputReportReader;
import com.serialpundit.hid.IHIDInputReportListener;
import com.serialpundit.hid.SerialComHID;
import com.serialpundit.hid.SerialComHIDdevice;
import com.serialpundit.hid.internal.HIDdevHandleInfo;
import com.serialpundit.hid.internal.InputReportListenerState;
import com.serialpundit.hid.internal.SerialComHIDJNIBridge;
import java.io.IOException;
import java.util.HashMap;
import java.util.TreeMap;

public final class SerialComRawHID
extends SerialComHID {
    private final Object lock = new Object();
    private final TreeMap<Long, HIDdevHandleInfo> devInfo;
    private final HashMap<IHIDInputReportListener, Long> listenerToHandleMap;
    private static SerialComHIDJNIBridge mHIDJNIBridge;
    private final SerialComSystemProperty mSerialComSystemProperty = new SerialComSystemProperty();
    private static final Object lockA;
    private SerialComPlatform mSerialComPlatform;
    private static int osType;
    private static int cpuArch;
    private static int abiType;

    static {
        lockA = new Object();
        osType = 0;
        cpuArch = 0;
        abiType = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerialComRawHID(String libDirectory, String loadedLibName) throws IOException {
        Object object = lockA;
        synchronized (object) {
            if (osType <= 0) {
                this.mSerialComPlatform = new SerialComPlatform(this.mSerialComSystemProperty);
                osType = this.mSerialComPlatform.getOSType();
                if (osType == 0) {
                    throw new SerialComException("Could not identify operating system. Please report to us your environemnt so that we can add support for it !");
                }
                cpuArch = this.mSerialComPlatform.getCPUArch(osType);
                if (cpuArch == 0) {
                    throw new SerialComException("Could not identify CPU architecture. Please report to us your environemnt so that we can add support for it !");
                }
                if ((cpuArch == 15 || cpuArch == 14 || cpuArch == 13) && osType == 1) {
                    abiType = this.mSerialComPlatform.getABIType();
                }
            }
            if (mHIDJNIBridge == null) {
                mHIDJNIBridge = new SerialComHIDJNIBridge();
                SerialComHIDJNIBridge.loadNativeLibrary(libDirectory, loadedLibName, this.mSerialComSystemProperty, osType, cpuArch, abiType);
                int ret = mHIDJNIBridge.initNativeLib();
                if (ret < 0) {
                    throw new SerialComException("Failed to initilize the native library. Please retry !");
                }
            }
        }
        this.devInfo = new TreeMap();
        this.listenerToHandleMap = new HashMap();
    }

    public SerialComHIDdevice[] listHIDdevicesWithInfoR() throws SerialComException {
        int i = 0;
        int numOfDevices = 0;
        SerialComHIDdevice[] hidDevicesFound = null;
        String[] hidDevicesInfo = mHIDJNIBridge.listHIDdevicesWithInfoR();
        if (hidDevicesInfo != null) {
            if (hidDevicesInfo.length < 3) {
                return new SerialComHIDdevice[0];
            }
            numOfDevices = hidDevicesInfo.length / 8;
            hidDevicesFound = new SerialComHIDdevice[numOfDevices];
            int x = 0;
            while (x < numOfDevices) {
                hidDevicesFound[x] = new SerialComHIDdevice(hidDevicesInfo[i], hidDevicesInfo[i + 1], hidDevicesInfo[i + 2], hidDevicesInfo[i + 3], hidDevicesInfo[i + 4], hidDevicesInfo[i + 5], hidDevicesInfo[i + 6], hidDevicesInfo[i + 7]);
                i += 8;
                ++x;
            }
            return hidDevicesFound;
        }
        throw new SerialComException("Could not find HID devices. Please retry !");
    }

    public String formatReportToHexR(byte[] report, String separator) throws SerialComException {
        return SerialComUtil.byteArrayToHexString((byte[])report, (String)separator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long openHidDeviceR(String pathName, boolean shared) throws SerialComException {
        if (pathName == null) {
            throw new IllegalArgumentException("Argument pathName can not be null !");
        }
        String pathNameVal = pathName.trim();
        if (pathNameVal.length() == 0) {
            throw new IllegalArgumentException("Argument pathName can not be empty string !");
        }
        long handle = mHIDJNIBridge.openHidDeviceR(pathNameVal, shared, osType);
        if (handle < 0L) {
            throw new SerialComException("Could not open the HID device " + pathNameVal + ". Please retry !");
        }
        Object object = this.lock;
        synchronized (object) {
            this.devInfo.put(handle, new HIDdevHandleInfo(null));
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeHidDeviceR(long handle) throws SerialComException {
        HIDdevHandleInfo info = this.devInfo.get(handle);
        if (info == null) {
            throw new SerialComException("Given handle does not represent a HID device opened through SCM !");
        }
        if (info.getInputReportListener() != null) {
            throw new IllegalStateException("Closing device handle without unregistering input report listener is not allowed to prevent inconsistency !");
        }
        int ret = mHIDJNIBridge.closeHidDeviceR(handle);
        if (ret < 0) {
            throw new SerialComException("Could not close the given HID device. Please retry !");
        }
        Object object = this.lock;
        synchronized (object) {
            this.devInfo.remove(handle);
        }
        return true;
    }

    public long createBlockingHIDIOContextR() throws SerialComException {
        long ret = mHIDJNIBridge.createBlockingHIDIOContextR();
        if (ret < 0L) {
            throw new SerialComException("Could not create blocking HID I/O context. Please retry !");
        }
        return ret;
    }

    public boolean unblockBlockingHIDIOOperationR(long context) throws SerialComException {
        int ret = mHIDJNIBridge.unblockBlockingHIDIOOperationR(context);
        if (ret < 0) {
            throw new SerialComException("Could not unblock the blocked HID I/O operation. Please retry !");
        }
        return true;
    }

    public boolean destroyBlockingIOContextR(long context) throws SerialComException {
        int ret = mHIDJNIBridge.destroyBlockingIOContextR(context);
        if (ret < 0) {
            throw new SerialComException("Could not destroy blocking HID I/O context. Please retry !");
        }
        return true;
    }

    public int writeOutputReportR(long handle, byte reportId, byte[] report) throws SerialComException {
        if (report == null || report.length == 0) {
            throw new IllegalArgumentException("Argument report can not be null or of zero length!");
        }
        int ret = mHIDJNIBridge.writeOutputReportR(handle, reportId, report, report.length);
        if (ret < 0) {
            throw new SerialComException("Could not write output report to the HID device. Please retry !");
        }
        return ret;
    }

    public int readInputReportR(long handle, byte[] reportBuffer, long context) throws SerialComException {
        if (reportBuffer == null || reportBuffer.length == 0) {
            throw new IllegalArgumentException("Argument reportBuffer can not be null or of zero length!");
        }
        int ret = mHIDJNIBridge.readInputReportR(handle, reportBuffer, reportBuffer.length, context);
        if (ret < 0) {
            throw new SerialComException("Could not read input report from HID device. Please retry !");
        }
        return ret;
    }

    public int readInputReportWithTimeoutR(long handle, byte[] reportBuffer, int timeoutValue) throws SerialComException {
        if (reportBuffer == null) {
            throw new IllegalArgumentException("Argumenet reportBuffer can not be null !");
        }
        int ret = mHIDJNIBridge.readInputReportWithTimeoutR(handle, reportBuffer, reportBuffer.length, timeoutValue);
        if (ret < 0) {
            throw new SerialComException("Could not read input report from HID device. Please retry !");
        }
        return ret;
    }

    public int sendFeatureReportR(long handle, byte reportId, byte[] report) throws SerialComException {
        if (report == null) {
            throw new IllegalArgumentException("Argumenet report can not be null !");
        }
        if (report.length == 0) {
            throw new IllegalArgumentException("Argumenet report can not be of zero length !");
        }
        int ret = mHIDJNIBridge.sendFeatureReportR(handle, reportId, report, report.length);
        if (ret < 0) {
            throw new SerialComException("Could not send feature report to HID device. Please retry !");
        }
        return ret;
    }

    public int getFeatureReportR(long handle, byte reportId, byte[] report) throws SerialComException {
        if (report == null) {
            throw new IllegalArgumentException("Argumenet report can not be null !");
        }
        int ret = mHIDJNIBridge.getFeatureReportR(handle, reportId, report, report.length);
        if (ret < 0) {
            throw new SerialComException("Could not get feature report from HID device. Please retry !");
        }
        return ret;
    }

    public String getManufacturerStringR(long handle) throws SerialComException {
        String ret = mHIDJNIBridge.getManufacturerStringR(handle);
        if (ret == null) {
            throw new SerialComException("Could not get the manufacturer string from the HID device. Please retry !");
        }
        return ret;
    }

    public String getProductStringR(long handle) throws SerialComException {
        String ret = mHIDJNIBridge.getProductStringR(handle);
        if (ret == null) {
            throw new SerialComException("Could not get the product string from the HID device. Please retry !");
        }
        return ret;
    }

    public String getSerialNumberStringR(long handle) throws SerialComException {
        String ret = mHIDJNIBridge.getSerialNumberStringR(handle);
        if (ret == null) {
            throw new SerialComException("Could not get the serial number string from the HID device. Please retry !");
        }
        return ret;
    }

    public String getIndexedStringR(long handle, int index) throws SerialComException {
        if (osType == 2) {
            String ret = mHIDJNIBridge.getIndexedStringR(handle, index);
            if (ret == null) {
                throw new SerialComException("Could not get the string at given index from the HID device. Please retry !");
            }
            return ret;
        }
        throw new SerialComException("Not supported on this operating system !");
    }

    public String findDriverServingHIDDeviceR(String hidDeviceNode) throws SerialComException {
        if (hidDeviceNode == null) {
            throw new IllegalArgumentException("Argument hidDeviceNode can not be null !");
        }
        if (hidDeviceNode.length() == 0) {
            throw new IllegalArgumentException("Argument hidDeviceNode can not be empty string !");
        }
        if (hidDeviceNode.length() > 256) {
            throw new IllegalArgumentException("Argument hidDeviceNode string can not be greater than 256 in length !");
        }
        String driverName = mHIDJNIBridge.findDriverServingHIDDeviceR(hidDeviceNode);
        if (driverName == null) {
            throw new SerialComException("Failed to find driver serving the given HID device. Please retry !");
        }
        return driverName;
    }

    public byte[] getReportDescriptorR(long handle) throws SerialComException {
        byte[] reportDescriptorRead = mHIDJNIBridge.getReportDescriptorR(handle);
        if (reportDescriptorRead != null) {
            return reportDescriptorRead;
        }
        return new byte[0];
    }

    public byte[] getPhysicalDescriptorR(long handle) throws SerialComException {
        byte[] physicalDescriptorRead = mHIDJNIBridge.getPhysicalDescriptorR(handle);
        if (physicalDescriptorRead != null) {
            return physicalDescriptorRead;
        }
        return new byte[0];
    }

    public boolean flushInputReportQueueR(long handle) throws SerialComException {
        int ret = mHIDJNIBridge.flushInputReportQueueR(handle);
        if (ret < 0) {
            throw new SerialComException("Could not flush the input report queue. Please retry !");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerInputReportListener(long handle, IHIDInputReportListener listener, byte[] inputReportBuffer) throws SerialComException {
        if (listener == null) {
            throw new IllegalArgumentException("Argument listener can not be null !");
        }
        HIDdevHandleInfo info = this.devInfo.get(handle);
        if (info != null && info.getInputReportListener() != null) {
            throw new IllegalStateException("Input report listener already exist for given handle !");
        }
        InputReportListenerState irls = info.getInputReportListenerStateInstance();
        if (irls == null) {
            irls = new InputReportListenerState();
        } else {
            irls.setInputReportListenerState(false);
        }
        long context = this.createBlockingHIDIOContextR();
        Thread dataReaderThread = new Thread(new HIDInputReportReader(irls, handle, listener, inputReportBuffer, context, this));
        Object object = this.lock;
        synchronized (object) {
            info.setInputReportListenerStateInstance(irls);
            info.setInputReportListener(listener);
            info.setListenerContext(context);
            this.listenerToHandleMap.put(listener, handle);
            dataReaderThread.start();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterInputReportListener(IHIDInputReportListener listener) throws SerialComException {
        if (listener == null) {
            throw new IllegalArgumentException("Argument listener can not be null !");
        }
        long handle = this.listenerToHandleMap.get(listener);
        HIDdevHandleInfo info = this.devInfo.get(handle);
        if (info == null) {
            throw new IllegalArgumentException("Invalid listener passed for unregistration !");
        }
        long context = info.getListenerContext();
        InputReportListenerState irls = info.getInputReportListenerStateInstance();
        Object object = this.lock;
        synchronized (object) {
            irls.setInputReportListenerState(true);
            this.unblockBlockingHIDIOOperationR(context);
            Thread.yield();
            this.destroyBlockingIOContextR(context);
            info.setInputReportListener(null);
            info.setInputReportListenerStateInstance(null);
            this.listenerToHandleMap.remove(listener);
        }
        return true;
    }

    public boolean readPlatformSpecificInputReportR(long handle, byte reportId, byte[] reportBuffer) throws SerialComException {
        if (reportBuffer == null) {
            throw new IllegalArgumentException("Argumenet reportBuffer can not be null !");
        }
        int ret = mHIDJNIBridge.readPlatformSpecificInputReportR(handle, reportId, reportBuffer, reportBuffer.length);
        if (ret < 0) {
            throw new SerialComException("Could not read input report from HID device. Please retry !");
        }
        return true;
    }

    public boolean writePlatformSpecificOutputReportR(long handle, byte reportId, byte[] reportBuffer) throws SerialComException {
        if (reportBuffer == null) {
            throw new IllegalArgumentException("Argumenet reportBuffer can not be null !");
        }
        int ret = mHIDJNIBridge.writePlatformSpecificOutputReportR(handle, reportId, reportBuffer, reportBuffer.length);
        if (ret < 0) {
            throw new SerialComException("Could not read input report from HID device. Please retry !");
        }
        return true;
    }
}

