/*
 * Decompiled with CFR 0.152.
 */
package com.serialpundit.ioctl;

import com.serialpundit.core.SerialComException;
import com.serialpundit.core.SerialComPlatform;
import com.serialpundit.core.SerialComSystemProperty;
import com.serialpundit.ioctl.internal.SerialComIOCTLJNIBridge;
import java.io.IOException;

public final class SerialComIOCTLExecutor {
    private SerialComPlatform mSerialComPlatform;
    private final SerialComSystemProperty mSerialComSystemProperty = new SerialComSystemProperty();
    private static int osType = 0;
    private static int cpuArch = 0;
    private static int abiType = 0;
    private static final Object lockA = new Object();
    private static SerialComIOCTLJNIBridge mIOCTLJNIBridge;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerialComIOCTLExecutor(String libDirectory, String loadedLibName) throws SecurityException, IOException {
        Object object = lockA;
        synchronized (object) {
            if (osType <= 0) {
                this.mSerialComPlatform = new SerialComPlatform(this.mSerialComSystemProperty);
                osType = this.mSerialComPlatform.getOSType();
                if (osType == 0) {
                    throw new SerialComException("Could not identify operating system. Please report to us your environemnt so that we can add support for it !");
                }
                cpuArch = this.mSerialComPlatform.getCPUArch(osType);
                if (cpuArch == 0) {
                    throw new SerialComException("Could not identify CPU architecture. Please report to us your environemnt so that we can add support for it !");
                }
                if ((cpuArch == 15 || cpuArch == 14 || cpuArch == 13) && osType == 1) {
                    abiType = this.mSerialComPlatform.getABIType();
                }
            }
            if (mIOCTLJNIBridge == null) {
                mIOCTLJNIBridge = new SerialComIOCTLJNIBridge();
                SerialComIOCTLJNIBridge.loadNativeLibrary(libDirectory, loadedLibName, this.mSerialComSystemProperty, osType, cpuArch, abiType);
            }
        }
    }

    public boolean ioctlExecuteOperation(long handle, long operationCode) throws SerialComException {
        long ret = 0L;
        ret = mIOCTLJNIBridge.ioctlExecuteOperation(handle, operationCode);
        if (ret < 0L) {
            throw new SerialComException("Could not exceute requested IOCTL operation. Please retry !");
        }
        return true;
    }

    public boolean ioctlSetValue(long handle, long operationCode, long value) throws SerialComException {
        long ret = 0L;
        ret = mIOCTLJNIBridge.ioctlSetValue(handle, operationCode, value);
        if (ret < 0L) {
            throw new SerialComException("Could not set the value using IOCTL opertaion. Please retry !");
        }
        return true;
    }

    public long ioctlGetValue(long handle, long operationCode) throws SerialComException {
        long ret = 0L;
        ret = mIOCTLJNIBridge.ioctlGetValue(handle, operationCode);
        if (ret < 0L) {
            throw new SerialComException("Could not execute the given IOCTL operation. Please retry !");
        }
        return ret;
    }

    public boolean ioctlSetValueIntArray(long handle, long operationCode, int[] values) throws SerialComException {
        long ret = 0L;
        ret = mIOCTLJNIBridge.ioctlSetValueIntArray(handle, operationCode, values);
        if (ret < 0L) {
            throw new SerialComException("Could not execute the given IOCTL operation. Please retry !");
        }
        return true;
    }

    public boolean ioctlSetValueCharArray(long handle, long operationCode, byte[] values) throws SerialComException {
        long ret = 0L;
        ret = mIOCTLJNIBridge.ioctlSetValueCharArray(handle, operationCode, values);
        if (ret < 0L) {
            throw new SerialComException("Could not execute the given IOCTL operation. Please retry !");
        }
        return true;
    }
}

