/*
 * Decompiled with CFR 0.152.
 */
package com.serialpundit.ioctl.internal;

import com.serialpundit.core.SerialComException;
import com.serialpundit.core.SerialComSystemProperty;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class SerialComIOCTLJNIBridge {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean loadNativeLibrary(String directoryPath, String loadedLibName, SerialComSystemProperty serialComSystemProperty, int osType, int cpuArch, int abitype) throws SerialComException {
        String javaTmpDir = null;
        String userHomeDir = null;
        String fileSeparator = null;
        File baseDir = null;
        File workingDir = null;
        boolean isTmpDir = false;
        boolean isUserHomeDir = false;
        String libToExtractFromJar = null;
        File libFile = null;
        String libExtension = null;
        InputStream input = null;
        FileOutputStream output = null;
        fileSeparator = serialComSystemProperty.getfileSeparator();
        if (fileSeparator == null || fileSeparator.length() == 0) {
            throw new SerialComException("The file.separator java system property is either null or empty !");
        }
        if (directoryPath == null) {
            javaTmpDir = serialComSystemProperty.getJavaIOTmpDir();
            if (javaTmpDir == null || javaTmpDir.length() == 0) {
                throw new SerialComException("The java.io.tmpdir java system property is either null or empty !");
            }
            baseDir = new File(javaTmpDir);
            if (baseDir.exists() && baseDir.isDirectory() && baseDir.canWrite()) {
                isTmpDir = true;
            } else {
                userHomeDir = serialComSystemProperty.getUserHome();
                if (userHomeDir == null || userHomeDir.length() == 0) {
                    throw new SerialComException("The user.home java system property is either null or empty !");
                }
                baseDir = new File(userHomeDir);
                if (!baseDir.exists()) {
                    throw new SerialComException("User home directory does not exist. Also unable to access tmp/temp directory !");
                }
                if (!baseDir.isDirectory()) {
                    throw new SerialComException("User home directory is not a directory. Also unable to access tmp/temp directory !");
                }
                if (!baseDir.canWrite()) {
                    throw new SerialComException("User home directory is not writeable (permissions ??). Also unable to access tmp/temp directory !");
                }
                isUserHomeDir = true;
            }
            workingDir = new File(String.valueOf(baseDir.toString()) + fileSeparator + "sp_tuartx1");
            if (!workingDir.exists() && !workingDir.mkdir()) {
                if (isTmpDir) {
                    throw new SerialComException("Can not create sp_tuartx1 unique directory in tmp/temp directory !");
                }
                if (isUserHomeDir) {
                    throw new SerialComException("Can not create sp_tuartx1 unique directory in user's home directory !");
                }
            }
        } else {
            baseDir = new File(directoryPath);
            if (!baseDir.exists()) {
                throw new SerialComException("Given " + directoryPath + " directory does not exist !");
            }
            if (!baseDir.isDirectory()) {
                throw new SerialComException("Given " + directoryPath + " is not a directory !");
            }
            if (!baseDir.canWrite()) {
                throw new SerialComException("Given " + directoryPath + " directory is not writeable !");
            }
            workingDir = baseDir;
        }
        if (cpuArch == 2) {
            switch (osType) {
                case 2: {
                    libToExtractFromJar = "spioctlwinx64.dll";
                    libExtension = ".dll";
                    break;
                }
                case 1: {
                    libToExtractFromJar = "spioctllnxx64.so";
                    libExtension = ".so";
                    break;
                }
                case 4: {
                    libToExtractFromJar = "spioctlmacx64.dylib";
                    libExtension = ".dylib";
                }
            }
        } else if (cpuArch == 1) {
            switch (osType) {
                case 2: {
                    libToExtractFromJar = "spioctlwinx86.dll";
                    libExtension = ".dll";
                    break;
                }
                case 1: {
                    libToExtractFromJar = "spioctllnxx86.so";
                    libExtension = ".so";
                    break;
                }
                case 4: {
                    libToExtractFromJar = "spioctlmacx86.dylib";
                    libExtension = ".dylib";
                }
            }
        } else if (cpuArch == 15) {
            if (osType != 1) throw new SerialComException("Please report us your platform !");
            libExtension = ".so";
            if (abitype == 1) {
                libToExtractFromJar = "spioctllnxarmv7hf.so";
            } else if (abitype == 2) {
                libToExtractFromJar = "spioctllnxarmv7el.so";
            }
        } else if (cpuArch == 14) {
            if (osType != 1) throw new SerialComException("Please report us your platform !");
            libExtension = ".so";
            if (abitype == 1) {
                libToExtractFromJar = "spioctllnxarmv6hf.so";
            } else if (abitype == 2) {
                libToExtractFromJar = "spioctllnxarmv6el.so";
            }
        } else {
            if (cpuArch != 13) throw new SerialComException("This architecture is unknown to this library. Please contact us !");
            if (osType == 1) {
                libExtension = ".so";
                libToExtractFromJar = "spioctllnxarmv5.so";
            }
        }
        try {
            try {
                int read;
                libFile = loadedLibName == null ? new File(String.valueOf(workingDir.getAbsolutePath()) + fileSeparator + libToExtractFromJar) : new File(String.valueOf(workingDir.getAbsolutePath()) + fileSeparator + loadedLibName.trim() + libExtension);
                input = SerialComIOCTLJNIBridge.class.getResourceAsStream("/" + libToExtractFromJar);
                output = new FileOutputStream(libFile);
                if (input == null) throw new SerialComException("Can not get shared library " + libToExtractFromJar + " resource as stream from sp-usb.jar file !");
                byte[] buffer = new byte[4096];
                while ((read = input.read(buffer)) != -1) {
                    output.write(buffer, 0, read);
                }
                output.flush();
                output.close();
                output = null;
                if (libFile == null || !libFile.exists() || !libFile.isFile()) {
                    throw new SerialComException("Can not extract native shared library " + libToExtractFromJar + " from sp-usb.jar file !");
                }
            }
            catch (Exception e) {
                throw (SerialComException)new SerialComException(libFile.toString()).initCause((Throwable)e);
            }
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception exception) {}
        }
        File libFileFinal = libFile;
        try {
            AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    System.load(libFileFinal.toString());
                    return true;
                }
            });
            return true;
        }
        catch (Exception e) {
            throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("Could not load " + libFile.toString() + " native library !").initCause(e);
        }
    }

    public native long ioctlExecuteOperation(long var1, long var3);

    public native long ioctlSetValue(long var1, long var3, long var5);

    public native long ioctlGetValue(long var1, long var3);

    public native long ioctlSetValueIntArray(long var1, long var3, int[] var5);

    public native long ioctlSetValueCharArray(long var1, long var3, byte[] var5);
}

