/*
 * Decompiled with CFR 0.152.
 */
package com.serialpundit.serial;

import com.serialpundit.core.SerialComException;
import com.serialpundit.serial.SerialComManager;
import com.serialpundit.serial.internal.ISerialIOStream;
import com.serialpundit.serial.internal.SerialComPortHandleInfo;
import java.io.IOException;
import java.io.InputStream;

public final class SerialComInByteStream
extends InputStream
implements ISerialIOStream {
    private final SerialComManager scm;
    private final SerialComPortHandleInfo portHandleInfo;
    private final long handle;
    private final Object lock;
    private final boolean isBlocking;
    private final long context;
    private boolean isOpened;

    public SerialComInByteStream(SerialComManager scm, SerialComPortHandleInfo portHandleInfo, long handle, SerialComManager.SMODE streamMode) throws SerialComException {
        this.scm = scm;
        this.portHandleInfo = portHandleInfo;
        this.handle = handle;
        this.lock = new Object();
        if (streamMode.getValue() == 1) {
            this.context = scm.createBlockingIOContext();
            this.isBlocking = true;
        } else {
            this.context = 0L;
            this.isBlocking = false;
        }
        this.isOpened = true;
    }

    @Override
    public int available() throws IOException {
        if (!this.isOpened) {
            throw new IOException("The byte stream has been closed !");
        }
        int[] numBytesAvailable = new int[2];
        try {
            numBytesAvailable = this.scm.getByteCountInPortIOBuffer(this.handle);
        }
        catch (SerialComException e) {
            throw new IOException(e.getExceptionMsg());
        }
        return numBytesAvailable[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.isOpened) {
            throw new IOException("The byte stream has been already closed !");
        }
        if (this.isBlocking) {
            this.scm.unblockBlockingIOOperation(this.context);
            Object object = this.lock;
            synchronized (object) {
                this.scm.destroyBlockingIOContext(this.context);
            }
        }
        this.isOpened = false;
        this.portHandleInfo.setSerialComInByteStream(null);
    }

    @Override
    public void mark(int a) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read() throws IOException {
        if (!this.isOpened) {
            throw new IOException("The byte stream has been closed !");
        }
        try {
            if (this.isBlocking) {
                Object object = this.lock;
                synchronized (object) {
                    byte[] data;
                    try {
                        data = this.scm.readBytesBlocking(this.handle, 1, this.context);
                    }
                    catch (SerialComException e) {
                        if ("I/O operation unblocked !".equals(e.getExceptionMsg())) {
                            return -1;
                        }
                        throw new IOException(e.getExceptionMsg());
                    }
                    if (data != null) {
                        return data[0];
                    }
                    throw new IOException("Unknown error occured while reading data in blocking mode !");
                }
            }
            byte[] data = this.scm.readBytes(this.handle, 1);
            if (data != null) {
                return data[0];
            }
            return -1;
        }
        catch (SerialComException e) {
            throw new IOException(e.getExceptionMsg());
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.isOpened) {
            throw new IOException("The byte stream has been closed !");
        }
        if (b == null) {
            throw new NullPointerException("Null data buffer passed to read operation !");
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException("Index violation detected in given byte array !");
        }
        if (len == 0) {
            return 0;
        }
        int i = off;
        try {
            if (this.isBlocking) {
                Object object = this.lock;
                synchronized (object) {
                    byte[] data;
                    try {
                        data = this.scm.readBytesBlocking(this.handle, len, this.context);
                    }
                    catch (SerialComException e) {
                        if ("I/O operation unblocked !".equals(e.getExceptionMsg())) {
                            return -1;
                        }
                        throw new IOException(e.getExceptionMsg());
                    }
                    if (data == null) {
                        throw new IOException("Unknown error occured in native layer !");
                    }
                    int x = 0;
                    while (true) {
                        if (x >= data.length) {
                            return data.length;
                        }
                        b[i] = data[x];
                        ++i;
                        ++x;
                    }
                }
            }
            byte[] data = this.scm.readBytes(this.handle, len);
            if (data == null) {
                return -1;
            }
            int x = 0;
            while (true) {
                if (x >= data.length) {
                    return data.length;
                }
                b[i] = data[x];
                ++i;
                ++x;
            }
        }
        catch (SerialComException e) {
            throw new IOException(e.getExceptionMsg());
        }
    }

    @Override
    public synchronized void reset() throws IOException {
    }

    @Override
    public long skip(long number) {
        return 0L;
    }
}

