/*
 * Decompiled with CFR 0.152.
 */
package com.serialpundit.serial;

import com.serialpundit.core.SerialComException;
import com.serialpundit.serial.SerialComManager;
import com.serialpundit.serial.internal.ISerialIOStream;
import com.serialpundit.serial.internal.SerialComPortHandleInfo;
import java.io.IOException;
import java.io.OutputStream;

public final class SerialComOutByteStream
extends OutputStream
implements ISerialIOStream {
    private final SerialComManager scm;
    private final SerialComPortHandleInfo portHandleInfo;
    private final long handle;
    private final Object lock;
    private final boolean isBlocking;
    private final long context;
    private boolean isOpened;

    public SerialComOutByteStream(SerialComManager scm, SerialComPortHandleInfo portHandleInfo, long handle, SerialComManager.SMODE streamMode) throws SerialComException {
        this.scm = scm;
        this.portHandleInfo = portHandleInfo;
        this.handle = handle;
        this.lock = new Object();
        if (streamMode.getValue() == 1) {
            this.context = scm.createBlockingIOContext();
            this.isBlocking = true;
        } else {
            this.context = 0L;
            this.isBlocking = false;
        }
        this.isOpened = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int data) throws IOException {
        if (!this.isOpened) {
            throw new IOException("The byte stream has been closed !");
        }
        try {
            if (this.isBlocking) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        byte[] buffer = new byte[]{(byte)data};
                        data = this.scm.writeBytesBlocking(this.handle, buffer, this.context);
                    }
                    catch (SerialComException e) {
                        if ("I/O operation unblocked !".equals(e.getExceptionMsg())) {
                            return;
                        }
                        throw new IOException(e.getExceptionMsg());
                    }
                }
            }
            int ret = this.scm.writeSingleByte(this.handle, (byte)data);
            if (ret == 0) {
                throw new IOException("Given data not sent to serial port. Please retry !");
            }
        }
        catch (SerialComException e) {
            throw new IOException(e.getExceptionMsg());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] data) throws IOException {
        if (!this.isOpened) {
            throw new IOException("The byte stream has been closed !");
        }
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Argument data can not be null or an empty array !");
        }
        try {
            if (this.isBlocking) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        int result = this.scm.writeBytesBlocking(this.handle, data, this.context);
                        if (result == 0) {
                            throw new IOException("Given data not sent to serial port. Please retry !");
                        }
                    }
                    catch (SerialComException e) {
                        if ("I/O operation unblocked !".equals(e.getExceptionMsg())) {
                            return;
                        }
                        throw new IOException(e.getExceptionMsg());
                    }
                }
            }
            int ret = this.scm.writeBytes(this.handle, data, 0);
            if (ret == 0) {
                throw new IOException("Given data not sent to serial port. Please retry !");
            }
        }
        catch (SerialComException e) {
            throw new IOException(e.getExceptionMsg());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] data, int off, int len) throws IOException, IndexOutOfBoundsException {
        if (!this.isOpened) {
            throw new IOException("The byte stream has been closed !");
        }
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Argument data can not be null or an empty array !");
        }
        if (off < 0 || len < 0 || off + len > data.length) {
            throw new IndexOutOfBoundsException("Index violation detected in given data array !");
        }
        int i = off;
        byte[] buf = new byte[len];
        int x2 = 0;
        while (x2 < len) {
            buf[x2] = data[i];
            ++i;
            ++x2;
        }
        try {
            if (this.isBlocking) {
                Object x2 = this.lock;
                synchronized (x2) {
                    try {
                        int result = this.scm.writeBytesBlocking(this.handle, buf, this.context);
                        if (result == 0) {
                            throw new IOException("Given data not sent to serial port. Please retry !");
                        }
                    }
                    catch (SerialComException e) {
                        if ("I/O operation unblocked !".equals(e.getExceptionMsg())) {
                            return;
                        }
                        throw new IOException(e.getExceptionMsg());
                    }
                }
            }
            int ret = this.scm.writeBytes(this.handle, buf, 0);
            if (ret == 0) {
                throw new IOException("Given data not sent to serial port. Please retry !");
            }
        }
        catch (SerialComException e) {
            throw new IOException(e.getExceptionMsg());
        }
    }

    @Override
    public void flush() throws IOException {
        if (!this.isOpened) {
            throw new IOException("The byte stream has been closed !");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.isOpened) {
            throw new IOException("The byte stream has been already closed !");
        }
        if (this.isBlocking) {
            this.scm.unblockBlockingIOOperation(this.context);
            Object object = this.lock;
            synchronized (object) {
                this.scm.destroyBlockingIOContext(this.context);
            }
        }
        this.isOpened = false;
        this.portHandleInfo.setSerialComOutByteStream(null);
    }
}

