/*
 * Decompiled with CFR 0.152.
 */
package com.serialpundit.serial.comdb;

import com.serialpundit.core.SerialComException;
import com.serialpundit.serial.internal.SerialComDBReleaseJNIBridge;

public final class SerialComDBRelease {
    private final Object lock = new Object();
    private final SerialComDBReleaseJNIBridge mSerialComDBReleaseJNIBridge;

    public SerialComDBRelease(SerialComDBReleaseJNIBridge mSerialComDBReleaseJNIBridge) {
        this.mSerialComDBReleaseJNIBridge = mSerialComDBReleaseJNIBridge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startSerialComDBReleaseSerive() throws SerialComException {
        Object object = this.lock;
        synchronized (object) {
            int ret = this.mSerialComDBReleaseJNIBridge.startSerialComDBReleaseSerive();
            if (ret < 0) {
                throw new SerialComException("Could not start the comdb release service. Please retry !");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopSerialComDBReleaseSerive() throws SerialComException {
        Object object = this.lock;
        synchronized (object) {
            int ret = this.mSerialComDBReleaseJNIBridge.stopSerialComDBReleaseSerive();
            if (ret < 0) {
                throw new SerialComException("Could not stop the comdb release service. Please retry !");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseComPort(String comPortName) throws SerialComException {
        if (comPortName == null) {
            throw new IllegalArgumentException("Argument comPortName can not be null !");
        }
        String comPortNameVal = comPortName.trim();
        if (comPortNameVal.length() == 0) {
            throw new IllegalArgumentException("Argument comPortName can not be an empty string !");
        }
        Object object = this.lock;
        synchronized (object) {
            int ret = this.mSerialComDBReleaseJNIBridge.releaseComPort(comPortName);
            if (ret < 0) {
                throw new SerialComException("Could not release the given serial port. Please retry !");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseAllComPorts(String[] excludeList) throws SerialComException {
        Object object = this.lock;
        synchronized (object) {
            int ret = this.mSerialComDBReleaseJNIBridge.releaseAllComPorts(excludeList);
            if (ret < 0) {
                throw new SerialComException("Could not release the serial ports. Please retry !");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getComPortNumbersInUse() throws SerialComException {
        String[] portsInUse = null;
        Object object = this.lock;
        synchronized (object) {
            portsInUse = this.mSerialComDBReleaseJNIBridge.getComPortNumbersInUse();
            if (portsInUse == null) {
                throw new SerialComException("Could not calculate ports in use. Please retry !");
            }
        }
        return portsInUse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentComDBDatabaseSize() throws SerialComException {
        int currentSize = 0;
        Object object = this.lock;
        synchronized (object) {
            currentSize = this.mSerialComDBReleaseJNIBridge.getCurrentComDBDatabaseSize();
            if (currentSize < 0) {
                throw new SerialComException("Could not get current size of COMDB database. Please retry !");
            }
        }
        return currentSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resizeComDBDatabase(int newSize) throws SerialComException {
        Object object = this.lock;
        synchronized (object) {
            int ret = this.mSerialComDBReleaseJNIBridge.resizeComDBDatabase(newSize);
            if (ret < 0) {
                throw new SerialComException("Could not resize the database. Please retry !");
            }
        }
        return true;
    }
}

