/*
 * Decompiled with CFR 0.152.
 */
package com.serialpundit.serial.internal;

import com.serialpundit.core.SerialComException;
import com.serialpundit.core.SerialComSystemProperty;
import com.serialpundit.serial.internal.SerialComPortJNIBridge;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class SerialComFTDID2XXJNIBridge {
    public static boolean loadNativeLibrary(File libDirectory, String vlibName, int cpuArch, int osType, SerialComSystemProperty serialComSystemProperty) throws SerialComException {
        String fileSeparator;
        File libFile;
        block39: {
            String libToExtractFromJar = null;
            libFile = null;
            InputStream input = null;
            FileOutputStream output = null;
            fileSeparator = null;
            fileSeparator = serialComSystemProperty.getfileSeparator();
            if (fileSeparator == null || fileSeparator.length() == 0) {
                throw new SerialComException("The file.separator java system property is either null or empty !");
            }
            if (cpuArch == 2) {
                switch (osType) {
                    case 2: {
                        libToExtractFromJar = "spd2xxwinx64.dll";
                        break;
                    }
                    case 1: {
                        libToExtractFromJar = "spd2xxlnxx64.so";
                        break;
                    }
                    case 4: {
                        libToExtractFromJar = "spd2xxmacx64.dylib";
                    }
                }
            } else if (cpuArch == 1) {
                switch (osType) {
                    case 2: {
                        libToExtractFromJar = "spd2xxwinx86.dll";
                        break;
                    }
                    case 1: {
                        libToExtractFromJar = "spd2xxlnxx86.so";
                        break;
                    }
                    case 4: {
                        libToExtractFromJar = "spd2xxmacx86.dylib";
                    }
                }
            } else {
                throw new SerialComException("This architecture is unknown to this library. Please contact us !");
            }
            try {
                try {
                    libFile = new File(String.valueOf(libDirectory.getAbsolutePath()) + fileSeparator + libToExtractFromJar);
                    input = SerialComPortJNIBridge.class.getResourceAsStream("/" + libToExtractFromJar);
                    output = new FileOutputStream(libFile);
                    if (input != null) {
                        int read;
                        byte[] buffer = new byte[4096];
                        while ((read = input.read(buffer)) != -1) {
                            output.write(buffer, 0, read);
                        }
                        output.flush();
                        output.close();
                        output = null;
                        if (libFile == null || !libFile.exists() || !libFile.isFile()) {
                            throw new SerialComException("Can not extract native shared library " + libToExtractFromJar + " from sp-tty.jar file !");
                        }
                        break block39;
                    }
                    throw new SerialComException("Can not get shared library " + libToExtractFromJar + " resource as stream from sp-tty.jar file !");
                }
                catch (Exception e) {
                    throw (SerialComException)new SerialComException(libFile.toString()).initCause((Throwable)e);
                }
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        final File vlibFileFinal = new File(String.valueOf(libDirectory.getAbsolutePath()) + fileSeparator + vlibName);
        final File libFileFinal = libFile;
        try {
            AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    System.load(vlibFileFinal.toString());
                    return true;
                }
            });
        }
        catch (Exception e) {
            throw (SerialComException)new SerialComException("Could not load " + vlibFileFinal.toString() + " native library !").initCause((Throwable)e);
        }
        catch (UnsatisfiedLinkError e) {
            throw (SerialComException)new SerialComException(e.getMessage()).initCause((Throwable)e);
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    System.load(libFileFinal.toString());
                    return true;
                }
            });
        }
        catch (Exception e) {
            throw (SerialComException)new SerialComException("Could not load " + libFileFinal.toString() + " native library !").initCause((Throwable)e);
        }
        catch (UnsatisfiedLinkError e) {
            throw (SerialComException)new SerialComException(e.getMessage()).initCause((Throwable)e);
        }
        return true;
    }

    public native int setVidPid(int var1, int var2);

    public native int[] getVidPid();

    public native int createDeviceInfoList();

    public native String[] getDeviceInfoList(int var1);

    public native String[] getDeviceInfoDetail(int var1);

    public native String[] listDevices(int var1, int var2);

    public native long open(int var1);

    public native long openEx(String var1, long var2, int var4);

    public native int close(long var1);

    public native int read(long var1, byte[] var3, int var4);

    public native int write(long var1, byte[] var3, int var4);

    public native int setBaudRate(long var1, int var3);

    public native int setDivisor(long var1, int var3);

    public native int setDataCharacteristics(long var1, int var3, int var4, int var5);

    public native int setTimeouts(long var1, long var3, long var5);

    public native int setFlowControl(long var1, int var3, byte var4, byte var5);

    public native int setDTR(long var1);

    public native int clearDTR(long var1);

    public native int setRTS(long var1);

    public native int clearRTS(long var1);

    public native int getModemStatus(long var1);

    public native int getQueueStatus(long var1);

    public native String[] getDeviceInfo(long var1);

    public native long getDriverVersion(long var1);

    public native long getLibraryVersion();

    public native long getComPortNumber(long var1);

    public native long[] getStatus(long var1);

    public native int setEventNotificationAndWait(long var1, int var3);

    public native int setChars(long var1, byte var3, byte var4, byte var5, byte var6);

    public native int setBreakOn(long var1);

    public native int setBreakOff(long var1);

    public native int purge(long var1, boolean var3, boolean var4);

    public native int resetDevice(long var1);

    public native int resetPort(long var1);

    public native int cyclePort(long var1);

    public native int rescan();

    public native int reload(int var1, int var2);

    public native int setResetPipeRetryCount(long var1, int var3);

    public native int stopInTask(long var1);

    public native int restartInTask(long var1);

    public native int setDeadmanTimeout(long var1, int var3);

    public native int readEE(long var1, int var3);

    public native int writeEE(long var1, int var3, int var4);

    public native int eraseEE(long var1);

    public native int[] eeRead(long var1, int var3, char[] var4, char[] var5, char[] var6, char[] var7);

    public native int eeProgram(long var1, String var3, String var4, String var5, String var6, int[] var7);

    public native int eeProgramEx(long var1, String var3, String var4, String var5, String var6, int[] var7);

    public native int eeUAsize(long var1);

    public native int eeUAread(long var1, byte[] var3, int var4);

    public native int eeUAwrite(long var1, byte[] var3, int var4);

    public native int[] eepromRead(long var1, int var3, char[] var4, char[] var5, char[] var6, char[] var7);

    public native int eepromProgram(long var1, int var3, int[] var4, String var5, String var6, String var7, String var8);

    public native int setLatencyTimer(long var1, int var3);

    public native int getLatencyTimer(long var1);

    public native int setBitMode(long var1, int var3, int var4);

    public native int getBitMode(long var1);

    public native int setUSBParameters(long var1, int var3, int var4);

    public native long w32CreateFile(String var1, String var2, long var3, int var5, int var6, boolean var7);

    public native int w32CloseHandle(long var1);

    public native int w32ReadFile(long var1, byte[] var3, int var4);

    public native int w32WriteFile(long var1, byte[] var3, int var4);

    public native int w32GetOverlappedResult(long var1, boolean var3);

    public native int w32EscapeCommFunction(long var1, short var3);

    public native int w32GetCommModemStatus(long var1);

    public native int w32SetupComm(long var1, int var3, int var4);

    public native int w32SetCommState(long var1, int[] var3);

    public native int[] w32GetCommState(long var1);

    public native int w32SetCommTimeouts(long var1, int var3, int var4, int var5, int var6, int var7);

    public native int[] w32GetCommTimeouts(long var1);

    public native int w32SetCommBreak(long var1);

    public native int w32ClearCommBreak(long var1);

    public native int w32SetCommMask(long var1, int var3);

    public native int w32GetCommMask(long var1);

    public native int w32WaitCommEvent(long var1, int var3);

    public native int w32PurgeComm(long var1, int var3);

    public native String w32GetLastError(long var1);

    public native int[] w32ClearCommError(long var1);
}

