/*
 * Decompiled with CFR 0.152.
 */
package com.serialpundit.serial.internal;

import com.serialpundit.core.NativeLibLoader;
import com.serialpundit.core.SerialComException;
import com.serialpundit.core.SerialComSystemProperty;
import com.serialpundit.serial.SerialComLineErrors;
import com.serialpundit.serial.internal.SerialComLooper;
import com.serialpundit.serial.nullmodem.Itty2comHotPlugListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Comparator;

public final class SerialComPortJNIBridge {
    private static final Comparator<String> comparator = new Comparator<String>(){

        @Override
        public int compare(String valueA, String valueB) {
            int bl;
            if (valueA.equalsIgnoreCase(valueB)) {
                return valueA.compareTo(valueB);
            }
            int al = valueA.length();
            int minLength = al <= (bl = valueB.length()) ? al : bl;
            int shiftA = 0;
            int shiftB = 0;
            int i = 0;
            while (i < minLength) {
                char charB;
                char charA = valueA.charAt(i - shiftA);
                if (charA != (charB = valueB.charAt(i - shiftB))) {
                    if (Character.isDigit(charA) && Character.isDigit(charB)) {
                        int[] resultsA = new int[]{-1, i - shiftA};
                        String numVal = "";
                        int x22 = i - shiftA;
                        while (x22 < al) {
                            resultsA[1] = x22;
                            char c = valueA.charAt(x22);
                            if (!Character.isDigit(c)) break;
                            numVal = String.valueOf(numVal) + c;
                            ++x22;
                        }
                        try {
                            resultsA[0] = Integer.valueOf(numVal);
                        }
                        catch (Exception x22) {
                            // empty catch block
                        }
                        int[] resultsB = new int[]{-1, i - shiftB};
                        numVal = "";
                        int x = i - shiftB;
                        while (x < bl) {
                            resultsB[1] = x;
                            char c = valueB.charAt(x);
                            if (!Character.isDigit(c)) break;
                            numVal = String.valueOf(numVal) + c;
                            ++x;
                        }
                        try {
                            resultsB[0] = Integer.valueOf(numVal);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (resultsA[0] != resultsB[0]) {
                            return resultsA[0] - resultsB[0];
                        }
                        if (al < bl) {
                            i = resultsA[1];
                            shiftB = resultsA[1] - resultsB[1];
                        } else {
                            i = resultsB[1];
                            shiftA = resultsB[1] - resultsA[1];
                        }
                    } else if (Character.toLowerCase(charA) - Character.toLowerCase(charB) != 0) {
                        return Character.toLowerCase(charA) - Character.toLowerCase(charB);
                    }
                }
                ++i;
            }
            return valueA.compareToIgnoreCase(valueB);
        }
    };

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean loadNativeLibrary(String directoryPath, String loadedLibName, SerialComSystemProperty serialComSystemProperty, int osType, int cpuArch, int abiType, boolean hotDeploy) throws SerialComException {
        FileOutputStream output;
        InputStream input;
        String libExtension;
        File libFile;
        String libToExtractFromJar;
        File workingDir;
        String fileSeparator;
        block66: {
            block70: {
                block69: {
                    block68: {
                        block67: {
                            block65: {
                                String javaTmpDir = null;
                                String userHomeDir = null;
                                fileSeparator = null;
                                File baseDir = null;
                                workingDir = null;
                                boolean isTmpDir = false;
                                boolean isUserHomeDir = false;
                                libToExtractFromJar = null;
                                libFile = null;
                                libExtension = null;
                                input = null;
                                output = null;
                                fileSeparator = serialComSystemProperty.getfileSeparator();
                                if (fileSeparator == null) throw new SerialComException("The file.separator java system property is either null or empty !");
                                if (fileSeparator.length() == 0) {
                                    throw new SerialComException("The file.separator java system property is either null or empty !");
                                }
                                try {
                                    if (directoryPath == null) {
                                        javaTmpDir = serialComSystemProperty.getJavaIOTmpDir();
                                        if (javaTmpDir == null) throw new SerialComException("The java.io.tmpdir java system property is either null or empty !");
                                        if (javaTmpDir.length() == 0) {
                                            throw new SerialComException("The java.io.tmpdir java system property is either null or empty !");
                                        }
                                        baseDir = new File(javaTmpDir);
                                        if (baseDir.exists() && baseDir.isDirectory() && baseDir.canWrite()) {
                                            isTmpDir = true;
                                        } else {
                                            userHomeDir = serialComSystemProperty.getUserHome();
                                            if (userHomeDir == null) throw new SerialComException("The user.home java system property is either null or empty !");
                                            if (userHomeDir.length() == 0) {
                                                throw new SerialComException("The user.home java system property is either null or empty !");
                                            }
                                            baseDir = new File(userHomeDir);
                                            if (!baseDir.exists()) {
                                                throw new SerialComException("User home directory does not exist. Also unable to access tmp/temp directory !");
                                            }
                                            if (!baseDir.isDirectory()) {
                                                throw new SerialComException("User home directory is not a directory. Also unable to access tmp/temp directory !");
                                            }
                                            if (!baseDir.canWrite()) {
                                                throw new SerialComException("User home directory is not writeable (permissions ??). Also unable to access tmp/temp directory !");
                                            }
                                            isUserHomeDir = true;
                                        }
                                        workingDir = new File(String.valueOf(baseDir.toString()) + fileSeparator + "sp_tuartx1");
                                        if (!workingDir.exists() && !workingDir.mkdir()) {
                                            if (isTmpDir) {
                                                throw new SerialComException("Can not create sp_tuartx1 unique directory in tmp/temp directory !");
                                            }
                                            if (isUserHomeDir) {
                                                throw new SerialComException("Can not create sp_tuartx1 unique directory in user's home directory !");
                                            }
                                        }
                                    } else {
                                        baseDir = new File(directoryPath);
                                        if (!baseDir.exists()) {
                                            throw new SerialComException("Given " + directoryPath + " directory does not exist !");
                                        }
                                        if (!baseDir.isDirectory()) {
                                            throw new SerialComException("Given " + directoryPath + " is not a directory !");
                                        }
                                        if (!baseDir.canWrite()) {
                                            throw new SerialComException("Given " + directoryPath + " directory is not writeable !");
                                        }
                                        workingDir = baseDir;
                                    }
                                }
                                catch (Exception e) {
                                    throw (SerialComException)new SerialComException(e.getMessage()).initCause((Throwable)e);
                                }
                                if (cpuArch != 2) break block65;
                                switch (osType) {
                                    case 2: {
                                        libToExtractFromJar = "spcomwinx64.dll";
                                        libExtension = ".dll";
                                        break;
                                    }
                                    case 1: {
                                        libToExtractFromJar = "spcomlnxx64.so";
                                        libExtension = ".so";
                                        break;
                                    }
                                    case 4: {
                                        libToExtractFromJar = "spcommacx64.dylib";
                                        libExtension = ".dylib";
                                    }
                                }
                                break block66;
                            }
                            if (cpuArch != 1) break block67;
                            switch (osType) {
                                case 2: {
                                    libToExtractFromJar = "spcomwinx86.dll";
                                    libExtension = ".dll";
                                    break;
                                }
                                case 1: {
                                    libToExtractFromJar = "spcomlnxx86.so";
                                    libExtension = ".so";
                                    break;
                                }
                                case 4: {
                                    libToExtractFromJar = "spcommacx86.dylib";
                                    libExtension = ".dylib";
                                }
                            }
                            break block66;
                        }
                        if (cpuArch != 16) break block68;
                        if (osType != 1) throw new SerialComException("Please report us your platform !");
                        libExtension = ".so";
                        if (abiType == 1) {
                            libToExtractFromJar = "spcomlnxarmv8hf.so";
                            break block66;
                        } else if (abiType == 2) {
                            libToExtractFromJar = "spcomlnxarmv8el.so";
                        }
                        break block66;
                    }
                    if (cpuArch != 15) break block69;
                    if (osType != 1) throw new SerialComException("Please report us your platform !");
                    libExtension = ".so";
                    if (abiType == 1) {
                        libToExtractFromJar = "spcomlnxarmv7hf.so";
                        break block66;
                    } else if (abiType == 2) {
                        libToExtractFromJar = "spcomlnxarmv7el.so";
                    }
                    break block66;
                }
                if (cpuArch != 14) break block70;
                if (osType != 1) throw new SerialComException("Please report us your platform !");
                libExtension = ".so";
                if (abiType == 1) {
                    libToExtractFromJar = "spcomlnxarmv6hf.so";
                    break block66;
                } else if (abiType == 2) {
                    libToExtractFromJar = "spcomlnxarmv6el.so";
                }
                break block66;
            }
            if (cpuArch != 13) throw new SerialComException("This architecture is unknown to serialpundit. Please contact us !");
            if (osType == 1) {
                libExtension = ".so";
                libToExtractFromJar = "spcomlnxarmv5.so";
            }
        }
        try {
            if (hotDeploy) {
                try {
                    Class.forName("com.serialpundit.serial.internal.NativeLoaderUART");
                    return true;
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            try {
                try {
                    libFile = loadedLibName == null ? new File(String.valueOf(workingDir.getAbsolutePath()) + fileSeparator + libToExtractFromJar) : new File(String.valueOf(workingDir.getAbsolutePath()) + fileSeparator + loadedLibName.trim() + libExtension);
                    input = SerialComPortJNIBridge.class.getResourceAsStream("/" + libToExtractFromJar);
                    output = new FileOutputStream(libFile);
                    if (input == null) throw new SerialComException("Can not get shared library " + libToExtractFromJar + " resource as stream from sp-tty.jar file !");
                    byte[] buffer = new byte[4096];
                    while (true) {
                        int read;
                        if ((read = input.read(buffer)) == -1) {
                            output.flush();
                            output.close();
                            output = null;
                            if (libFile == null) throw new SerialComException("Can not extract native shared library " + libToExtractFromJar + " from sp-tty.jar file !");
                            if (!libFile.exists()) throw new SerialComException("Can not extract native shared library " + libToExtractFromJar + " from sp-tty.jar file !");
                            if (libFile.isFile()) break;
                            throw new SerialComException("Can not extract native shared library " + libToExtractFromJar + " from sp-tty.jar file !");
                        }
                        output.write(buffer, 0, read);
                    }
                }
                catch (Exception e) {
                    throw (SerialComException)new SerialComException(libFile.toString()).initCause((Throwable)e);
                }
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Exception exception) {}
            }
            if (!hotDeploy) {
                final File libFileFinal = libFile;
                AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        System.load(libFileFinal.toString());
                        return true;
                    }
                });
                return true;
            }
            InputStream cin = SerialComPortJNIBridge.class.getResourceAsStream("NativeLoaderUART.class");
            if (cin == null) {
                throw new SerialComException("NativeLoaderUART.class not found in jar file !");
            }
            NativeLibLoader nll = new NativeLibLoader("com.serialpundit.serial.internal.NativeLoaderUART", cin);
            nll.load(libFile.toString());
            cin.close();
            return true;
        }
        catch (Exception e) {
            throw (SerialComException)new SerialComException(e.getMessage()).initCause((Throwable)e);
        }
        catch (UnsatisfiedLinkError e) {
            throw (SerialComException)new SerialComException(e.getMessage()).initCause((Throwable)e);
        }
    }

    public native int initNativeLib();

    public native String getNativeLibraryVersion();

    public native String[] listAvailableComPorts();

    public native int setUpDataLooperThread(long var1, SerialComLooper var3);

    public native int setUpEventLooperThread(long var1, SerialComLooper var3);

    public native int destroyDataLooperThread(long var1);

    public native int destroyEventLooperThread(long var1);

    public native int pauseListeningEvents(long var1);

    public native int resumeListeningEvents(long var1);

    public native long openComPort(String var1, boolean var2, boolean var3, boolean var4);

    public native int closeComPort(long var1);

    public native byte[] readBytes(long var1, int var3);

    public native int readBytesP(long var1, byte[] var3, int var4, int var5, long var6, SerialComLineErrors var8);

    public native byte[] readBytesBlocking(long var1, int var3, long var4);

    public native int readBytesDirect(long var1, ByteBuffer var3, int var4, int var5);

    public native int writeBytes(long var1, byte[] var3, int var4);

    public native int writeBytesDirect(long var1, ByteBuffer var3, int var4, int var5);

    public native int writeSingleByte(long var1, byte var3);

    public native int writeBytesBlocking(long var1, byte[] var3, long var4);

    public native long createBlockingIOContext();

    public native int unblockBlockingIOOperation(long var1);

    public native int destroyBlockingIOContext(long var1);

    public native int setRTS(long var1, boolean var3);

    public native int setDTR(long var1, boolean var3);

    public native int[] getLinesStatus(long var1);

    public native int[] getInterruptCount(long var1);

    public native String findDriverServingComPort(String var1);

    public native String findIRQnumberForComPort(long var1);

    public native int sendBreak(long var1, int var3);

    public native int[] getByteCount(long var1);

    public native int clearPortIOBuffers(long var1, boolean var3, boolean var4);

    public native int configureComPortData(long var1, int var3, int var4, int var5, int var6, int var7);

    public native int configureComPortControl(long var1, int var3, byte var4, byte var5, boolean var6, boolean var7);

    public native int[] getCurrentConfigurationU(long var1);

    public native String[] getCurrentConfigurationW(long var1);

    public native int fineTuneRead(long var1, int var3, int var4, int var5, int var6, int var7);

    public native int setuptty2com();

    public native int unsetuptty2com();

    public native String[] listNextAvailablePorts();

    public native String[] listExistingStandardNullModemPorts();

    public native String[] listExistingCustomNullModemPorts();

    public native String[] listExistingStandardLoopbackPorts();

    public native String[] listExistingCustomLoopbackPorts();

    public native String[] listAllExistingPorts();

    public native String[] listAllExistingPortsWithInfo();

    public native String[] createStandardNullModemPair(int var1, int var2);

    public native String[] createCustomNullModemPair(int var1, int var2, int var3, boolean var4, int var5, int var6, int var7, boolean var8);

    public native String[] createStandardLoopBackDevice(int var1);

    public native String[] createCustomLoopBackDevice(int var1, int var2, int var3, boolean var4);

    public native int destroyAllCreatedVirtualDevices();

    public native int destroyAllCreatedNullModemPairs();

    public native int destroyAllCreatedLoopbackDevices();

    public native int destroyGivenVirtualDevice(String var1);

    public native String[] getLastLoopBackDeviceNode();

    public native String[] getLastNullModemPairNodes();

    public native int emulateSerialEvent(String var1, int var2);

    public native int emulateLineRingingEvent(String var1, boolean var2);

    public native int registerTTY2COMHotPlugEventListener(Itty2comHotPlugListener var1, String var2);

    public native int unregisterTTY2COMHotPlugEventListener(int var1);

    public native String[] getStatsForGivenDevice(String var1);

    public native Object emulateFaultyCable(String var1, boolean var2);
}

