/*
 * Decompiled with CFR 0.152.
 */
package com.serialpundit.serial.mapper;

import com.serialpundit.core.SerialComException;
import com.serialpundit.serial.internal.SerialComPortMapperJNIBridge;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class SerialComPortMapper {
    private final Object lock = new Object();
    private HashMap<String, String> localInfo = new HashMap();
    private final SerialComPortMapperJNIBridge mSerialComPortMapperJNIBridge;

    public SerialComPortMapper(SerialComPortMapperJNIBridge mSerialComPortMapperJNIBridge) {
        this.mSerialComPortMapperJNIBridge = mSerialComPortMapperJNIBridge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startMappingService() throws SerialComException {
        Object object = this.lock;
        synchronized (object) {
            int ret = this.mSerialComPortMapperJNIBridge.startMappingService();
            if (ret < 0) {
                throw new SerialComException("Could not start serial port mapping service. Please retry !");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopMappingService() throws SerialComException {
        Object object = this.lock;
        synchronized (object) {
            int ret = this.mSerialComPortMapperJNIBridge.stopMappingService();
            if (ret < 0) {
                throw new SerialComException("Could not stop serial port mapping service. Please retry !");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mapAliasToExistingComPort(String alias, String comPort) throws SerialComException {
        if (alias == null) {
            throw new IllegalArgumentException("Argument alias can not be null !");
        }
        String aliasVal = alias.trim();
        if (aliasVal.length() == 0) {
            throw new IllegalArgumentException("Argument alias can not be empty string !");
        }
        if (comPort == null) {
            throw new IllegalArgumentException("Argument comPort can not be null !");
        }
        String comPortVal = comPort.trim();
        if (comPortVal.length() == 0) {
            throw new IllegalArgumentException("Argument comPort can not be empty string !");
        }
        Object object = this.lock;
        synchronized (object) {
            int ret = this.mSerialComPortMapperJNIBridge.mapAliasToExistingComPort(alias, comPort);
            if (ret < 0) {
                throw new SerialComException("Could not map given alias to serial port. Please retry !");
            }
            this.localInfo.put(alias, comPort);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unmapAliasToExistingComPort(String alias) throws SerialComException {
        if (alias == null) {
            throw new IllegalArgumentException("Argument alias can not be null !");
        }
        String aliasVal = alias.trim();
        if (aliasVal.length() == 0) {
            throw new IllegalArgumentException("Argument alias can not be empty string !");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.localInfo.containsKey(alias)) {
                int ret = this.mSerialComPortMapperJNIBridge.unmapAliasToExistingComPort(alias);
                if (ret < 0) {
                    throw new SerialComException("Could not remove given alias to serial port. Please retry !");
                }
            } else {
                throw new SerialComException("Could not remove given alias to serial port. Please retry !");
            }
            this.localInfo.remove(alias);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> listCreatedAliases() {
        Map<String, String> aliasList;
        Object object = this.lock;
        synchronized (object) {
            aliasList = Collections.unmodifiableMap(this.localInfo);
        }
        return aliasList;
    }
}

