/*
 * Decompiled with CFR 0.152.
 */
package com.serialpundit.serial.nullmodem;

import com.serialpundit.core.SerialComException;
import com.serialpundit.serial.internal.SerialComPortJNIBridge;
import com.serialpundit.serial.nullmodem.Itty2comHotPlugListener;

public final class SerialComNullModem {
    public static final int SP_CON_NONE = 0;
    public static final int SP_CON_CTS = 1;
    public static final int SP_CON_DCD = 2;
    public static final int SP_CON_DSR = 4;
    public static final int SP_CON_RI = 8;
    public static final int ERR_FRAME = 16;
    public static final int ERR_PARITY = 32;
    public static final int ERR_OVERRUN = 64;
    public static final int RCV_BREAK = 128;
    public static final int DEV_ADDED = 1;
    public static final int DEV_REMOVED = 2;
    private final SerialComPortJNIBridge mComPortJNIBridge;
    private final Object lockA = new Object();
    private final Object lockB = new Object();

    public SerialComNullModem(SerialComPortJNIBridge mComPortJNIBridge) throws SerialComException {
        this.mComPortJNIBridge = mComPortJNIBridge;
    }

    public void initialize() throws SerialComException {
        this.mComPortJNIBridge.setuptty2com();
    }

    public void deinitialize() throws SerialComException {
        this.mComPortJNIBridge.unsetuptty2com();
    }

    public String[] listNextAvailablePorts() throws SerialComException {
        return this.mComPortJNIBridge.listNextAvailablePorts();
    }

    public String[] listExistingStandardNullModemPorts() throws SerialComException {
        return this.mComPortJNIBridge.listExistingStandardNullModemPorts();
    }

    public String[] listExistingCustomNullModemPorts() throws SerialComException {
        return this.mComPortJNIBridge.listExistingCustomNullModemPorts();
    }

    public String[] listExistingStandardLoopbackPorts() throws SerialComException {
        return this.mComPortJNIBridge.listExistingStandardLoopbackPorts();
    }

    public String[] listExistingCustomLoopbackPorts() throws SerialComException {
        return this.mComPortJNIBridge.listExistingCustomLoopbackPorts();
    }

    public String[] listAllExistingPorts() throws SerialComException {
        return this.mComPortJNIBridge.listAllExistingPorts();
    }

    public String[] listAllExistingPortsWithInfo() throws SerialComException {
        return this.mComPortJNIBridge.listAllExistingPortsWithInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] createStandardNullModemPair(int deviceIndex1, int deviceIndex2) throws SerialComException {
        String[] result = null;
        if (deviceIndex1 < -1 || deviceIndex1 > 65535) {
            throw new IllegalArgumentException("deviceIndex1 should be -1 <= deviceIndex1 =< 65535 !");
        }
        if (deviceIndex2 < -1 || deviceIndex2 > 65535) {
            throw new IllegalArgumentException("deviceIndex2 should be -1 <= deviceIndex1 =< 65535 !");
        }
        if (deviceIndex1 != -1 && deviceIndex2 != -1 && deviceIndex1 == deviceIndex2) {
            throw new IllegalArgumentException("Both deviceIndex1 and deviceIndex2 can not be same !");
        }
        Object object = this.lockA;
        synchronized (object) {
            result = this.mComPortJNIBridge.createStandardNullModemPair(deviceIndex1, deviceIndex2);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] createCustomNullModemPair(int idx1, int rtsMap1, int dtrMap1, boolean setDTRatOpen1, int idx2, int rtsMap2, int dtrMap2, boolean setDTRatOpen2) throws SerialComException {
        String[] result = null;
        if (idx1 < -1 || idx1 > 65535) {
            throw new IllegalArgumentException("idx1 should be -1 <= idx1 =< 65535 !");
        }
        if (idx2 < -1 || idx2 > 65535) {
            throw new IllegalArgumentException("idx2 should be -1 <= idx2 =< 65535 !");
        }
        if (idx1 != -1 && idx2 != -1 && idx1 == idx2) {
            throw new IllegalArgumentException("Both device indexs idx1 and idx2 can not be same !");
        }
        Object object = this.lockA;
        synchronized (object) {
            result = this.mComPortJNIBridge.createCustomNullModemPair(idx1, rtsMap1, dtrMap1, setDTRatOpen1, idx2, rtsMap2, dtrMap2, setDTRatOpen2);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] createStandardLoopBackDevice(int deviceIndex) throws SerialComException {
        String[] result = null;
        if (deviceIndex < -1 || deviceIndex > 65535) {
            throw new IllegalArgumentException("deviceIndex should be -1 <= deviceIndex =< 65535 !");
        }
        Object object = this.lockA;
        synchronized (object) {
            result = this.mComPortJNIBridge.createStandardLoopBackDevice(deviceIndex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] createCustomLoopBackDevice(int deviceIndex, int rtsMap, int dtrMap, boolean setDTRatOpen) throws SerialComException {
        String[] result = null;
        if (deviceIndex < -1 || deviceIndex > 65535) {
            throw new IllegalArgumentException("deviceIndex should be -1 <= deviceIndex =< 65535 !");
        }
        Object object = this.lockA;
        synchronized (object) {
            result = this.mComPortJNIBridge.createCustomLoopBackDevice(deviceIndex, rtsMap, dtrMap, setDTRatOpen);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroyAllCreatedVirtualDevices() throws SerialComException {
        Object object = this.lockA;
        synchronized (object) {
            int ret = this.mComPortJNIBridge.destroyAllCreatedVirtualDevices();
            if (ret < 0) {
                throw new SerialComException("Can not destroy created virtual devices !");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroyAllCreatedNullModemPairs() throws SerialComException {
        Object object = this.lockA;
        synchronized (object) {
            int ret = this.mComPortJNIBridge.destroyAllCreatedNullModemPairs();
            if (ret < 0) {
                throw new SerialComException("Can not destroy created null modem pairs/devices !");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroyAllCreatedLoopbackDevices() throws SerialComException {
        Object object = this.lockA;
        synchronized (object) {
            int ret = this.mComPortJNIBridge.destroyAllCreatedLoopbackDevices();
            if (ret < 0) {
                throw new SerialComException("Can not destroy created loopback devices !");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroyGivenVirtualDevice(String device) throws SerialComException {
        if (device == null || device.length() == 0) {
            throw new SerialComException("Invalid virtual device !");
        }
        Object object = this.lockA;
        synchronized (object) {
            int ret = this.mComPortJNIBridge.destroyGivenVirtualDevice(device);
            if (ret < 0) {
                throw new SerialComException("Can not destroy given virtual device !");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLastLoopBackDeviceNode() throws SerialComException {
        String[] result = null;
        Object object = this.lockA;
        synchronized (object) {
            result = this.mComPortJNIBridge.getLastLoopBackDeviceNode();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLastNullModemPairNodes() throws SerialComException {
        String[] result = null;
        Object object = this.lockA;
        synchronized (object) {
            result = this.mComPortJNIBridge.getLastNullModemPairNodes();
        }
        return result;
    }

    public boolean emulateSerialEvent(String devNode, int error) throws SerialComException {
        if (devNode == null || devNode.length() == 0) {
            throw new IllegalArgumentException("The devNode can not be null or empty string !");
        }
        int ret = this.mComPortJNIBridge.emulateSerialEvent(devNode, error);
        if (ret < 0) {
            throw new SerialComException("Can not emulate specified event on given device !");
        }
        return true;
    }

    public boolean emulateLineRingingEvent(String devNode, boolean state) throws SerialComException {
        if (devNode == null || devNode.length() == 0) {
            throw new IllegalArgumentException("The devNode can not be null or empty string !");
        }
        int ret = this.mComPortJNIBridge.emulateLineRingingEvent(devNode, state);
        if (ret < 0) {
            throw new SerialComException("Can not emulate ringing event on given device !");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerTTY2COMHotPlugEventListener(Itty2comHotPlugListener hotPlugListener, String deviceNode) throws SerialComException {
        int opaqueHandle = 0;
        if (hotPlugListener == null) {
            throw new IllegalArgumentException("Argument hotPlugListener can not be null !");
        }
        Object object = this.lockB;
        synchronized (object) {
            opaqueHandle = this.mComPortJNIBridge.registerTTY2COMHotPlugEventListener(hotPlugListener, deviceNode);
            if (opaqueHandle < 0) {
                throw new SerialComException("Can't register virtual serial device hotplug listener. Please retry !");
            }
        }
        return opaqueHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterTTY2COMHotPlugEventListener(int opaqueHandle) throws SerialComException {
        if (opaqueHandle < 0) {
            throw new IllegalArgumentException("Argument opaqueHandle can not be negative !");
        }
        Object object = this.lockB;
        synchronized (object) {
            int ret = this.mComPortJNIBridge.unregisterTTY2COMHotPlugEventListener(opaqueHandle);
            if (ret < 0) {
                throw new SerialComException("Can't unregister virtual serial device hotplug listener. Please retry !");
            }
        }
        return true;
    }

    public String[] getStatsForGivenDevice(String deviceNode) throws SerialComException {
        return this.mComPortJNIBridge.getStatsForGivenDevice(deviceNode);
    }

    public void emulateFaultyCable(String deviceNode, boolean state) throws SerialComException {
        this.mComPortJNIBridge.emulateFaultyCable(deviceNode, state);
    }
}

