/*
 * Decompiled with CFR 0.152.
 */
package com.serialpundit.serial.vendor;

import com.serialpundit.core.SerialComException;
import com.serialpundit.core.SerialComSystemProperty;
import com.serialpundit.serial.internal.SerialComMCHPSIOJNIBridge;
import com.serialpundit.serial.vendor.SerialComVendorLib;
import java.io.File;

public final class SerialComMCHPSimpleIO
extends SerialComVendorLib {
    public static final int OFF = 0;
    public static final int ON = 1;
    public static final int TOGGLE = 3;
    public static final int BLINKSLOW = 4;
    public static final int BLINKFAST = 5;
    private final SerialComMCHPSIOJNIBridge mSerialComMCHPSIOJNIBridge = new SerialComMCHPSIOJNIBridge();

    public SerialComMCHPSimpleIO(File libDirectory, String vlibName, int cpuArch, int osType, SerialComSystemProperty serialComSystemProperty) throws SerialComException {
        SerialComMCHPSIOJNIBridge.loadNativeLibrary(libDirectory, vlibName, cpuArch, osType, serialComSystemProperty);
    }

    public boolean initMCP2200(int vendorID, int productID) throws SerialComException {
        if (vendorID < 0 || vendorID > 65535) {
            throw new IllegalArgumentException("initMCP2200(), Argument vendorID can not be negative or greater tha 0xFFFF !");
        }
        if (productID < 0 || productID > 65535) {
            throw new IllegalArgumentException("initMCP2200(), Argument productID can not be negative or greater tha 0xFFFF !");
        }
        int ret = this.mSerialComMCHPSIOJNIBridge.initMCP2200(vendorID, productID);
        if (ret < 0) {
            throw new SerialComException("Could not configure the for specific device. Please retry !");
        }
        return true;
    }

    public boolean isConnected() throws SerialComException {
        int ret = this.mSerialComMCHPSIOJNIBridge.isConnected();
        if (ret < 0) {
            throw new SerialComException("Could not determine whether device is connected or not. Please retry !");
        }
        return true;
    }

    public boolean configureMCP2200(byte ioMap, long baudRateParam, int rxLEDMode, int txLEDMode, boolean flow, boolean uload, boolean sspnd, boolean invert) throws SerialComException {
        int ret = this.mSerialComMCHPSIOJNIBridge.configureMCP2200(ioMap, baudRateParam, rxLEDMode, txLEDMode, flow, uload, sspnd, invert);
        if (ret < 0) {
            throw new SerialComException("Could not configure the device using given parameters. Please retry !");
        }
        return true;
    }

    public boolean setPin(int pinNumber) throws SerialComException {
        int ret = this.mSerialComMCHPSIOJNIBridge.setPin(pinNumber);
        if (ret < 0) {
            throw new SerialComException("Could not set the given pin to logic 1. Please retry !");
        }
        return true;
    }

    public boolean clearPin(int pinNumber) throws SerialComException {
        int ret = this.mSerialComMCHPSIOJNIBridge.clearPin(pinNumber);
        if (ret < 0) {
            throw new SerialComException("Could not set the given pin to logic 1. Please retry !");
        }
        return true;
    }

    public int readPinValue(int pinNumber) throws SerialComException {
        int ret = this.mSerialComMCHPSIOJNIBridge.readPinValue(pinNumber);
        if (ret < 0) {
            throw new SerialComException("Could not read the given pin's value. Please retry !");
        }
        return ret;
    }

    public int readPin(int pinNumber) throws SerialComException {
        int ret = this.mSerialComMCHPSIOJNIBridge.readPin(pinNumber);
        if (ret < 0) {
            throw new SerialComException("Could not read the given pin's value. Please retry !");
        }
        return ret;
    }

    public boolean writePort(int portValue) throws SerialComException {
        int ret = this.mSerialComMCHPSIOJNIBridge.writePort(portValue);
        if (ret < 0) {
            throw new SerialComException("Could not write the given value to port. Please retry !");
        }
        return true;
    }

    public int readPort() throws SerialComException {
        int ret = this.mSerialComMCHPSIOJNIBridge.readPort();
        if (ret < 0) {
            throw new SerialComException("Could not read the port value. Please retry !");
        }
        return ret;
    }

    public int readPortValue() throws SerialComException {
        int ret = this.mSerialComMCHPSIOJNIBridge.readPortValue();
        if (ret < 0) {
            throw new SerialComException("Could not read the port value. Please retry !");
        }
        return ret;
    }

    public boolean selectDevice(int uiDeviceNumber) throws SerialComException {
        int ret = this.mSerialComMCHPSIOJNIBridge.selectDevice(uiDeviceNumber);
        if (ret < 0) {
            throw new SerialComException("Could not select the given device. Please retry !");
        }
        return true;
    }

    public int getSelectedDevice() throws SerialComException {
        int ret = this.mSerialComMCHPSIOJNIBridge.getSelectedDevice();
        if (ret < 0) {
            throw new SerialComException("Could not get the currently selected device. Please retry !");
        }
        return ret;
    }

    public int getNumOfDevices() throws SerialComException {
        int ret = this.mSerialComMCHPSIOJNIBridge.getNumOfDevices();
        if (ret < 0) {
            throw new SerialComException("Could not find the number of devices currently present in system. Please retry !");
        }
        return ret;
    }

    public String getDeviceInfo(int uiDeviceNumber) throws SerialComException {
        String ret = this.mSerialComMCHPSIOJNIBridge.getDeviceInfo(uiDeviceNumber);
        if (ret == null) {
            throw new SerialComException("Could not find the path name of the requested device. Please retry !");
        }
        return ret;
    }

    public String getSelectedDeviceInfo() throws SerialComException {
        String ret = this.mSerialComMCHPSIOJNIBridge.getSelectedDeviceInfo();
        if (ret == null) {
            throw new SerialComException("Could not find the path name of the selected device. Please retry !");
        }
        return ret;
    }

    public int readEEPROM(int uiEEPAddress) throws SerialComException {
        int ret = this.mSerialComMCHPSIOJNIBridge.readEEPROM(uiEEPAddress);
        if (ret < 0) {
            throw new SerialComException("Could not read the value from given EEPROM address. Please retry !");
        }
        return ret;
    }

    public boolean writeEEPROM(int uiEEPAddress, short ucValue) throws SerialComException {
        int ret = this.mSerialComMCHPSIOJNIBridge.writeEEPROM(uiEEPAddress, ucValue);
        if (ret < 0) {
            throw new SerialComException("Could not write the value at given EEPROM address. Please retry !");
        }
        return true;
    }

    public boolean fnRxLED(int mode) throws SerialComException {
        int ret = this.mSerialComMCHPSIOJNIBridge.fnRxLED(mode);
        if (ret < 0) {
            throw new SerialComException("Could not set the operating mode for RX LED. Please retry !");
        }
        return true;
    }

    public boolean fnTxLED(int mode) throws SerialComException {
        int ret = this.mSerialComMCHPSIOJNIBridge.fnTxLED(mode);
        if (ret < 0) {
            throw new SerialComException("Could not set the operating mode for TX LED. Please retry !");
        }
        return true;
    }

    public boolean hardwareFlowControl(int onOff) throws SerialComException {
        int ret = this.mSerialComMCHPSIOJNIBridge.hardwareFlowControl(onOff);
        if (ret < 0) {
            throw new SerialComException("Could not set the flow control as requested. Please retry !");
        }
        return true;
    }

    public boolean fnULoad(int onOff) throws SerialComException {
        int ret = this.mSerialComMCHPSIOJNIBridge.fnULoad(onOff);
        if (ret < 0) {
            throw new SerialComException("Could not configure the GP1 as requested. Please retry !");
        }
        return true;
    }

    public boolean fnSuspend(int onOff) throws SerialComException {
        int ret = this.mSerialComMCHPSIOJNIBridge.fnSuspend(onOff);
        if (ret < 0) {
            throw new SerialComException("Could not configure the GP0 as requested. Please retry !");
        }
        return true;
    }

    public boolean fnInvertUartPol(int onOff) throws SerialComException {
        int ret = this.mSerialComMCHPSIOJNIBridge.fnInvertUartPol(onOff);
        if (ret < 0) {
            throw new SerialComException("Could not configure the UART polarity as requested. Please retry !");
        }
        return true;
    }

    public boolean fnSetBaudRate(long baudRateParam) throws SerialComException {
        int ret = this.mSerialComMCHPSIOJNIBridge.fnSetBaudRate(baudRateParam);
        if (ret < 0) {
            throw new SerialComException("Could not set the baud rate on device as requested. Please retry !");
        }
        return true;
    }

    public boolean configureIO(short ioMap) throws SerialComException {
        int ret = this.mSerialComMCHPSIOJNIBridge.configureIO(ioMap);
        if (ret < 0) {
            throw new SerialComException("Could not configure the GPIO as requested. Please retry !");
        }
        return true;
    }

    public boolean configureIoDefaultOutput(short ioMap, short ucDefValue) throws SerialComException {
        int ret = this.mSerialComMCHPSIOJNIBridge.configureIoDefaultOutput(ioMap, ucDefValue);
        if (ret < 0) {
            throw new SerialComException("Could not configure the GPIO as requested. Please retry !");
        }
        return true;
    }
}

