/*
 * Decompiled with CFR 0.152.
 */
package com.serialpundit.serial.vendor;

import com.serialpundit.core.SerialComException;
import com.serialpundit.core.SerialComSystemProperty;
import com.serialpundit.serial.internal.SerialComCP210xManufacturingJNIBridge;
import com.serialpundit.serial.vendor.CP210XbaudConfigs;
import com.serialpundit.serial.vendor.SerialComVendorLib;
import java.io.File;

public final class SerialComSLabsCP210xManufacturing
extends SerialComVendorLib {
    public static final int CP210x_RETURN_SERIAL_NUMBER = 0;
    public static final int CP210x_RETURN_DESCRIPTION = 1;
    public static final int CP210x_RETURN_FULL_PATH = 2;
    public static final int FC_OPEN_TX = 1;
    public static final int FC_OPEN_RX = 2;
    public static final int FC_CLOSE_TX = 4;
    public static final int FC_CLOSE_RX = 8;
    public static final int FC_OPEN_TX_SCI = 1;
    public static final int FC_OPEN_RX_SCI = 2;
    public static final int FC_CLOSE_TX_SCI = 4;
    public static final int FC_CLOSE_RX_SCI = 8;
    public static final int FC_OPEN_TX_ECI = 16;
    public static final int FC_OPEN_RX_ECI = 32;
    public static final int FC_CLOSE_TX_ECI = 64;
    public static final int FC_CLOSE_RX_ECI = 128;
    public static final int FC_OPEN_TX_IFC0 = 1;
    public static final int FC_OPEN_RX_IFC0 = 2;
    public static final int FC_CLOSE_TX_IFC0 = 4;
    public static final int FC_CLOSE_RX_IFC0 = 8;
    public static final int FC_OPEN_TX_IFC1 = 16;
    public static final int FC_OPEN_RX_IFC1 = 32;
    public static final int FC_CLOSE_TX_IFC1 = 64;
    public static final int FC_CLOSE_RX_IFC1 = 128;
    public static final int FC_OPEN_TX_IFC2 = 256;
    public static final int FC_OPEN_RX_IFC2 = 512;
    public static final int FC_CLOSE_TX_IFC2 = 1024;
    public static final int FC_CLOSE_RX_IFC2 = 2048;
    public static final int FC_OPEN_TX_IFC3 = 4096;
    public static final int FC_OPEN_RX_IFC3 = 8192;
    public static final int FC_CLOSE_TX_IFC3 = 16384;
    public static final int FC_CLOSE_RX_IFC3 = 32768;
    public static final int PORT_RI_ON = 1;
    public static final int PORT_DCD_ON = 2;
    public static final int PORT_DTR_ON = 4;
    public static final int PORT_DSR_ON = 8;
    public static final int PORT_TXD_ON = 16;
    public static final int PORT_RXD_ON = 32;
    public static final int PORT_RTS_ON = 64;
    public static final int PORT_CTS_ON = 128;
    public static final int PORT_GPIO_0_ON = 256;
    public static final int PORT_GPIO_1_ON = 512;
    public static final int PORT_GPIO_2_ON = 1024;
    public static final int PORT_GPIO_3_ON = 2048;
    public static final int PORT_SUSPEND_ON = 16384;
    public static final int PORT_SUSPEND_BAR_ON = 32768;
    public static final int EF_GPIO_0_TXLED = 1;
    public static final int EF_GPIO_1_RXLED = 2;
    public static final int EF_GPIO_2_RS485 = 4;
    public static final int EF_RS485_INVERT = 8;
    public static final int EF_WEAKPULLUP = 16;
    public static final int EF_RESERVED_1 = 32;
    public static final int EF_SERIAL_DYNAMIC_SUSPEND = 64;
    public static final int EF_GPIO_DYNAMIC_SUSPEND = 128;
    public static final int PORT_RI_SCI_ON = 1;
    public static final int PORT_DCD_SCI_ON = 2;
    public static final int PORT_DTR_SCI_ON = 4;
    public static final int PORT_DSR_SCI_ON = 8;
    public static final int PORT_TXD_SCI_ON = 16;
    public static final int PORT_RXD_SCI_ON = 32;
    public static final int PORT_RTS_SCI_ON = 64;
    public static final int PORT_CTS_SCI_ON = 128;
    public static final int PORT_GPIO_0_SCI_ON = 2;
    public static final int PORT_GPIO_1_SCI_ON = 4;
    public static final int PORT_GPIO_2_SCI_ON = 8;
    public static final int PORT_SUSPEND_SCI_ON = 1;
    public static final int PORT_RI_ECI_ON = 256;
    public static final int PORT_DCD_ECI_ON = 512;
    public static final int PORT_DTR_ECI_ON = 1024;
    public static final int PORT_DSR_ECI_ON = 2048;
    public static final int PORT_TXD_ECI_ON = 4096;
    public static final int PORT_RXD_ECI_ON = 8192;
    public static final int PORT_RTS_ECI_ON = 16384;
    public static final int PORT_CTS_ECI_ON = 32768;
    public static final int PORT_GPIO_0_ECI_ON = 1024;
    public static final int PORT_GPIO_1_ECI_ON = 2048;
    public static final int PORT_SUSPEND_ECI_ON = 256;
    public static final int EF_GPIO_0_TXLED_ECI = 1;
    public static final int EF_GPIO_1_RXLED_ECI = 2;
    public static final int EF_GPIO_1_RS485_ECI = 4;
    public static final int CP2105_EF_RS485_INVERT = 8;
    public static final int EF_INVERT_SUSPEND_ECI = 16;
    public static final int EF_DYNAMIC_SUSPEND_ECI = 64;
    public static final int EF_GPIO_0_TXLED_SCI = 1;
    public static final int EF_GPIO_1_RXLED_SCI = 2;
    public static final int EF_INVERT_SUSPEND_SCI = 16;
    public static final int EF_DYNAMIC_SUSPEND_SCI = 64;
    public static final int CP2105_EF_WEAKPULLUP = 16;
    public static final int PB0_PORT_TX0 = 1;
    public static final int PB0_PORT_RX0 = 2;
    public static final int PB0_PORT_RTS0 = 4;
    public static final int PB0_PORT_CTS0 = 8;
    public static final int PB0_PORT_DTR0 = 16;
    public static final int PB0_PORT_DSR0 = 32;
    public static final int PB0_PORT_DCD0 = 64;
    public static final int PB0_PORT_RI0 = 128;
    public static final int PB0_PORT_TX1 = 256;
    public static final int PB0_PORT_RX1 = 512;
    public static final int PB0_PORT_RTS1 = 1024;
    public static final int PB0_PORT_CTS1 = 2048;
    public static final int PB0_PORT_DTR1 = 4096;
    public static final int PB0_PORT_DSR1 = 8192;
    public static final int PB0_PORT_DCD1 = 16384;
    public static final int PB0_PORT_RI1 = 32768;
    public static final int PB1_PORT_GPIO_0 = 1;
    public static final int PB1_PORT_GPIO_1 = 2;
    public static final int PB1_PORT_GPIO_2 = 4;
    public static final int PB1_PORT_GPIO_3 = 8;
    public static final int PB1_PORT_GPIO_4 = 16;
    public static final int PB1_PORT_GPIO_5 = 32;
    public static final int PB1_PORT_GPIO_6 = 64;
    public static final int PB1_PORT_GPIO_7 = 128;
    public static final int PB1_PORT_GPIO_8 = 256;
    public static final int PB1_PORT_GPIO_9 = 512;
    public static final int PB1_PORT_GPIO_10 = 1024;
    public static final int PB1_PORT_GPIO_11 = 2048;
    public static final int PB1_PORT_GPIO_12 = 4096;
    public static final int PB1_PORT_GPIO_13 = 8192;
    public static final int PB1_PORT_GPIO_14 = 16384;
    public static final int PB1_PORT_GPIO_15 = 32768;
    public static final int PB2_PORT_SUSPEND = 1;
    public static final int PB2_PORT_SUSPEND_BAR = 2;
    public static final int PB2_PORT_DTR2 = 4;
    public static final int PB2_PORT_DSR2 = 8;
    public static final int PB3_PORT_TX2 = 1;
    public static final int PB3_PORT_RX2 = 2;
    public static final int PB3_PORT_RTS2 = 4;
    public static final int PB3_PORT_CTS2 = 8;
    public static final int PB3_PORT_DCD2 = 16;
    public static final int PB3_PORT_RI2 = 32;
    public static final int PB3_PORT_DTR3 = 64;
    public static final int PB3_PORT_DSR3 = 128;
    public static final int PB3_PORT_DCD3 = 256;
    public static final int PB3_PORT_RI3 = 512;
    public static final int PB4_PORT_RTS3 = 1;
    public static final int PB4_PORT_CTS3 = 2;
    public static final int PB4_PORT_TX3 = 4;
    public static final int PB4_PORT_RX3 = 8;
    public static final int EF_IFC_GPIO_TXLED = 1;
    public static final int EF_IFC_GPIO_RXLED = 2;
    public static final int EF_IFC_GPIO_RS485 = 4;
    public static final int EF_IFC_GPIO_RS485_LOGIC = 8;
    public static final int EF_IFC_GPIO_CLOCK = 16;
    public static final int EF_IFC_DYNAMIC_SUSPEND = 64;
    public static final int EF_DEVICE_WEAKPULLUP_RESET = 16;
    public static final int EF_DEVICE_WEAKPULLUP_SUSPEND = 32;
    public static final int EF_DEVICE_DYNAMIC_SUSPEND = 64;
    private final SerialComCP210xManufacturingJNIBridge mSerialComCP210xManufacturingJNIBridge = new SerialComCP210xManufacturingJNIBridge();

    public SerialComSLabsCP210xManufacturing(File libDirectory, String vlibName, int cpuArch, int osType, SerialComSystemProperty serialComSystemProperty) throws SerialComException {
        SerialComCP210xManufacturingJNIBridge.loadNativeLibrary(libDirectory, vlibName, cpuArch, osType, serialComSystemProperty);
    }

    public int getNumDevices() throws SerialComException {
        int ret = this.mSerialComCP210xManufacturingJNIBridge.getNumDevices();
        if (ret < 0) {
            throw new SerialComException("Could not get the number of devices connected to host. Please retry !");
        }
        return ret;
    }

    public String getProductString(int index, int flag) throws SerialComException {
        String ret = null;
        if (flag == 2 || flag == 1 || flag == 0) {
            ret = this.mSerialComCP210xManufacturingJNIBridge.getProductString(index, flag);
            if (ret == null) {
                throw new SerialComException("Could not get the requested information. Please retry !");
            }
            return ret;
        }
        throw new IllegalArgumentException("Invalid flag passed for requested operation !");
    }

    public long open(int index) throws SerialComException {
        if (index < 0) {
            throw new IllegalArgumentException("Argument index can not be negative !");
        }
        long handle = this.mSerialComCP210xManufacturingJNIBridge.open(index);
        if (handle < 0L) {
            throw new SerialComException("Could not open the requested device at given index. Please retry !");
        }
        return handle;
    }

    public boolean close(long handle) throws SerialComException {
        int ret = this.mSerialComCP210xManufacturingJNIBridge.close(handle);
        if (ret < 0) {
            throw new SerialComException("Could not close the requested device. Please retry !");
        }
        return true;
    }

    public String getPartNumber(long handle) throws SerialComException {
        String ret = this.mSerialComCP210xManufacturingJNIBridge.getPartNumber(handle);
        if (ret == null) {
            throw new SerialComException("Could not get the part number. Please retry !");
        }
        return ret;
    }

    public boolean setVid(long handle, int vid) throws SerialComException {
        int ret = this.mSerialComCP210xManufacturingJNIBridge.setVid(handle, vid);
        if (ret < 0) {
            throw new SerialComException("Could not set the USB VID. Please retry !");
        }
        return true;
    }

    public boolean setPid(long handle, int pid) throws SerialComException {
        int ret = this.mSerialComCP210xManufacturingJNIBridge.setPid(handle, pid);
        if (ret < 0) {
            throw new SerialComException("Could not set the USB PID. Please retry !");
        }
        return true;
    }

    public boolean setProductString(long handle, String product) throws SerialComException {
        int ret = this.mSerialComCP210xManufacturingJNIBridge.setProductString(handle, product);
        if (ret < 0) {
            throw new SerialComException("Could not set description for the product. Please retry !");
        }
        return true;
    }

    public boolean setSerialNumber(long handle, String serialNumber) throws SerialComException {
        int ret = this.mSerialComCP210xManufacturingJNIBridge.setSerialNumber(handle, serialNumber);
        if (ret < 0) {
            throw new SerialComException("Could not set serial number for the product. Please retry !");
        }
        return true;
    }

    public boolean setInterfaceString(long handle, byte bInterfaceNumber, String interfaceString) throws SerialComException {
        int ret = this.mSerialComCP210xManufacturingJNIBridge.setInterfaceString(handle, bInterfaceNumber, interfaceString);
        if (ret < 0) {
            throw new SerialComException("Could not set interface string. Please retry !");
        }
        return true;
    }

    public boolean setSelfPower(long handle, boolean selfPower) throws SerialComException {
        int ret = this.mSerialComCP210xManufacturingJNIBridge.setSelfPower(handle, selfPower);
        if (ret < 0) {
            throw new SerialComException("Could not set/clear Self-Powered bit for the product. Please retry !");
        }
        return true;
    }

    public boolean setMaxPower(long handle, byte maxPower) throws SerialComException {
        int ret = this.mSerialComCP210xManufacturingJNIBridge.setMaxPower(handle, maxPower);
        if (ret < 0) {
            throw new SerialComException("Could not set the max power field for the product. Please retry !");
        }
        return true;
    }

    public boolean setFlushBufferConfig(long handle, int flag) throws SerialComException {
        if (flag > 15) {
            throw new IllegalArgumentException("Invalid flag passed for the requested operation !");
        }
        int ret = this.mSerialComCP210xManufacturingJNIBridge.setFlushBufferConfig(handle, flag);
        if (ret < 0) {
            throw new SerialComException("Could not set the flushing configuration for the product. Please retry !");
        }
        return true;
    }

    public boolean setDeviceMode(long handle, byte bDeviceModeECI, byte bDeviceModeSCI) throws SerialComException {
        int ret = this.mSerialComCP210xManufacturingJNIBridge.setDeviceMode(handle, bDeviceModeECI, bDeviceModeSCI);
        if (ret < 0) {
            throw new SerialComException("Could not set the device configuration. Please retry !");
        }
        return true;
    }

    public boolean setDeviceVersion(long handle, int version) throws SerialComException {
        if (version > 65535) {
            throw new IllegalArgumentException("Invalid flag passed for the requested operation !");
        }
        int ret = this.mSerialComCP210xManufacturingJNIBridge.setDeviceVersion(handle, version);
        if (ret < 0) {
            throw new SerialComException("Could not set the device version for the product. Please retry !");
        }
        return true;
    }

    public boolean setBaudRateConfig(long handle, int baudGen, int timer0Reload, int prescalar, int baudrate) throws SerialComException {
        int ret = this.mSerialComCP210xManufacturingJNIBridge.setBaudRateConfig(handle, baudGen, timer0Reload, prescalar, baudrate);
        if (ret < 0) {
            throw new SerialComException("Could not set the baud rate configuration values for the product. Please retry !");
        }
        return true;
    }

    public boolean setPortConfig(long handle, int mode, int resetLatch, int suspendLatch, int enhancedFxn) throws SerialComException {
        int ret = this.mSerialComCP210xManufacturingJNIBridge.setPortConfig(handle, mode, resetLatch, suspendLatch, enhancedFxn);
        if (ret < 0) {
            throw new SerialComException("Could not set the port configuration values for the product. Please retry !");
        }
        return true;
    }

    public boolean setDualPortConfig(long handle, int mode, int resetLatch, int suspendLatch, int enhancedFxnECI, int enhancedFxnSCI, int enhancedFxnDevice) throws SerialComException {
        int ret = this.mSerialComCP210xManufacturingJNIBridge.setDualPortConfig(handle, mode, resetLatch, suspendLatch, enhancedFxnECI, enhancedFxnSCI, enhancedFxnDevice);
        if (ret < 0) {
            throw new SerialComException("Could not set the dual port configuration values for the device. Please retry !");
        }
        return true;
    }

    public boolean setQuadPortConfig(long handle, int[] resetLatch, int[] suspendLatch, byte[] config) throws SerialComException {
        if (resetLatch.length != 15 || suspendLatch.length != 15) {
            throw new IllegalArgumentException("Length of array resetLatch and suspendLatch must be 15 !");
        }
        if (config.length != 13) {
            throw new IllegalArgumentException("Length of array config must be 13 !");
        }
        int ret = this.mSerialComCP210xManufacturingJNIBridge.setQuadPortConfig(handle, resetLatch, suspendLatch, config);
        if (ret < 0) {
            throw new SerialComException("Could not set the dual port configuration values for the device. Please retry !");
        }
        return true;
    }

    public boolean setLockValue(long handle) throws SerialComException {
        int ret = this.mSerialComCP210xManufacturingJNIBridge.setLockValue(handle);
        if (ret < 0) {
            throw new SerialComException("Could not set the lock value on the device. Please retry !");
        }
        return true;
    }

    public int getDeviceVid(long handle) throws SerialComException {
        int ret = this.mSerialComCP210xManufacturingJNIBridge.getDeviceVid(handle);
        if (ret < 0) {
            throw new SerialComException("Could not get the device USB VID. Please retry !");
        }
        return ret;
    }

    public int getDevicePid(long handle) throws SerialComException {
        int ret = this.mSerialComCP210xManufacturingJNIBridge.getDevicePid(handle);
        if (ret < 0) {
            throw new SerialComException("Could not get the device USB VID. Please retry !");
        }
        return ret;
    }

    public String getDeviceManufacturerString(long handle) throws SerialComException {
        String ret = this.mSerialComCP210xManufacturingJNIBridge.getDeviceManufacturerString(handle);
        if (ret == null) {
            throw new SerialComException("Could not get the manufacturer string. Please retry !");
        }
        return ret;
    }

    public String getDeviceProductString(long handle) throws SerialComException {
        String ret = this.mSerialComCP210xManufacturingJNIBridge.getDeviceProductString(handle);
        if (ret == null) {
            throw new SerialComException("Could not get the product description string. Please retry !");
        }
        return ret;
    }

    public String getDeviceInterfaceString(long handle, byte bInterfaceNumber) throws SerialComException {
        String ret = this.mSerialComCP210xManufacturingJNIBridge.getDeviceInterfaceString(handle, bInterfaceNumber);
        if (ret == null) {
            throw new SerialComException("Could not get the product serial number string. Please retry !");
        }
        return ret;
    }

    public String getDeviceSerialNumber(long handle) throws SerialComException {
        String ret = this.mSerialComCP210xManufacturingJNIBridge.getDeviceSerialNumber(handle);
        if (ret == null) {
            throw new SerialComException("Could not get the product serial number string. Please retry !");
        }
        return ret;
    }

    public boolean getSelfPower(long handle) throws SerialComException {
        int ret = this.mSerialComCP210xManufacturingJNIBridge.getSelfPower(handle);
        if (ret < 0) {
            throw new SerialComException("Could not determine the self powered bit value. Please retry !");
        }
        return ret != 0;
    }

    public byte getMaxPower(long handle) throws SerialComException {
        int ret = this.mSerialComCP210xManufacturingJNIBridge.getMaxPower(handle);
        if (ret < 0) {
            throw new SerialComException("Could not determine the max power field value. Please retry !");
        }
        return (byte)ret;
    }

    public short getFlushBufferConfig(long handle) throws SerialComException {
        int ret = this.mSerialComCP210xManufacturingJNIBridge.getFlushBufferConfig(handle);
        if (ret < 0) {
            throw new SerialComException("Could not determine flush buffer config. Please retry !");
        }
        return (byte)ret;
    }

    public byte[] getDeviceMode(long handle) throws SerialComException {
        byte[] ret = this.mSerialComCP210xManufacturingJNIBridge.getDeviceMode(handle);
        if (ret == null) {
            throw new SerialComException("Could not get the device mode. Please retry !");
        }
        return ret;
    }

    public int getDeviceVersion(long handle) throws SerialComException {
        int ret = this.mSerialComCP210xManufacturingJNIBridge.getDeviceVersion(handle);
        if (ret < 0) {
            throw new SerialComException("Could not get the device version. Please retry !");
        }
        return ret;
    }

    public CP210XbaudConfigs[] getBaudRateConfig(long handle) throws SerialComException {
        CP210XbaudConfigs[] configs = null;
        int i = 0;
        int numOfValues = 0;
        int[] ret = this.mSerialComCP210xManufacturingJNIBridge.getBaudRateConfig(handle);
        if (ret == null) {
            throw new SerialComException("Could not get the baud rate configuration values. Please retry !");
        }
        if (ret.length < 4) {
            return new CP210XbaudConfigs[0];
        }
        numOfValues = ret.length / 4;
        configs = new CP210XbaudConfigs[numOfValues];
        int x = 0;
        while (x < numOfValues) {
            configs[x] = new CP210XbaudConfigs(ret[i], ret[i + 1], ret[i + 2], ret[i + 3]);
            i += 4;
            ++x;
        }
        return configs;
    }

    public int[] getPortConfig(long handle) throws SerialComException {
        int[] ret = this.mSerialComCP210xManufacturingJNIBridge.getPortConfig(handle);
        if (ret == null) {
            throw new SerialComException("Could not get the port configuration values. Please retry !");
        }
        return ret;
    }

    public int[] getDualPortConfig(long handle) throws SerialComException {
        int[] ret = this.mSerialComCP210xManufacturingJNIBridge.getDualPortConfig(handle);
        if (ret == null) {
            throw new SerialComException("Could not get the dual port configuration values. Please retry !");
        }
        return ret;
    }

    public int[] getQuadPortConfig(long handle) throws SerialComException {
        int[] ret = this.mSerialComCP210xManufacturingJNIBridge.getQuadPortConfig(handle);
        if (ret == null) {
            throw new SerialComException("Could not get the quad port configuration values. Please retry !");
        }
        return ret;
    }

    public byte getLockValue(long handle) throws SerialComException {
        int ret = this.mSerialComCP210xManufacturingJNIBridge.getLockValue(handle);
        if (ret < 0) {
            throw new SerialComException("Could not determine the lock value. Please retry !");
        }
        return (byte)ret;
    }

    public boolean reset(long handle) throws SerialComException {
        int ret = this.mSerialComCP210xManufacturingJNIBridge.reset(handle);
        if (ret < 0) {
            throw new SerialComException("Could not reset the device. Please retry !");
        }
        return true;
    }

    public boolean createHexFile(long handle, String fileName) throws SerialComException {
        int ret = this.mSerialComCP210xManufacturingJNIBridge.createHexFile(handle, fileName);
        if (ret < 0) {
            throw new SerialComException("Could not perform the requested operation. Please retry !");
        }
        return true;
    }
}

