/*
 * Decompiled with CFR 0.152.
 */
package com.serialpundit.serial.vendor;

import com.serialpundit.core.SerialComException;
import com.serialpundit.core.SerialComSystemProperty;
import com.serialpundit.serial.internal.SerialComCP210xRuntimeJNIBridge;
import com.serialpundit.serial.vendor.SerialComVendorLib;
import java.io.File;

public final class SerialComSLabsCP210xRuntime
extends SerialComVendorLib {
    public static final int CP210x_GPIO_0 = 1;
    public static final int CP210x_GPIO_1 = 2;
    public static final int CP210x_GPIO_2 = 4;
    public static final int CP210x_GPIO_3 = 8;
    public static final int CP210x_GPIO_4 = 16;
    public static final int CP210x_GPIO_5 = 32;
    public static final int CP210x_GPIO_6 = 64;
    public static final int CP210x_GPIO_7 = 128;
    public static final int CP210x_GPIO_8 = 256;
    public static final int CP210x_GPIO_9 = 512;
    public static final int CP210x_GPIO_10 = 1024;
    public static final int CP210x_GPIO_11 = 2048;
    public static final int CP210x_GPIO_12 = 4096;
    public static final int CP210x_GPIO_13 = 8192;
    public static final int CP210x_GPIO_14 = 16384;
    public static final int CP210x_GPIO_15 = 32768;
    private final SerialComCP210xRuntimeJNIBridge mSerialComCP210xRuntimeJNIBridge = new SerialComCP210xRuntimeJNIBridge();

    public SerialComSLabsCP210xRuntime(File libDirectory, String vlibName, int cpuArch, int osType, SerialComSystemProperty serialComSystemProperty) throws SerialComException {
        SerialComCP210xRuntimeJNIBridge.loadNativeLibrary(libDirectory, vlibName, cpuArch, osType, serialComSystemProperty);
    }

    public long readLatch(long handle) throws SerialComException {
        long ret = this.mSerialComCP210xRuntimeJNIBridge.readLatch(handle);
        if (ret < 0L) {
            throw new SerialComException("Could not read the port latch value for given device. Please retry !");
        }
        return ret;
    }

    public boolean writeLatch(long handle, long mask, long latchValue) throws SerialComException {
        int ret = this.mSerialComCP210xRuntimeJNIBridge.writeLatch(handle, mask, latchValue);
        if (ret < 0) {
            throw new SerialComException("Could not write the given latch value on the given device. Please retry !");
        }
        return true;
    }

    public String getPartNumber(long handle) throws SerialComException {
        String ret = this.mSerialComCP210xRuntimeJNIBridge.getPartNumber(handle);
        if (ret == null) {
            throw new SerialComException("Could not get the part number of the current device. Please retry !");
        }
        return ret;
    }

    public String getDeviceProductString(long handle) throws SerialComException {
        String ret = this.mSerialComCP210xRuntimeJNIBridge.getDeviceProductString(handle);
        if (ret == null) {
            throw new SerialComException("Could not get the product string of the current device. Please retry !");
        }
        return ret;
    }

    public String getDeviceSerialNumber(long handle) throws SerialComException {
        String ret = this.mSerialComCP210xRuntimeJNIBridge.getDeviceSerialNumber(handle);
        if (ret == null) {
            throw new SerialComException("Could not get the serial number of the current device. Please retry !");
        }
        return ret;
    }

    public String getDeviceInterfaceString(long handle) throws SerialComException {
        String ret = this.mSerialComCP210xRuntimeJNIBridge.getDeviceInterfaceString(handle);
        if (ret == null) {
            throw new SerialComException("Could not get the interface string of the current device. Please retry !");
        }
        return ret;
    }
}

