/*
 * Decompiled with CFR 0.152.
 */
package com.serialpundit.serial.ftp;

import com.serialpundit.core.SerialComException;
import com.serialpundit.core.SerialComTimeOutException;
import com.serialpundit.core.util.SerialComCRCUtil;
import com.serialpundit.serial.SerialComManager;
import com.serialpundit.serial.ftp.ISerialComXmodemProgress;
import com.serialpundit.serial.ftp.SerialComFTPCMDAbort;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public final class SerialComXModemCRC {
    private final byte SOH = 1;
    private final byte EOT = (byte)4;
    private final byte ACK = (byte)6;
    private final byte NAK = (byte)21;
    private final byte CAN = (byte)24;
    private final byte SUB = (byte)26;
    private final byte C = (byte)67;
    private final byte CR = (byte)13;
    private final byte LF = (byte)10;
    private final byte BS = (byte)8;
    private SerialComManager scm;
    private long handle;
    private File fileToProcess;
    private boolean textMode;
    private ISerialComXmodemProgress progressListener;
    private SerialComFTPCMDAbort transferState;
    private int osType;
    private int blockNumber;
    private byte[] block = new byte[133];
    private BufferedInputStream inStream;
    private BufferedOutputStream outStream;
    private boolean noMoreData;
    private boolean isFirstDataBytePending = false;
    private boolean isSecondDataBytePending = false;
    private boolean isThirdDataBytePending = false;
    private boolean isLineFeedPending = false;
    private boolean isCarriageReturnPending = false;
    private byte firstPendingDataByte;
    private byte secondPendingDataByte;
    private byte thirdPendingDataByte;
    private boolean alreadySentEOFchar = false;
    private byte[] tmpSendBuffer = new byte[1024];
    private byte[] tmpReceiveBuffer = new byte[512];
    private int mark = -1;
    private int limit = -1;
    private boolean lastCharacterReceivedWasLF = false;
    private boolean lastCharacterReceivedWasCR = false;
    private boolean unprocessedByteInReceivedDataExist = false;
    private byte unprocessedByteInLastReceivedBlock;
    private byte data0 = 0;
    private byte data1 = 0;
    private long numberOfBlocksSent = 0L;
    private long numberOfBlocksReceived = 0L;
    private boolean lastCharacterReceivedWasCAN = false;
    private final byte[] ABORT_CMD = new byte[]{24, 24, 24, 24, 24, 8, 8, 8, 8, 8};
    private final SerialComCRCUtil crcCalculator = new SerialComCRCUtil();

    public SerialComXModemCRC(SerialComManager scm, long handle, File fileToProcess, boolean textMode, ISerialComXmodemProgress progressListener, SerialComFTPCMDAbort transferState, int osType) {
        this.scm = scm;
        this.handle = handle;
        this.fileToProcess = fileToProcess;
        this.textMode = textMode;
        this.progressListener = progressListener;
        this.transferState = transferState;
        this.osType = osType;
    }

    /*
     * Unable to fully structure code
     */
    public boolean sendFileX() throws IOException {
        CONNECT = false;
        BEGINSEND = true;
        WAITACK = 2;
        RESEND = 3;
        SENDNEXT = 4;
        ENDTX = 5;
        ABORT = 6;
        cReceived = false;
        eotAckReceptionTimerInitialized = false;
        errMsg = null;
        retryCount = 0;
        state = -1;
        data = null;
        responseWaitTimeOut = 0L;
        eotAckWaitTimeOutValue = 0L;
        percentOfBlocksSent = 0;
        lengthOfFileToSend = this.fileToProcess.length();
        this.inStream = new BufferedInputStream(new FileInputStream(this.fileToProcess));
        state = 0;
        block25: while (true) {
            switch (state) {
                case 0: {
                    responseWaitTimeOut = System.currentTimeMillis() + 60000L;
                    block26: do {
                        if (cReceived) continue block25;
                        try {
                            data = this.scm.readBytes(this.handle, 1024);
                        }
                        catch (SerialComException exp) {
                            this.inStream.close();
                            throw exp;
                        }
                        if (data != null && data.length > 0) {
                            x = 0;
                            while (x < data.length) {
                                if (data[x] == 67) {
                                    cReceived = true;
                                    state = 1;
                                    continue block26;
                                }
                                ++x;
                            }
                            continue;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException x) {
                            // empty catch block
                        }
                        if (cReceived || System.currentTimeMillis() < responseWaitTimeOut) continue;
                        errMsg = "Timedout while waiting for file receiver to initiate connection setup !";
                        state = 6;
                        continue block25;
                    } while (this.transferState == null || !this.transferState.isTransferToBeAborted());
                    this.inStream.close();
                    this.scm.writeBytes(this.handle, this.ABORT_CMD, 0);
                    return false;
                }
                case 1: {
                    this.blockNumber = 1;
                    this.assembleBlock();
                    if (this.noMoreData) {
                        state = 5;
                        continue block25;
                    }
                    try {
                        this.scm.writeBytes(this.handle, this.block, 0);
                    }
                    catch (SerialComException exp) {
                        this.inStream.close();
                        throw exp;
                    }
                    state = 2;
                    continue block25;
                }
                case 3: {
                    if (retryCount > 10) {
                        errMsg = "Maximum number of retries reached while sending same data block !";
                        state = 6;
                        continue block25;
                    }
                    try {
                        this.scm.writeBytes(this.handle, this.block, 0);
                    }
                    catch (SerialComException exp) {
                        this.inStream.close();
                        throw exp;
                    }
                    state = 2;
                    continue block25;
                }
                case 2: {
                    responseWaitTimeOut = System.currentTimeMillis() + 60000L;
                    do {
                        if (this.transferState != null && this.transferState.isTransferToBeAborted()) {
                            this.inStream.close();
                            this.scm.writeBytes(this.handle, this.ABORT_CMD, 0);
                            return false;
                        }
                        try {
                            if (!this.noMoreData) {
                                Thread.sleep(120L);
                            } else {
                                Thread.sleep(1500L);
                            }
                        }
                        catch (InterruptedException exp) {
                            // empty catch block
                        }
                        try {
                            data = this.scm.readBytes(this.handle, 1);
                        }
                        catch (SerialComException exp) {
                            this.inStream.close();
                            throw exp;
                        }
                        if (data != null && data.length > 0) ** GOTO lbl114
                        if (!this.noMoreData) continue;
                        state = 5;
                        ** GOTO lbl114
                    } while (System.currentTimeMillis() < responseWaitTimeOut);
                    errMsg = this.noMoreData != false ? "Timedout while waiting for EOT reception acknowledgement from file receiver !" : "Timedout while waiting for block reception acknowledgement from file receiver !";
                    state = 6;
lbl114:
                    // 3 sources

                    if (state != 2) continue block25;
                    if (!this.noMoreData) {
                        if (data[0] == 6) {
                            if (this.lastCharacterReceivedWasCAN) {
                                ++retryCount;
                                state = 3;
                                continue block25;
                            }
                            state = 4;
                        } else if (data[0] == 21) {
                            ++retryCount;
                            state = 3;
                        } else if (data[0] == 24) {
                            if (data.length >= 2) {
                                if (data[1] == 24) {
                                    errMsg = "Received abort command from file receiving end !";
                                    state = 6;
                                    continue block25;
                                }
                                ++retryCount;
                                state = 3;
                            }
                            if (this.lastCharacterReceivedWasCAN) {
                                errMsg = "Received abort command from file receiving end !";
                                state = 6;
                                continue block25;
                            }
                            this.lastCharacterReceivedWasCAN = true;
                        } else {
                            errMsg = "Invalid data byte : " + data[0] + " received from file receiver !";
                            state = 6;
                            continue block25;
                        }
                        if (this.progressListener == null) continue block25;
                        ++this.numberOfBlocksSent;
                        percentOfBlocksSent = lengthOfFileToSend != 0L ? (int)(12800L * this.numberOfBlocksSent / lengthOfFileToSend) : 100;
                        if (percentOfBlocksSent >= 100) {
                            percentOfBlocksSent = 100;
                        }
                        this.progressListener.onXmodemSentProgressUpdate(this.numberOfBlocksSent, percentOfBlocksSent);
                        continue block25;
                    }
                    if (data[0] == 6) {
                        this.inStream.close();
                        return true;
                    }
                    if (System.currentTimeMillis() >= eotAckWaitTimeOutValue) {
                        errMsg = "Timedout while waiting for EOT reception acknowledgement from file receiver !";
                        state = 6;
                        continue block25;
                    }
                    state = 5;
                    continue block25;
                }
                case 4: {
                    retryCount = 0;
                    ++this.blockNumber;
                    this.assembleBlock();
                    if (this.noMoreData) {
                        state = 5;
                        continue block25;
                    }
                    try {
                        this.scm.writeBytes(this.handle, this.block, 0);
                    }
                    catch (SerialComException exp) {
                        this.inStream.close();
                        throw exp;
                    }
                    state = 2;
                    continue block25;
                }
                case 5: {
                    if (!eotAckReceptionTimerInitialized) {
                        eotAckWaitTimeOutValue = System.currentTimeMillis() + 60000L;
                        eotAckReceptionTimerInitialized = true;
                    }
                    try {
                        this.scm.writeSingleByte(this.handle, (byte)4);
                    }
                    catch (SerialComException exp) {
                        this.inStream.close();
                        throw exp;
                    }
                    state = 2;
                    continue block25;
                }
                case 6: {
                    this.inStream.close();
                    throw new SerialComTimeOutException(errMsg);
                }
            }
        }
    }

    private void assembleBlock() throws IOException {
        int x = 0;
        int numBytesRead = 0;
        int blockCRCval = 0;
        if (this.blockNumber > 255) {
            this.blockNumber = 0;
        }
        this.block[0] = 1;
        this.block[1] = (byte)this.blockNumber;
        this.block[2] = (byte)(~this.blockNumber);
        if (this.textMode) {
            x = 3;
            if (this.isFirstDataBytePending) {
                this.block[x] = this.firstPendingDataByte;
                ++x;
                this.isFirstDataBytePending = false;
                if (this.isSecondDataBytePending) {
                    this.block[x] = this.secondPendingDataByte;
                    ++x;
                    this.isSecondDataBytePending = false;
                    if (this.isThirdDataBytePending) {
                        this.block[x] = this.thirdPendingDataByte;
                        ++x;
                        this.isThirdDataBytePending = false;
                    }
                }
            }
            while (x < 131) {
                if (this.mark == this.limit || this.mark == -1) {
                    this.limit = this.inStream.read(this.tmpSendBuffer, 0, 1024);
                    this.mark = 0;
                    if (this.limit < 0) {
                        if (this.isLineFeedPending) {
                            this.data0 = (byte)10;
                            this.isLineFeedPending = false;
                            this.data1 = (byte)-1;
                        } else if (this.isCarriageReturnPending) {
                            this.data0 = (byte)13;
                            this.isCarriageReturnPending = false;
                            this.data1 = (byte)-1;
                        } else {
                            this.data0 = (byte)-1;
                            this.data1 = (byte)-1;
                        }
                    } else if (this.limit == 1) {
                        if (this.isLineFeedPending) {
                            this.data0 = (byte)10;
                            this.isLineFeedPending = false;
                            this.data1 = this.tmpSendBuffer[this.mark];
                            ++this.mark;
                        } else if (this.isCarriageReturnPending) {
                            this.data0 = (byte)13;
                            this.isCarriageReturnPending = false;
                            this.data1 = this.tmpSendBuffer[this.mark];
                            ++this.mark;
                        } else {
                            this.data0 = this.tmpSendBuffer[this.mark];
                            ++this.mark;
                            this.data1 = (byte)-1;
                        }
                    } else if (this.isLineFeedPending) {
                        this.data0 = (byte)10;
                        this.isLineFeedPending = false;
                        this.data1 = this.tmpSendBuffer[this.mark];
                        ++this.mark;
                    } else if (this.isCarriageReturnPending) {
                        this.data0 = (byte)13;
                        this.isCarriageReturnPending = false;
                        this.data1 = this.tmpSendBuffer[this.mark];
                        ++this.mark;
                    } else {
                        this.data0 = this.tmpSendBuffer[this.mark];
                        ++this.mark;
                        this.data1 = this.tmpSendBuffer[this.mark];
                        ++this.mark;
                    }
                } else if (this.mark == this.limit - 1) {
                    if (this.isLineFeedPending) {
                        this.data0 = (byte)10;
                        this.isLineFeedPending = false;
                        this.data1 = this.tmpSendBuffer[this.mark];
                        ++this.mark;
                    } else if (this.isCarriageReturnPending) {
                        this.data0 = (byte)13;
                        this.isCarriageReturnPending = false;
                        this.data1 = this.tmpSendBuffer[this.mark];
                        ++this.mark;
                    } else {
                        this.data0 = this.tmpSendBuffer[this.mark];
                        ++this.mark;
                        this.limit = this.inStream.read(this.tmpSendBuffer, 0, 1024);
                        this.mark = 0;
                        if (this.limit < 0) {
                            this.data1 = (byte)-1;
                        } else {
                            this.data1 = this.tmpSendBuffer[this.mark];
                            ++this.mark;
                        }
                    }
                } else if (this.mark == 0 && this.limit == -1) {
                    if (this.isLineFeedPending) {
                        this.data0 = (byte)10;
                        this.isLineFeedPending = false;
                        this.data1 = (byte)-1;
                    } else if (this.isCarriageReturnPending) {
                        this.data0 = (byte)13;
                        this.isCarriageReturnPending = false;
                        this.data1 = (byte)-1;
                    } else {
                        this.data0 = (byte)-1;
                        this.data1 = (byte)-1;
                    }
                } else if (this.isLineFeedPending) {
                    this.data0 = (byte)10;
                    this.isLineFeedPending = false;
                    this.data1 = this.tmpSendBuffer[this.mark];
                    ++this.mark;
                } else if (this.isCarriageReturnPending) {
                    this.data0 = (byte)13;
                    this.isCarriageReturnPending = false;
                    this.data1 = this.tmpSendBuffer[this.mark];
                    ++this.mark;
                } else {
                    this.data0 = this.tmpSendBuffer[this.mark];
                    ++this.mark;
                    this.data1 = this.tmpSendBuffer[this.mark];
                    ++this.mark;
                }
                if (this.data0 == -1) {
                    if (this.alreadySentEOFchar) {
                        this.noMoreData = true;
                        return;
                    }
                    x += 0;
                    while (x < 131) {
                        this.block[x] = 26;
                        ++x;
                    }
                    this.alreadySentEOFchar = true;
                    continue;
                }
                if (this.data0 != -1 && this.data1 == -1) {
                    if (this.data0 == 10 || this.data0 == 13) {
                        this.block[x] = 13;
                        if (++x < 131) {
                            this.block[x] = 10;
                            ++x;
                            continue;
                        }
                        this.isFirstDataBytePending = true;
                        this.firstPendingDataByte = (byte)10;
                        continue;
                    }
                    this.block[x] = this.data0;
                    ++x;
                    continue;
                }
                if (this.data0 != 10 && this.data0 != 13) {
                    if (this.data1 != 10 && this.data1 != 13) {
                        this.block[x] = this.data0;
                        if (++x < 131) {
                            this.block[x] = this.data1;
                            ++x;
                            continue;
                        }
                        this.isFirstDataBytePending = true;
                        this.firstPendingDataByte = this.data1;
                        continue;
                    }
                    if (this.data1 == 10) {
                        this.block[x] = this.data0;
                        ++x;
                        this.isLineFeedPending = true;
                        continue;
                    }
                    this.block[x] = this.data0;
                    ++x;
                    this.isCarriageReturnPending = true;
                    continue;
                }
                if (this.data0 == 13 && this.data1 == 10 || this.data0 == 10 && this.data1 == 13) {
                    this.block[x] = 13;
                    if (++x < 131) {
                        this.block[x] = 10;
                        ++x;
                        continue;
                    }
                    this.isFirstDataBytePending = true;
                    this.firstPendingDataByte = (byte)10;
                    continue;
                }
                if (this.data0 == 10 && this.data1 != 13 && this.data1 != 10) {
                    this.block[x] = 13;
                    if (++x < 131) {
                        this.block[x] = 10;
                        if (++x < 131) {
                            this.block[x] = this.data1;
                            ++x;
                            continue;
                        }
                        this.isFirstDataBytePending = true;
                        this.firstPendingDataByte = this.data1;
                        continue;
                    }
                    this.isFirstDataBytePending = true;
                    this.firstPendingDataByte = (byte)10;
                    this.isSecondDataBytePending = true;
                    this.secondPendingDataByte = this.data1;
                    continue;
                }
                if (this.data0 == 13 && this.data1 != 13 && this.data1 != 10) {
                    this.block[x] = 13;
                    if (++x < 131) {
                        this.block[x] = 10;
                        if (++x < 131) {
                            this.block[x] = this.data1;
                            ++x;
                            continue;
                        }
                        this.isFirstDataBytePending = true;
                        this.firstPendingDataByte = this.data1;
                        continue;
                    }
                    this.isFirstDataBytePending = true;
                    this.firstPendingDataByte = (byte)10;
                    this.isSecondDataBytePending = true;
                    this.secondPendingDataByte = this.data1;
                    continue;
                }
                if ((this.data0 != 10 || this.data1 != 10) && (this.data0 != 13 || this.data1 != 13)) continue;
                this.block[x] = 13;
                if (++x < 131) {
                    this.block[x] = 10;
                    if (++x < 131) {
                        this.block[x] = 13;
                        if (++x < 131) {
                            this.block[x] = 10;
                            ++x;
                            continue;
                        }
                        this.isFirstDataBytePending = true;
                        this.firstPendingDataByte = (byte)10;
                        continue;
                    }
                    this.isFirstDataBytePending = true;
                    this.firstPendingDataByte = (byte)13;
                    this.isSecondDataBytePending = true;
                    this.secondPendingDataByte = (byte)10;
                    continue;
                }
                this.isFirstDataBytePending = true;
                this.firstPendingDataByte = (byte)10;
                this.isSecondDataBytePending = true;
                this.secondPendingDataByte = (byte)13;
                this.isThirdDataBytePending = true;
                this.thirdPendingDataByte = (byte)10;
            }
        } else {
            numBytesRead = this.inStream.read(this.block, 3, 128);
            if (numBytesRead != 128) {
                if (numBytesRead > 0) {
                    x = numBytesRead + 3;
                    while (x < 131) {
                        this.block[x] = 26;
                        ++x;
                    }
                } else {
                    this.noMoreData = true;
                    return;
                }
            }
        }
        blockCRCval = this.crcCalculator.getCRC16CCITTValue(this.block, 3, 130);
        this.block[131] = (byte)(blockCRCval >>> 8);
        this.block[132] = (byte)blockCRCval;
    }

    /*
     * Unable to fully structure code
     */
    public boolean receiveFileX() throws IOException {
        CONNECT = false;
        RECEIVEDATA = true;
        VERIFY = 2;
        REPLY = 3;
        ABORT = 4;
        z = 0;
        delayVal = 250;
        retryCount = 0;
        duplicateBlockRetryCount = 0;
        state = -1;
        blockNumber = 1;
        blockCRCval = 0;
        bufferIndex = 0;
        connectTimeOut = 0L;
        nextDataRecvTimeOut = 0L;
        rxDone = false;
        firstBlock = false;
        isCorrupted = false;
        isDuplicateBlock = false;
        partialReadInProgress = false;
        data = null;
        errMsg = null;
        isFileOpen = true;
        this.outStream = new BufferedOutputStream(new FileOutputStream(this.fileToProcess));
        isFileOpen = true;
        try {
            this.scm.clearPortIOBuffers(this.handle, true, false);
        }
        catch (SerialComException exp) {
            this.outStream.close();
            throw exp;
        }
        state = 0;
        block24: while (true) {
            switch (state) {
                case 0: {
                    if (retryCount < 3) {
                        try {
                            this.scm.writeSingleByte(this.handle, (byte)67);
                            firstBlock = true;
                            connectTimeOut = System.currentTimeMillis() + 3000L;
                            state = 1;
                            continue block24;
                        }
                        catch (SerialComException exp) {
                            this.outStream.close();
                            throw exp;
                        }
                    }
                    return this.scm.receiveFile(this.handle, this.fileToProcess, SerialComManager.FTPPROTO.XMODEM, SerialComManager.FTPVAR.CHKSUM, this.textMode, this.progressListener, this.transferState);
                }
                case 1: {
                    while (true) {
                        if (this.transferState != null && this.transferState.isTransferToBeAborted()) {
                            this.outStream.close();
                            this.scm.writeBytes(this.handle, this.ABORT_CMD, 0);
                            return false;
                        }
                        try {
                            Thread.sleep(delayVal);
                        }
                        catch (InterruptedException exp) {
                            // empty catch block
                        }
                        try {
                            data = this.scm.readBytes(this.handle, 133);
                        }
                        catch (SerialComException exp) {
                            this.outStream.close();
                            throw exp;
                        }
                        if (data != null && data.length > 0) {
                            firstBlock = false;
                            if (data[0] == 24) {
                                if (this.lastCharacterReceivedWasCAN) {
                                    try {
                                        this.scm.writeSingleByte(this.handle, (byte)6);
                                    }
                                    catch (Exception exp) {
                                        // empty catch block
                                    }
                                    errMsg = "Abort command received from file sending application !";
                                    state = 4;
                                    continue block24;
                                }
                                if (data.length >= 2) {
                                    if (data[1] == 24) {
                                        try {
                                            this.scm.writeSingleByte(this.handle, (byte)6);
                                        }
                                        catch (Exception exp) {
                                            // empty catch block
                                        }
                                        errMsg = "Abort command received from file sending application !";
                                        state = 4;
                                        continue block24;
                                    }
                                    isCorrupted = true;
                                    state = 3;
                                    continue block24;
                                }
                                this.lastCharacterReceivedWasCAN = true;
                                continue;
                            }
                            if (data[0] == 4) {
                                if (this.lastCharacterReceivedWasCAN) {
                                    errMsg = "Invalid data sequence (<CAN> <EOT>) received from file sender !";
                                    state = 4;
                                    continue block24;
                                }
                                isCorrupted = false;
                                rxDone = true;
                                state = 3;
                                continue block24;
                            }
                            if (!partialReadInProgress && data.length == 133) {
                                i = 0;
                                while (i < 133) {
                                    this.block[i] = data[i];
                                    ++i;
                                }
                                state = 2;
                                continue block24;
                            }
                            partialReadInProgress = true;
                            z = 0;
                            while (z < data.length) {
                                if (bufferIndex >= 133) {
                                    if (data.length - z >= 2) {
                                        if (data[z] == 24 && data[z + 1] == 24) {
                                            try {
                                                this.scm.writeSingleByte(this.handle, (byte)6);
                                            }
                                            catch (Exception i) {
                                                // empty catch block
                                            }
                                            errMsg = "Abort command received from file sending application !";
                                            state = 4;
                                            break;
                                        }
                                        delayVal = 250;
                                        bufferIndex = 0;
                                        partialReadInProgress = false;
                                        state = 2;
                                        break;
                                    }
                                    if (data[z] == 24) {
                                        this.lastCharacterReceivedWasCAN = true;
                                    } else {
                                        delayVal = 250;
                                        bufferIndex = 0;
                                        partialReadInProgress = false;
                                        state = 2;
                                        break;
                                    }
                                }
                                this.block[bufferIndex] = data[z];
                                ++bufferIndex;
                                ++z;
                            }
                            if (bufferIndex >= 133) {
                                delayVal = 220;
                                bufferIndex = 0;
                                partialReadInProgress = false;
                                state = 2;
                                continue block24;
                            }
                            delayVal = 80;
                            continue;
                        }
                        if (!firstBlock) {
                            if (System.currentTimeMillis() <= nextDataRecvTimeOut) continue;
                            errMsg = "Timedout while trying to receive next data byte from file sender !";
                            state = 4;
                            continue block24;
                        }
                        if (System.currentTimeMillis() > connectTimeOut) break;
                    }
                    ++retryCount;
                    state = 0;
                    continue block24;
                }
                case 2: {
                    isCorrupted = false;
                    isDuplicateBlock = false;
                    state = 3;
                    if (this.block[0] != 1) {
                        isCorrupted = true;
                        continue block24;
                    }
                    if (this.block[1] == (blockNumber - 1 & 255)) {
                        isDuplicateBlock = true;
                        if (++duplicateBlockRetryCount <= 10) continue block24;
                        errMsg = "Maximum number of retries reached while receiving same data block !";
                        state = 4;
                        continue block24;
                    }
                    if (this.block[1] != (byte)blockNumber || this.block[2] != (byte)(~blockNumber)) {
                        isCorrupted = true;
                        continue block24;
                    }
                    blockCRCval = this.crcCalculator.getCRC16CCITTValue(this.block, 3, 130);
                    if (this.block[131] == (byte)(blockCRCval >>> 8) && this.block[132] == (byte)blockCRCval) continue block24;
                    isCorrupted = true;
                    continue block24;
                }
                case 3: {
                    try {
                        if (rxDone) ** GOTO lbl205
                        if (!isCorrupted) {
                            this.scm.writeSingleByte(this.handle, (byte)6);
                            if (this.textMode) {
                                this.processAndWrite(this.block);
                            } else {
                                this.outStream.write(this.block, 3, 128);
                            }
                            if (this.progressListener != null) {
                                ++this.numberOfBlocksReceived;
                                this.progressListener.onXmodemReceiveProgressUpdate(this.numberOfBlocksReceived);
                            }
                            if (!isDuplicateBlock) {
                                if (++blockNumber > 255) {
                                    blockNumber = 0;
                                }
                                duplicateBlockRetryCount = 0;
                            }
                        } else {
                            this.scm.writeSingleByte(this.handle, (byte)21);
                        }
                        state = 1;
                        ** GOTO lbl218
lbl205:
                        // 1 sources

                        this.scm.writeSingleByte(this.handle, (byte)6);
                        if (isFileOpen) {
                            this.outStream.flush();
                            this.outStream.close();
                            isFileOpen = false;
                        }
                        return true;
                    }
                    catch (SerialComException exp) {
                        this.outStream.close();
                        throw exp;
                    }
                    catch (IOException exp) {
                        this.outStream.close();
                        throw exp;
                    }
lbl218:
                    // 1 sources

                    nextDataRecvTimeOut = System.currentTimeMillis() + 1000L;
                    continue block24;
                }
                case 4: {
                    this.outStream.close();
                    throw new SerialComTimeOutException(errMsg);
                }
            }
        }
    }

    private void processAndWrite(byte[] block) throws IOException {
        this.mark = 3;
        int q = 0;
        while (this.mark <= 129) {
            if (!this.unprocessedByteInReceivedDataExist) {
                if (this.lastCharacterReceivedWasLF) {
                    this.data0 = (byte)10;
                    this.lastCharacterReceivedWasLF = false;
                } else if (this.lastCharacterReceivedWasCR) {
                    this.data0 = (byte)13;
                    this.lastCharacterReceivedWasCR = false;
                } else {
                    this.data0 = block[this.mark];
                    ++this.mark;
                }
                this.data1 = block[this.mark];
                ++this.mark;
            } else {
                this.data0 = this.unprocessedByteInLastReceivedBlock;
                this.unprocessedByteInReceivedDataExist = false;
                this.data1 = block[this.mark];
                ++this.mark;
            }
            if (this.data0 == 13) {
                if (this.data1 == 10) {
                    if (this.osType == 2) {
                        this.tmpReceiveBuffer[q] = 13;
                        this.tmpReceiveBuffer[q + 1] = 10;
                        q += 2;
                        continue;
                    }
                    if (this.osType != 4 && this.osType != 1) continue;
                    this.tmpReceiveBuffer[q] = 10;
                    ++q;
                    continue;
                }
                if (this.data1 == 13) {
                    if (this.osType == 2) {
                        this.tmpReceiveBuffer[q] = 13;
                        this.tmpReceiveBuffer[q + 1] = 10;
                        this.tmpReceiveBuffer[q + 2] = 13;
                        this.tmpReceiveBuffer[q + 3] = 10;
                        q += 4;
                        continue;
                    }
                    if (this.osType != 4 && this.osType != 1) continue;
                    this.tmpReceiveBuffer[q] = 10;
                    this.tmpReceiveBuffer[q + 1] = 10;
                    q += 2;
                    continue;
                }
                if (this.data1 == 26) {
                    if (this.osType == 2) {
                        this.tmpReceiveBuffer[q] = 13;
                        this.tmpReceiveBuffer[q + 1] = 10;
                        q += 2;
                        continue;
                    }
                    if (this.osType != 4 && this.osType != 1) continue;
                    this.tmpReceiveBuffer[q] = 10;
                    ++q;
                    continue;
                }
                if (this.osType == 2) {
                    this.tmpReceiveBuffer[q] = 13;
                    this.tmpReceiveBuffer[q + 1] = 10;
                    this.tmpReceiveBuffer[q + 2] = this.data1;
                    q += 3;
                    continue;
                }
                if (this.osType != 4 && this.osType != 1) continue;
                this.tmpReceiveBuffer[q] = 10;
                this.tmpReceiveBuffer[q + 1] = this.data1;
                q += 2;
                continue;
            }
            if (this.data0 == 10) {
                if (this.data1 == 10) {
                    if (this.osType == 2) {
                        this.tmpReceiveBuffer[q] = 13;
                        this.tmpReceiveBuffer[q + 1] = 10;
                        this.tmpReceiveBuffer[q + 2] = 13;
                        this.tmpReceiveBuffer[q + 3] = 10;
                        q += 4;
                        continue;
                    }
                    if (this.osType != 4 && this.osType != 1) continue;
                    this.tmpReceiveBuffer[q] = 10;
                    this.tmpReceiveBuffer[q + 1] = 10;
                    q += 2;
                    continue;
                }
                if (this.data1 == 13) {
                    if (this.osType == 2) {
                        this.tmpReceiveBuffer[q] = 13;
                        this.tmpReceiveBuffer[q + 1] = 10;
                        q += 2;
                        continue;
                    }
                    if (this.osType != 4 && this.osType != 1) continue;
                    this.tmpReceiveBuffer[q] = 10;
                    ++q;
                    continue;
                }
                if (this.data1 == 26) {
                    if (this.osType == 2) {
                        this.tmpReceiveBuffer[q] = 13;
                        this.tmpReceiveBuffer[q + 1] = 10;
                        q += 2;
                        continue;
                    }
                    if (this.osType != 4 && this.osType != 1) continue;
                    this.tmpReceiveBuffer[q] = 10;
                    ++q;
                    continue;
                }
                if (this.osType == 2) {
                    this.tmpReceiveBuffer[q] = 13;
                    this.tmpReceiveBuffer[q + 1] = 10;
                    this.tmpReceiveBuffer[q + 2] = this.data1;
                    q += 3;
                    continue;
                }
                if (this.osType != 4 && this.osType != 1) continue;
                this.tmpReceiveBuffer[q] = 10;
                this.tmpReceiveBuffer[q + 1] = this.data1;
                q += 2;
                continue;
            }
            if (this.data0 == 26) {
                if (this.data1 == 10) {
                    this.lastCharacterReceivedWasLF = true;
                    continue;
                }
                if (this.data1 == 13) {
                    this.lastCharacterReceivedWasCR = true;
                    continue;
                }
                if (this.data1 == 26) continue;
                this.tmpReceiveBuffer[q] = this.data1;
                ++q;
                continue;
            }
            if (this.data1 == 10) {
                this.tmpReceiveBuffer[q] = this.data0;
                ++q;
                this.lastCharacterReceivedWasLF = true;
                continue;
            }
            if (this.data1 == 13) {
                this.tmpReceiveBuffer[q] = this.data0;
                ++q;
                this.lastCharacterReceivedWasCR = true;
                continue;
            }
            if (this.data1 == 26) {
                this.tmpReceiveBuffer[q] = this.data0;
                ++q;
                continue;
            }
            this.tmpReceiveBuffer[q] = this.data0;
            this.tmpReceiveBuffer[q + 1] = this.data1;
            q += 2;
        }
        this.outStream.write(this.tmpReceiveBuffer, 0, q);
        if (this.mark == 130) {
            this.unprocessedByteInReceivedDataExist = true;
            this.unprocessedByteInLastReceivedBlock = block[130];
        }
    }
}

