/*
 * Decompiled with CFR 0.152.
 */
package com.serialpundit.serial.ftp;

import com.serialpundit.core.SerialComException;
import com.serialpundit.core.SerialComTimeOutException;
import com.serialpundit.core.util.SerialComCRCUtil;
import com.serialpundit.serial.SerialComManager;
import com.serialpundit.serial.ftp.ISerialComYmodemProgress;
import com.serialpundit.serial.ftp.SerialComFTPCMDAbort;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public final class SerialComYModemCRC {
    private final byte SOH = 1;
    private final byte STX = (byte)2;
    private final byte EOT = (byte)4;
    private final byte ACK = (byte)6;
    private final byte NAK = (byte)21;
    private final byte CAN = (byte)24;
    private final byte SUB = (byte)26;
    private final byte C = (byte)67;
    private final byte CR = (byte)13;
    private final byte LF = (byte)10;
    private final byte BS = (byte)8;
    private final byte SPACE = (byte)32;
    private final SerialComManager scm;
    private final long handle;
    private File[] filesToSend;
    private String currentlySendingFileName;
    private long lengthOfFileToSend;
    private File filesToReceive;
    private final boolean textMode;
    private final ISerialComYmodemProgress progressListener;
    private final SerialComFTPCMDAbort transferState;
    private final int osType;
    private int blockNumber;
    private byte[] block = new byte[133];
    private byte[] block0 = null;
    private BufferedInputStream inStream;
    private BufferedOutputStream outStream;
    private boolean noMoreData;
    private boolean isFirstDataBytePending = false;
    private boolean isSecondDataBytePending = false;
    private boolean isThirdDataBytePending = false;
    private boolean isLineFeedPending = false;
    private boolean isCarriageReturnPending = false;
    private byte firstPendingDataByte;
    private byte secondPendingDataByte;
    private byte thirdPendingDataByte;
    private boolean alreadySentEOFchar = false;
    private byte[] tmpSendBuffer = new byte[1024];
    private byte[] tmpReceiveBuffer = new byte[512];
    private int mark = -1;
    private int limit = -1;
    private boolean lastCharacterReceivedWasLF = false;
    private boolean lastCharacterReceivedWasCR = false;
    private boolean unprocessedByteInReceivedDataExist = false;
    private byte unprocessedByteInLastReceivedBlock;
    private byte data0 = 0;
    private byte data1 = 0;
    private long numberOfBlocksSent = 0L;
    private long numberOfBlocksReceived = 0L;
    private boolean lastCharacterReceivedWasCAN = false;
    private int currentlyProcessingFilenumber = 0;
    private final byte[] ABORT_CMD = new byte[]{24, 24, 24, 24, 24, 8, 8, 8, 8, 8};
    private final SerialComCRCUtil crcCalculator = new SerialComCRCUtil();

    public SerialComYModemCRC(SerialComManager scm, long handle, File[] filesToSend, boolean textMode, ISerialComYmodemProgress progressListener, SerialComFTPCMDAbort transferState, int osType) {
        this.scm = scm;
        this.handle = handle;
        this.filesToSend = filesToSend;
        this.textMode = textMode;
        this.progressListener = progressListener;
        this.transferState = transferState;
        this.osType = osType;
    }

    public SerialComYModemCRC(SerialComManager scm, long handle, File filesToReceive, boolean textMode, ISerialComYmodemProgress progressListener, SerialComFTPCMDAbort transferState, int osType) {
        this.scm = scm;
        this.handle = handle;
        this.filesToReceive = filesToReceive;
        this.textMode = textMode;
        this.progressListener = progressListener;
        this.transferState = transferState;
        this.osType = osType;
    }

    /*
     * Unable to fully structure code
     */
    public boolean sendFileY() throws IOException {
        CONNECT = true;
        BLOCK0SEND = 2;
        BEGINSEND = 3;
        WAITACK = 4;
        RESEND = 5;
        SENDNEXT = 6;
        ENDTX = 7;
        ABORT = 8;
        FINISHTX = 9;
        cReceived = false;
        eotAckReceptionTimerInitialized = false;
        needToSendBlock0 = true;
        waitForBlock0ACK = true;
        waitForFinalBlockACK = false;
        errMsg = null;
        retryCount = 0;
        state = -1;
        data = null;
        responseWaitTimeOut = 0L;
        eotAckWaitTimeOutValue = 0L;
        percentOfBlocksSent = 0;
        finAckReceptionTimerInitialized = false;
        finAckWaitTimeOutValue = 0L;
        showSentProgress = false;
        this.currentlySendingFileName = this.filesToSend[this.currentlyProcessingFilenumber].getName();
        this.lengthOfFileToSend = this.filesToSend[this.currentlyProcessingFilenumber].length();
        this.inStream = new BufferedInputStream(new FileInputStream(this.filesToSend[this.currentlyProcessingFilenumber]));
        state = 1;
        block31: while (true) {
            switch (state) {
                case 1: {
                    cReceived = false;
                    responseWaitTimeOut = System.currentTimeMillis() + 60000L;
                    block32: do {
                        if (cReceived) continue block31;
                        try {
                            data = this.scm.readBytes(this.handle, 1024);
                        }
                        catch (SerialComException exp) {
                            this.inStream.close();
                            throw exp;
                        }
                        if (data != null && data.length > 0) {
                            x = 0;
                            while (x < data.length) {
                                if (data[x] == 67) {
                                    cReceived = true;
                                    if (needToSendBlock0) {
                                        state = 2;
                                        continue block32;
                                    }
                                    state = 3;
                                    continue block32;
                                }
                                ++x;
                            }
                            continue;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException x) {
                            // empty catch block
                        }
                        if (cReceived || System.currentTimeMillis() < responseWaitTimeOut) continue;
                        errMsg = "Timedout while waiting for file receiver to initiate connection setup !";
                        state = 8;
                        continue block31;
                    } while (this.transferState == null || !this.transferState.isTransferToBeAborted());
                    this.inStream.close();
                    this.scm.writeBytes(this.handle, this.ABORT_CMD, 0);
                    return false;
                }
                case 2: {
                    if (retryCount > 10) {
                        errMsg = "Maximum number of retries reached while sending block 0 to receiver end !";
                        state = 8;
                        continue block31;
                    }
                    this.assembleBlock0();
                    try {
                        this.scm.writeBytes(this.handle, this.block0, 0);
                    }
                    catch (SerialComException exp) {
                        this.inStream.close();
                        throw exp;
                    }
                    needToSendBlock0 = false;
                    waitForBlock0ACK = true;
                    showSentProgress = false;
                    state = 4;
                    continue block31;
                }
                case 3: {
                    this.blockNumber = 1;
                    this.assembleBlock();
                    if (this.noMoreData) {
                        state = 7;
                        continue block31;
                    }
                    try {
                        this.scm.writeBytes(this.handle, this.block, 0);
                    }
                    catch (SerialComException exp) {
                        this.inStream.close();
                        throw exp;
                    }
                    showSentProgress = true;
                    state = 4;
                    continue block31;
                }
                case 5: {
                    if (retryCount > 10) {
                        errMsg = "Maximum number of retries reached while sending same data block !";
                        state = 8;
                        continue block31;
                    }
                    try {
                        this.scm.writeBytes(this.handle, this.block, 0);
                    }
                    catch (SerialComException exp) {
                        this.inStream.close();
                        throw exp;
                    }
                    showSentProgress = true;
                    state = 4;
                    continue block31;
                }
                case 4: {
                    responseWaitTimeOut = System.currentTimeMillis() + 60000L;
                    do {
                        if (this.transferState != null && this.transferState.isTransferToBeAborted()) {
                            this.inStream.close();
                            this.scm.writeBytes(this.handle, this.ABORT_CMD, 0);
                            return false;
                        }
                        try {
                            if (!this.noMoreData) {
                                Thread.sleep(120L);
                            } else {
                                Thread.sleep(250L);
                            }
                        }
                        catch (InterruptedException exp) {
                            // empty catch block
                        }
                        try {
                            data = this.scm.readBytes(this.handle, 1);
                        }
                        catch (SerialComException exp) {
                            this.inStream.close();
                            throw exp;
                        }
                        if (data != null && data.length > 0) ** GOTO lbl147
                        if (!this.noMoreData) continue;
                        state = 7;
                        ** GOTO lbl147
                    } while (System.currentTimeMillis() < responseWaitTimeOut);
                    errMsg = this.noMoreData != false ? "Timedout while waiting for EOT reception acknowledgement from file receiver !" : (waitForBlock0ACK != false ? "Timedout while waiting for block0 reception acknowledgement from file receiver !" : "Timedout while waiting for block reception acknowledgement from file receiver !");
                    state = 8;
lbl147:
                    // 3 sources

                    if (state != 4) continue block31;
                    if (!this.noMoreData) {
                        if (data[0] == 6) {
                            if (this.lastCharacterReceivedWasCAN) {
                                if (!waitForBlock0ACK) {
                                    ++retryCount;
                                    state = 5;
                                    continue block31;
                                }
                                ++retryCount;
                                state = 2;
                                continue block31;
                            }
                            if (!waitForBlock0ACK) {
                                state = 6;
                            } else {
                                state = 1;
                                waitForBlock0ACK = false;
                            }
                        } else if (data[0] == 21) {
                            if (!waitForBlock0ACK) {
                                ++retryCount;
                                state = 5;
                            } else {
                                ++retryCount;
                                state = 2;
                            }
                        } else if (data[0] == 24) {
                            if (data.length >= 2) {
                                if (data[1] == 24) {
                                    errMsg = "Received abort command from file receiving end !";
                                    state = 8;
                                    continue block31;
                                }
                                if (!waitForBlock0ACK) {
                                    ++retryCount;
                                    state = 5;
                                } else {
                                    ++retryCount;
                                    state = 2;
                                }
                            }
                            if (this.lastCharacterReceivedWasCAN) {
                                errMsg = "Received abort command from file receiving end !";
                                state = 8;
                                continue block31;
                            }
                            this.lastCharacterReceivedWasCAN = true;
                        } else {
                            errMsg = "Invalid data byte : " + data[0] + " received from file receiver !";
                            state = 8;
                            continue block31;
                        }
                        if (!showSentProgress || this.progressListener == null) continue block31;
                        ++this.numberOfBlocksSent;
                        percentOfBlocksSent = this.lengthOfFileToSend != 0L ? (int)(12800L * this.numberOfBlocksSent / this.lengthOfFileToSend) : 100;
                        if (percentOfBlocksSent >= 100) {
                            percentOfBlocksSent = 100;
                        }
                        this.progressListener.onYmodemSentProgressUpdate(this.currentlySendingFileName, this.numberOfBlocksSent, percentOfBlocksSent);
                        continue block31;
                    }
                    if (data[0] == 6) {
                        if (waitForFinalBlockACK) {
                            return true;
                        }
                        this.inStream.close();
                        ++this.currentlyProcessingFilenumber;
                        if (this.currentlyProcessingFilenumber >= this.filesToSend.length) {
                            state = 9;
                            continue block31;
                        }
                        this.lengthOfFileToSend = this.filesToSend[this.currentlyProcessingFilenumber].length();
                        this.inStream = new BufferedInputStream(new FileInputStream(this.filesToSend[this.currentlyProcessingFilenumber]));
                        cReceived = false;
                        eotAckReceptionTimerInitialized = false;
                        retryCount = 0;
                        responseWaitTimeOut = 0L;
                        eotAckWaitTimeOutValue = 0L;
                        percentOfBlocksSent = 0;
                        needToSendBlock0 = true;
                        this.noMoreData = false;
                        this.alreadySentEOFchar = false;
                        this.alreadySentEOFchar = false;
                        this.isFirstDataBytePending = false;
                        this.isSecondDataBytePending = false;
                        this.isThirdDataBytePending = false;
                        this.isLineFeedPending = false;
                        this.isCarriageReturnPending = false;
                        this.mark = -1;
                        this.limit = -1;
                        this.lastCharacterReceivedWasLF = false;
                        this.lastCharacterReceivedWasCR = false;
                        this.unprocessedByteInReceivedDataExist = false;
                        this.lastCharacterReceivedWasCAN = false;
                        this.data0 = 0;
                        this.data1 = 0;
                        state = 1;
                        continue block31;
                    }
                    if (data[0] == 24) {
                        errMsg = "Received abort command from file receiving end !";
                        state = 8;
                        continue block31;
                    }
                    if (!waitForFinalBlockACK) {
                        if (System.currentTimeMillis() >= eotAckWaitTimeOutValue) {
                            errMsg = "Timedout while waiting for EOT reception acknowledgement !";
                            state = 8;
                            continue block31;
                        }
                        state = 7;
                        continue block31;
                    }
                    if (System.currentTimeMillis() >= finAckWaitTimeOutValue) {
                        errMsg = "Timedout while waiting for final ymodem null block reception acknowledgement !";
                        state = 8;
                        continue block31;
                    }
                    state = 9;
                    continue block31;
                }
                case 6: {
                    retryCount = 0;
                    ++this.blockNumber;
                    this.assembleBlock();
                    if (this.noMoreData) {
                        state = 7;
                        continue block31;
                    }
                    try {
                        this.scm.writeBytes(this.handle, this.block, 0);
                    }
                    catch (SerialComException exp) {
                        this.inStream.close();
                        throw exp;
                    }
                    showSentProgress = true;
                    state = 4;
                    continue block31;
                }
                case 7: {
                    if (!eotAckReceptionTimerInitialized) {
                        eotAckWaitTimeOutValue = System.currentTimeMillis() + 60000L;
                        eotAckReceptionTimerInitialized = true;
                    }
                    try {
                        this.scm.writeSingleByte(this.handle, (byte)4);
                    }
                    catch (SerialComException exp) {
                        this.inStream.close();
                        throw exp;
                    }
                    this.numberOfBlocksSent = 0L;
                    showSentProgress = false;
                    state = 4;
                    continue block31;
                }
                case 9: {
                    if (!finAckReceptionTimerInitialized) {
                        finAckWaitTimeOutValue = System.currentTimeMillis() + 60000L;
                        finAckReceptionTimerInitialized = true;
                        this.assembleFinalBlock();
                    }
                    try {
                        this.scm.writeBytes(this.handle, this.block, 0);
                    }
                    catch (SerialComException exp) {
                        this.inStream.close();
                        throw exp;
                    }
                    waitForFinalBlockACK = true;
                    showSentProgress = false;
                    state = 4;
                    continue block31;
                }
                case 8: {
                    this.inStream.close();
                    throw new SerialComException(errMsg);
                }
            }
        }
    }

    private void assembleBlock0() throws IOException {
        int g = 0;
        int k = 0;
        int blockCRCval = 0;
        byte[] lenfm = null;
        this.currentlySendingFileName = this.filesToSend[this.currentlyProcessingFilenumber].getName();
        byte[] nameb = this.currentlySendingFileName.getBytes();
        long fileLength = this.filesToSend[this.currentlyProcessingFilenumber].length();
        String lenstr = String.valueOf(fileLength);
        byte[] lenb = lenstr.getBytes();
        long filemoddate = this.filesToSend[this.currentlyProcessingFilenumber].lastModified();
        String fmdstr = Long.toOctalString(filemoddate);
        byte[] lenfmd = fmdstr.getBytes();
        if (this.osType != 2) {
            String fmstr = Long.toOctalString(32768L);
            lenfm = fmstr.getBytes();
        }
        if ((g = lenfm == null ? 3 + nameb.length + 1 + lenb.length + 1 + lenfmd.length + 2 : 3 + nameb.length + 1 + lenb.length + 1 + lenfmd.length + 1 + lenfm.length + 2) <= 133) {
            this.block0 = this.block;
            this.block0[0] = 1;
        } else {
            this.block0 = new byte[1029];
            this.block0[0] = 2;
        }
        this.block0[1] = 0;
        this.block0[2] = -1;
        g = 3;
        k = 0;
        while (k < nameb.length) {
            this.block0[g] = nameb[k];
            ++g;
            ++k;
        }
        this.block0[g] = 0;
        ++g;
        k = 0;
        while (k < lenb.length) {
            this.block0[g] = lenb[k];
            ++g;
            ++k;
        }
        this.block0[g] = 32;
        ++g;
        k = 0;
        while (k < lenfmd.length) {
            this.block0[g] = lenfmd[k];
            ++g;
            ++k;
        }
        this.block0[g] = 32;
        ++g;
        if (lenfm != null) {
            k = 0;
            while (k < lenfm.length) {
                this.block0[g] = lenfm[k];
                ++g;
                ++k;
            }
        } else {
            this.block0[g] = 0;
            ++g;
        }
        this.block0[g] = 32;
        k = ++g;
        while (k <= this.block0.length - 3) {
            this.block0[k] = 0;
            ++k;
        }
        blockCRCval = this.crcCalculator.getCRC16CCITTValue(this.block0, 3, this.block0.length - 3);
        this.block0[this.block0.length - 2] = (byte)(blockCRCval >>> 8);
        this.block0[this.block0.length - 1] = (byte)blockCRCval;
    }

    private void assembleFinalBlock() throws IOException {
        int blockCRCval = 0;
        this.block[0] = 1;
        this.block[1] = 0;
        this.block[2] = -1;
        int d = 0;
        while (d < 128) {
            this.block[d + 3] = 0;
            ++d;
        }
        blockCRCval = this.crcCalculator.getCRC16CCITTValue(this.block, 3, 130);
        this.block[131] = (byte)(blockCRCval >>> 8);
        this.block[132] = (byte)blockCRCval;
    }

    private void assembleBlock() throws IOException {
        int x = 0;
        int numBytesRead = 0;
        int blockCRCval = 0;
        if (this.blockNumber > 255) {
            this.blockNumber = 0;
        }
        this.block[0] = 1;
        this.block[1] = (byte)this.blockNumber;
        this.block[2] = (byte)(~this.blockNumber);
        if (this.textMode) {
            x = 3;
            if (this.isFirstDataBytePending) {
                this.block[x] = this.firstPendingDataByte;
                ++x;
                this.isFirstDataBytePending = false;
                if (this.isSecondDataBytePending) {
                    this.block[x] = this.secondPendingDataByte;
                    ++x;
                    this.isSecondDataBytePending = false;
                    if (this.isThirdDataBytePending) {
                        this.block[x] = this.thirdPendingDataByte;
                        ++x;
                        this.isThirdDataBytePending = false;
                    }
                }
            }
            while (x < 131) {
                if (this.mark == this.limit || this.mark == -1) {
                    this.limit = this.inStream.read(this.tmpSendBuffer, 0, 1024);
                    this.mark = 0;
                    if (this.limit < 0) {
                        if (this.isLineFeedPending) {
                            this.data0 = (byte)10;
                            this.isLineFeedPending = false;
                            this.data1 = (byte)-1;
                        } else if (this.isCarriageReturnPending) {
                            this.data0 = (byte)13;
                            this.isCarriageReturnPending = false;
                            this.data1 = (byte)-1;
                        } else {
                            this.data0 = (byte)-1;
                            this.data1 = (byte)-1;
                        }
                    } else if (this.limit == 1) {
                        if (this.isLineFeedPending) {
                            this.data0 = (byte)10;
                            this.isLineFeedPending = false;
                            this.data1 = this.tmpSendBuffer[this.mark];
                            ++this.mark;
                        } else if (this.isCarriageReturnPending) {
                            this.data0 = (byte)13;
                            this.isCarriageReturnPending = false;
                            this.data1 = this.tmpSendBuffer[this.mark];
                            ++this.mark;
                        } else {
                            this.data0 = this.tmpSendBuffer[this.mark];
                            ++this.mark;
                            this.data1 = (byte)-1;
                        }
                    } else if (this.isLineFeedPending) {
                        this.data0 = (byte)10;
                        this.isLineFeedPending = false;
                        this.data1 = this.tmpSendBuffer[this.mark];
                        ++this.mark;
                    } else if (this.isCarriageReturnPending) {
                        this.data0 = (byte)13;
                        this.isCarriageReturnPending = false;
                        this.data1 = this.tmpSendBuffer[this.mark];
                        ++this.mark;
                    } else {
                        this.data0 = this.tmpSendBuffer[this.mark];
                        ++this.mark;
                        this.data1 = this.tmpSendBuffer[this.mark];
                        ++this.mark;
                    }
                } else if (this.mark == this.limit - 1) {
                    if (this.isLineFeedPending) {
                        this.data0 = (byte)10;
                        this.isLineFeedPending = false;
                        this.data1 = this.tmpSendBuffer[this.mark];
                        ++this.mark;
                    } else if (this.isCarriageReturnPending) {
                        this.data0 = (byte)13;
                        this.isCarriageReturnPending = false;
                        this.data1 = this.tmpSendBuffer[this.mark];
                        ++this.mark;
                    } else {
                        this.data0 = this.tmpSendBuffer[this.mark];
                        ++this.mark;
                        this.limit = this.inStream.read(this.tmpSendBuffer, 0, 1024);
                        this.mark = 0;
                        if (this.limit < 0) {
                            this.data1 = (byte)-1;
                        } else {
                            this.data1 = this.tmpSendBuffer[this.mark];
                            ++this.mark;
                        }
                    }
                } else if (this.mark == 0 && this.limit == -1) {
                    if (this.isLineFeedPending) {
                        this.data0 = (byte)10;
                        this.isLineFeedPending = false;
                        this.data1 = (byte)-1;
                    } else if (this.isCarriageReturnPending) {
                        this.data0 = (byte)13;
                        this.isCarriageReturnPending = false;
                        this.data1 = (byte)-1;
                    } else {
                        this.data0 = (byte)-1;
                        this.data1 = (byte)-1;
                    }
                } else if (this.isLineFeedPending) {
                    this.data0 = (byte)10;
                    this.isLineFeedPending = false;
                    this.data1 = this.tmpSendBuffer[this.mark];
                    ++this.mark;
                } else if (this.isCarriageReturnPending) {
                    this.data0 = (byte)13;
                    this.isCarriageReturnPending = false;
                    this.data1 = this.tmpSendBuffer[this.mark];
                    ++this.mark;
                } else {
                    this.data0 = this.tmpSendBuffer[this.mark];
                    ++this.mark;
                    this.data1 = this.tmpSendBuffer[this.mark];
                    ++this.mark;
                }
                if (this.data0 == -1) {
                    if (this.alreadySentEOFchar) {
                        this.noMoreData = true;
                        return;
                    }
                    x += 0;
                    while (x < 131) {
                        this.block[x] = 26;
                        ++x;
                    }
                    this.alreadySentEOFchar = true;
                    continue;
                }
                if (this.data0 != -1 && this.data1 == -1) {
                    if (this.data0 == 10 || this.data0 == 13) {
                        this.block[x] = 13;
                        if (++x < 131) {
                            this.block[x] = 10;
                            ++x;
                            continue;
                        }
                        this.isFirstDataBytePending = true;
                        this.firstPendingDataByte = (byte)10;
                        continue;
                    }
                    this.block[x] = this.data0;
                    ++x;
                    continue;
                }
                if (this.data0 != 10 && this.data0 != 13) {
                    if (this.data1 != 10 && this.data1 != 13) {
                        this.block[x] = this.data0;
                        if (++x < 131) {
                            this.block[x] = this.data1;
                            ++x;
                            continue;
                        }
                        this.isFirstDataBytePending = true;
                        this.firstPendingDataByte = this.data1;
                        continue;
                    }
                    if (this.data1 == 10) {
                        this.block[x] = this.data0;
                        ++x;
                        this.isLineFeedPending = true;
                        continue;
                    }
                    this.block[x] = this.data0;
                    ++x;
                    this.isCarriageReturnPending = true;
                    continue;
                }
                if (this.data0 == 13 && this.data1 == 10 || this.data0 == 10 && this.data1 == 13) {
                    this.block[x] = 13;
                    if (++x < 131) {
                        this.block[x] = 10;
                        ++x;
                        continue;
                    }
                    this.isFirstDataBytePending = true;
                    this.firstPendingDataByte = (byte)10;
                    continue;
                }
                if (this.data0 == 10 && this.data1 != 13 && this.data1 != 10) {
                    this.block[x] = 13;
                    if (++x < 131) {
                        this.block[x] = 10;
                        if (++x < 131) {
                            this.block[x] = this.data1;
                            ++x;
                            continue;
                        }
                        this.isFirstDataBytePending = true;
                        this.firstPendingDataByte = this.data1;
                        continue;
                    }
                    this.isFirstDataBytePending = true;
                    this.firstPendingDataByte = (byte)10;
                    this.isSecondDataBytePending = true;
                    this.secondPendingDataByte = this.data1;
                    continue;
                }
                if (this.data0 == 13 && this.data1 != 13 && this.data1 != 10) {
                    this.block[x] = 13;
                    if (++x < 131) {
                        this.block[x] = 10;
                        if (++x < 131) {
                            this.block[x] = this.data1;
                            ++x;
                            continue;
                        }
                        this.isFirstDataBytePending = true;
                        this.firstPendingDataByte = this.data1;
                        continue;
                    }
                    this.isFirstDataBytePending = true;
                    this.firstPendingDataByte = (byte)10;
                    this.isSecondDataBytePending = true;
                    this.secondPendingDataByte = this.data1;
                    continue;
                }
                if ((this.data0 != 10 || this.data1 != 10) && (this.data0 != 13 || this.data1 != 13)) continue;
                this.block[x] = 13;
                if (++x < 131) {
                    this.block[x] = 10;
                    if (++x < 131) {
                        this.block[x] = 13;
                        if (++x < 131) {
                            this.block[x] = 10;
                            ++x;
                            continue;
                        }
                        this.isFirstDataBytePending = true;
                        this.firstPendingDataByte = (byte)10;
                        continue;
                    }
                    this.isFirstDataBytePending = true;
                    this.firstPendingDataByte = (byte)13;
                    this.isSecondDataBytePending = true;
                    this.secondPendingDataByte = (byte)10;
                    continue;
                }
                this.isFirstDataBytePending = true;
                this.firstPendingDataByte = (byte)10;
                this.isSecondDataBytePending = true;
                this.secondPendingDataByte = (byte)13;
                this.isThirdDataBytePending = true;
                this.thirdPendingDataByte = (byte)10;
            }
        } else {
            numBytesRead = this.inStream.read(this.block, 3, 128);
            if (numBytesRead != 128) {
                if (numBytesRead > 0) {
                    x = numBytesRead + 3;
                    while (x < 131) {
                        this.block[x] = 26;
                        ++x;
                    }
                } else {
                    this.noMoreData = true;
                    return;
                }
            }
        }
        blockCRCval = this.crcCalculator.getCRC16CCITTValue(this.block, 3, 130);
        this.block[131] = (byte)(blockCRCval >>> 8);
        this.block[132] = (byte)blockCRCval;
    }

    public boolean receiveFileY() throws IOException {
        boolean CONNECT = true;
        int BLOCK0RCV = 2;
        int PBLOCK0 = 3;
        int BEGINRCV = 4;
        int DATABLOCKRCV = 5;
        int VERIFY = 6;
        int REPLY = 7;
        int ABORT = 8;
        int i = 0;
        int x = 0;
        int crcl = 0;
        int state = -1;
        int blockNumber = 1;
        int blockCRCval = 0;
        int block0Index = 0;
        int dataBlockIndex = 0;
        byte[] data = null;
        String errMsg = null;
        int spaceLeftInBlock0 = 0;
        int spaceLeftInDataBlock = 0;
        byte[] block1029 = new byte[1029];
        long currentlyProcessingFileLength = 0L;
        long currentlyProcessingFileModifyInfo = 0L;
        long currentlyProcessingFileMode = 0L;
        boolean isFileOpen = false;
        String nameOfFileBeingReceived = null;
        String receiverDirAbsolutePath = this.filesToReceive.getAbsolutePath();
        boolean isCorrupted = false;
        boolean isDuplicateBlock = false;
        int duplicateBlockRetryCount = 0;
        long totalNumberOfDataBytesReadTillNow = 0L;
        int percentOfBlocksReceived = 0;
        try {
            this.scm.clearPortIOBuffers(this.handle, true, false);
        }
        catch (SerialComException exp) {
            this.outStream.close();
            throw exp;
        }
        state = 1;
        block42: while (true) {
            switch (state) {
                case 1: {
                    blockNumber = 1;
                    this.numberOfBlocksReceived = 0L;
                    totalNumberOfDataBytesReadTillNow = 0L;
                    this.lastCharacterReceivedWasLF = false;
                    this.lastCharacterReceivedWasCR = false;
                    this.unprocessedByteInReceivedDataExist = false;
                    x = 0;
                    while (x < 3) {
                        this.scm.writeSingleByte(this.handle, (byte)67);
                        try {
                            Thread.sleep(300L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        data = this.scm.readBytes(this.handle, 133);
                        if (data != null && data.length > 0) {
                            if (data[0] != 4) break;
                            this.scm.writeSingleByte(this.handle, (byte)6);
                        } else if (this.transferState != null && this.transferState.isTransferToBeAborted()) {
                            this.outStream.close();
                            this.scm.writeBytes(this.handle, this.ABORT_CMD, 0);
                            return false;
                        }
                        ++x;
                    }
                    if (x >= 3) {
                        throw new SerialComTimeOutException("Timed out while connecting with file sender !");
                    }
                    state = 2;
                    continue block42;
                }
                case 2: {
                    x = 0;
                    while (x < 3) {
                        if (data != null && data.length > 0) {
                            if (data[0] == true) {
                                this.block0 = this.block;
                                spaceLeftInBlock0 = 133;
                                crcl = 131;
                                break;
                            }
                            if (data[0] == 2) {
                                this.block0 = block1029;
                                spaceLeftInBlock0 = 1029;
                                crcl = 1027;
                                break;
                            }
                            this.scm.writeSingleByte(this.handle, (byte)21);
                            try {
                                Thread.sleep(300L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            data = this.scm.readBytes(this.handle, 133);
                        }
                        ++x;
                    }
                    if (x >= 3) {
                        throw new SerialComTimeOutException("Timed out while waiting for block 0 from file sender !");
                    }
                    x = 0;
                    while (x < data.length) {
                        this.block0[x] = data[x];
                        --spaceLeftInBlock0;
                        ++x;
                    }
                    if (spaceLeftInBlock0 > 0) {
                        block0Index = this.block0.length - spaceLeftInBlock0;
                        i = 0;
                        while (i < 20) {
                            if (this.transferState != null && this.transferState.isTransferToBeAborted()) {
                                this.outStream.close();
                                this.scm.writeBytes(this.handle, this.ABORT_CMD, 0);
                                return false;
                            }
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            data = this.scm.readBytes(this.handle, spaceLeftInBlock0);
                            if (data != null && data.length > 0) {
                                x = 0;
                                while (x < data.length) {
                                    this.block0[block0Index] = data[x];
                                    ++block0Index;
                                    --spaceLeftInBlock0;
                                    ++x;
                                }
                            }
                            if (spaceLeftInBlock0 <= 0) break;
                            ++i;
                        }
                    }
                    if (i >= 20) {
                        throw new SerialComTimeOutException("Timed out while receiving block 0 from file sender !");
                    }
                    state = 3;
                    continue block42;
                }
                case 3: {
                    if (this.block0[1] != 0 || this.block0[2] != -1) {
                        throw new SerialComException("Invalid information block 0 received !");
                    }
                    blockCRCval = this.crcCalculator.getCRC16CCITTValue(this.block0, 3, crcl - 1);
                    if (this.block0[crcl] != (byte)(blockCRCval >>> 8) || this.block0[crcl + 1] != (byte)blockCRCval) {
                        throw new SerialComException("Invalid CRC (corrupted block 0 or final block received) !");
                    }
                    if (this.block0[crcl] == 0 && this.block0[crcl + 1] == 0) {
                        i = 3;
                        while (i < this.block0.length) {
                            if (this.block0[i] != 0) break;
                            ++i;
                        }
                        if (i >= this.block0.length) {
                            this.scm.writeSingleByte(this.handle, (byte)6);
                            return true;
                        }
                    }
                    x = 3;
                    while (x < this.block0.length) {
                        if (this.block0[x] == 0) break;
                        ++x;
                    }
                    nameOfFileBeingReceived = new String(this.block0, 3, x - 3);
                    if (nameOfFileBeingReceived == null || nameOfFileBeingReceived.length() == 0) {
                        throw new SerialComException("Sender did not sent file name !");
                    }
                    File namefile = new File(receiverDirAbsolutePath, nameOfFileBeingReceived);
                    if (!namefile.exists()) {
                        namefile.createNewFile();
                    }
                    this.outStream = new BufferedOutputStream(new FileOutputStream(namefile));
                    isFileOpen = true;
                    i = ++x;
                    while (i < this.block0.length) {
                        if (this.block0[i] == 32) break;
                        ++i;
                    }
                    currentlyProcessingFileLength = Long.valueOf(new String(this.block0, x, i - x));
                    x = ++i;
                    while (x < this.block0.length) {
                        if (this.block0[x] == 32) break;
                        ++x;
                    }
                    currentlyProcessingFileModifyInfo = Long.valueOf(new String(this.block0, i, x - i), 8);
                    if (currentlyProcessingFileModifyInfo != 0L) {
                        namefile.setLastModified(currentlyProcessingFileModifyInfo);
                    }
                    i = ++x;
                    while (i < this.block0.length) {
                        if (this.block0[i] == 32) break;
                        ++i;
                    }
                    currentlyProcessingFileMode = Long.valueOf(new String(this.block0, x, i - x), 8);
                    this.scm.writeSingleByte(this.handle, (byte)6);
                    state = 4;
                    continue block42;
                }
                case 4: {
                    this.scm.writeSingleByte(this.handle, (byte)67);
                    state = 5;
                    state = 5;
                    continue block42;
                }
                case 5: {
                    spaceLeftInDataBlock = 133;
                    dataBlockIndex = 0;
                    state = 6;
                    i = 0;
                    while (i < 10) {
                        if (this.transferState != null && this.transferState.isTransferToBeAborted()) {
                            this.outStream.close();
                            this.scm.writeBytes(this.handle, this.ABORT_CMD, 0);
                            return false;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        data = this.scm.readBytes(this.handle, spaceLeftInDataBlock);
                        if (data != null && data.length > 0) {
                            x = 0;
                            while (x < data.length) {
                                this.block[dataBlockIndex] = data[x];
                                ++dataBlockIndex;
                                --spaceLeftInDataBlock;
                                ++x;
                            }
                            if (this.block[0] == 4) {
                                try {
                                    this.scm.writeSingleByte(this.handle, (byte)6);
                                    if (isFileOpen) {
                                        this.outStream.flush();
                                        this.outStream.close();
                                    }
                                    isFileOpen = false;
                                    state = 1;
                                }
                                catch (IOException e) {
                                    state = 8;
                                    errMsg = e.getMessage();
                                }
                                break;
                            }
                            if (this.block[dataBlockIndex - 1] == 24 && dataBlockIndex > 1 && this.block[dataBlockIndex - 2] == 24) {
                                state = 8;
                                errMsg = "Abort command received from file sending application !";
                                break;
                            }
                        }
                        if (spaceLeftInDataBlock <= 0) break;
                        ++i;
                    }
                    if (state != 5 || i < 10) continue block42;
                    throw new SerialComTimeOutException("Timed out while receiving data block from file sender !");
                }
                case 6: {
                    isCorrupted = false;
                    isDuplicateBlock = false;
                    state = 7;
                    if (this.block[0] != 1) {
                        isCorrupted = true;
                        continue block42;
                    }
                    if (this.block[1] == (byte)(blockNumber - 1)) {
                        isDuplicateBlock = true;
                        if (++duplicateBlockRetryCount <= 10) continue block42;
                        errMsg = "Maximum number of retries reached while receiving same data block !";
                        state = 8;
                        continue block42;
                    }
                    if (this.block[1] != (byte)blockNumber || this.block[2] != (byte)(~blockNumber)) {
                        isCorrupted = true;
                        continue block42;
                    }
                    blockCRCval = this.crcCalculator.getCRC16CCITTValue(this.block, 3, 130);
                    if (this.block[131] == (byte)(blockCRCval >>> 8) && this.block[132] == (byte)blockCRCval) continue block42;
                    isCorrupted = true;
                    continue block42;
                }
                case 7: {
                    if (!isCorrupted) {
                        this.scm.writeSingleByte(this.handle, (byte)6);
                        totalNumberOfDataBytesReadTillNow += 128L;
                        if (this.textMode) {
                            this.processAndWrite(this.block);
                        } else if (currentlyProcessingFileLength != 0L) {
                            if (totalNumberOfDataBytesReadTillNow <= currentlyProcessingFileLength) {
                                this.outStream.write(this.block, 3, 128);
                            } else {
                                this.outStream.write(this.block, 3, (int)(128L - (totalNumberOfDataBytesReadTillNow - currentlyProcessingFileLength)));
                            }
                        } else {
                            this.outStream.write(this.block, 3, 128);
                        }
                        if (this.progressListener != null) {
                            ++this.numberOfBlocksReceived;
                            percentOfBlocksReceived = currentlyProcessingFileLength > 0L ? (int)(12800L * this.numberOfBlocksReceived / currentlyProcessingFileLength) : 100;
                            if (percentOfBlocksReceived >= 100) {
                                percentOfBlocksReceived = 100;
                            }
                            this.progressListener.onYmodemReceiveProgressUpdate(nameOfFileBeingReceived, this.numberOfBlocksReceived, percentOfBlocksReceived);
                        }
                        if (!isDuplicateBlock) {
                            if (++blockNumber > 255) {
                                blockNumber = 0;
                            }
                            duplicateBlockRetryCount = 0;
                        }
                    } else {
                        this.scm.writeSingleByte(this.handle, (byte)21);
                    }
                    state = 5;
                    continue block42;
                }
                case 8: {
                    if (isFileOpen) {
                        this.outStream.flush();
                        this.outStream.close();
                    }
                    throw new SerialComException(errMsg);
                }
            }
        }
    }

    private void processAndWrite(byte[] block) throws IOException {
        this.mark = 3;
        int q = 0;
        while (this.mark <= 129) {
            if (!this.unprocessedByteInReceivedDataExist) {
                if (this.lastCharacterReceivedWasLF) {
                    this.data0 = (byte)10;
                    this.lastCharacterReceivedWasLF = false;
                } else if (this.lastCharacterReceivedWasCR) {
                    this.data0 = (byte)13;
                    this.lastCharacterReceivedWasCR = false;
                } else {
                    this.data0 = block[this.mark];
                    ++this.mark;
                }
                this.data1 = block[this.mark];
                ++this.mark;
            } else {
                this.data0 = this.unprocessedByteInLastReceivedBlock;
                this.unprocessedByteInReceivedDataExist = false;
                this.data1 = block[this.mark];
                ++this.mark;
            }
            if (this.data0 == 13) {
                if (this.data1 == 10) {
                    if (this.osType == 2) {
                        this.tmpReceiveBuffer[q] = 13;
                        this.tmpReceiveBuffer[q + 1] = 10;
                        q += 2;
                        continue;
                    }
                    if (this.osType != 4 && this.osType != 1) continue;
                    this.tmpReceiveBuffer[q] = 10;
                    ++q;
                    continue;
                }
                if (this.data1 == 13) {
                    if (this.osType == 2) {
                        this.tmpReceiveBuffer[q] = 13;
                        this.tmpReceiveBuffer[q + 1] = 10;
                        this.tmpReceiveBuffer[q + 2] = 13;
                        this.tmpReceiveBuffer[q + 3] = 10;
                        q += 4;
                        continue;
                    }
                    if (this.osType != 4 && this.osType != 1) continue;
                    this.tmpReceiveBuffer[q] = 10;
                    this.tmpReceiveBuffer[q + 1] = 10;
                    q += 2;
                    continue;
                }
                if (this.data1 == 26) {
                    if (this.osType == 2) {
                        this.tmpReceiveBuffer[q] = 13;
                        this.tmpReceiveBuffer[q + 1] = 10;
                        q += 2;
                        continue;
                    }
                    if (this.osType != 4 && this.osType != 1) continue;
                    this.tmpReceiveBuffer[q] = 10;
                    ++q;
                    continue;
                }
                if (this.osType == 2) {
                    this.tmpReceiveBuffer[q] = 13;
                    this.tmpReceiveBuffer[q + 1] = 10;
                    this.tmpReceiveBuffer[q + 2] = this.data1;
                    q += 3;
                    continue;
                }
                if (this.osType != 4 && this.osType != 1) continue;
                this.tmpReceiveBuffer[q] = 10;
                this.tmpReceiveBuffer[q + 1] = this.data1;
                q += 2;
                continue;
            }
            if (this.data0 == 10) {
                if (this.data1 == 10) {
                    if (this.osType == 2) {
                        this.tmpReceiveBuffer[q] = 13;
                        this.tmpReceiveBuffer[q + 1] = 10;
                        this.tmpReceiveBuffer[q + 2] = 13;
                        this.tmpReceiveBuffer[q + 3] = 10;
                        q += 4;
                        continue;
                    }
                    if (this.osType != 4 && this.osType != 1) continue;
                    this.tmpReceiveBuffer[q] = 10;
                    this.tmpReceiveBuffer[q + 1] = 10;
                    q += 2;
                    continue;
                }
                if (this.data1 == 13) {
                    if (this.osType == 2) {
                        this.tmpReceiveBuffer[q] = 13;
                        this.tmpReceiveBuffer[q + 1] = 10;
                        q += 2;
                        continue;
                    }
                    if (this.osType != 4 && this.osType != 1) continue;
                    this.tmpReceiveBuffer[q] = 10;
                    ++q;
                    continue;
                }
                if (this.data1 == 26) {
                    if (this.osType == 2) {
                        this.tmpReceiveBuffer[q] = 13;
                        this.tmpReceiveBuffer[q + 1] = 10;
                        q += 2;
                        continue;
                    }
                    if (this.osType != 4 && this.osType != 1) continue;
                    this.tmpReceiveBuffer[q] = 10;
                    ++q;
                    continue;
                }
                if (this.osType == 2) {
                    this.tmpReceiveBuffer[q] = 13;
                    this.tmpReceiveBuffer[q + 1] = 10;
                    this.tmpReceiveBuffer[q + 2] = this.data1;
                    q += 3;
                    continue;
                }
                if (this.osType != 4 && this.osType != 1) continue;
                this.tmpReceiveBuffer[q] = 10;
                this.tmpReceiveBuffer[q + 1] = this.data1;
                q += 2;
                continue;
            }
            if (this.data0 == 26) {
                if (this.data1 == 10) {
                    this.lastCharacterReceivedWasLF = true;
                    continue;
                }
                if (this.data1 == 13) {
                    this.lastCharacterReceivedWasCR = true;
                    continue;
                }
                if (this.data1 == 26) continue;
                this.tmpReceiveBuffer[q] = this.data1;
                ++q;
                continue;
            }
            if (this.data1 == 10) {
                this.tmpReceiveBuffer[q] = this.data0;
                ++q;
                this.lastCharacterReceivedWasLF = true;
                continue;
            }
            if (this.data1 == 13) {
                this.tmpReceiveBuffer[q] = this.data0;
                ++q;
                this.lastCharacterReceivedWasCR = true;
                continue;
            }
            if (this.data1 == 26) {
                this.tmpReceiveBuffer[q] = this.data0;
                ++q;
                continue;
            }
            this.tmpReceiveBuffer[q] = this.data0;
            this.tmpReceiveBuffer[q + 1] = this.data1;
            q += 2;
        }
        this.outStream.write(this.tmpReceiveBuffer, 0, q);
        if (this.mark == 130) {
            this.unprocessedByteInReceivedDataExist = true;
            this.unprocessedByteInLastReceivedBlock = block[130];
        }
    }
}

