/*
 * Decompiled with CFR 0.152.
 */
package com.serialpundit.serial.ftp;

import com.serialpundit.core.SerialComException;
import com.serialpundit.core.SerialComTimeOutException;
import com.serialpundit.core.util.RingArrayBlockingQueue;
import com.serialpundit.core.util.SerialComCRCUtil;
import com.serialpundit.serial.SerialComManager;
import com.serialpundit.serial.ftp.ISerialComYmodemProgress;
import com.serialpundit.serial.ftp.SerialComFTPCMDAbort;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public final class SerialComYModemG {
    private final byte SOH = 1;
    private final byte STX = (byte)2;
    private final byte EOT = (byte)4;
    private final byte ACK = (byte)6;
    private final byte CAN = (byte)24;
    private final byte SUB = (byte)26;
    private final byte G = (byte)71;
    private final byte CR = (byte)13;
    private final byte LF = (byte)10;
    private final byte BS = (byte)8;
    private final byte SPACE = (byte)32;
    private final SerialComManager scm;
    private final long handle;
    private File[] filesToSend;
    private String currentlySendingFileName;
    private long lengthOfFileToSend;
    private File filesToReceive;
    private final boolean textMode;
    private final ISerialComYmodemProgress progressListener;
    private final SerialComFTPCMDAbort transferState;
    private final int osType;
    private int blockNumber;
    private byte[] block = new byte[1029];
    private byte[] block0 = null;
    private BufferedInputStream inStream;
    private BufferedOutputStream outStream;
    private boolean noMoreData;
    private boolean isFirstDataBytePending = false;
    private boolean isSecondDataBytePending = false;
    private boolean isThirdDataBytePending = false;
    private boolean isLineFeedPending = false;
    private boolean isCarriageReturnPending = false;
    private byte firstPendingDataByte;
    private byte secondPendingDataByte;
    private byte thirdPendingDataByte;
    private boolean alreadySentEOFchar = false;
    private byte[] tmpSendBuffer = new byte[2048];
    private byte[] tmpReceiveBuffer = new byte[2526];
    private int mark = -1;
    private int limit = -1;
    private boolean lastCharacterReceivedWasLF = false;
    private boolean lastCharacterReceivedWasCR = false;
    private boolean unprocessedByteInReceivedDataExist = false;
    private byte unprocessedByteInLastReceivedBlock;
    private byte data0 = 0;
    private byte data1 = 0;
    private long numberOfBlocksSent = 0L;
    private long numberOfBlocksReceived = 0L;
    private int currentlyProcessingFilenumber = 0;
    private final byte[] ABORT_CMD = new byte[]{24, 24, 24, 24, 24, 8, 8, 8, 8, 8};
    private final SerialComCRCUtil crcCalculator = new SerialComCRCUtil();

    public SerialComYModemG(SerialComManager scm, long handle, File[] filesToSend, boolean textMode, ISerialComYmodemProgress progressListener, SerialComFTPCMDAbort transferState, int osType) {
        this.scm = scm;
        this.handle = handle;
        this.filesToSend = filesToSend;
        this.textMode = textMode;
        this.progressListener = progressListener;
        this.transferState = transferState;
        this.osType = osType;
    }

    public SerialComYModemG(SerialComManager scm, long handle, File filesToReceive, boolean textMode, ISerialComYmodemProgress progressListener, SerialComFTPCMDAbort transferState, int osType) {
        this.scm = scm;
        this.handle = handle;
        this.filesToReceive = filesToReceive;
        this.textMode = textMode;
        this.progressListener = progressListener;
        this.transferState = transferState;
        this.osType = osType;
    }

    public boolean receiveFileY() throws IOException {
        RingArrayBlockingQueue dataQueue = new RingArrayBlockingQueue(1024);
        ExecutorService threadpool = Executors.newFixedThreadPool(2);
        DataCollector taskDataCollection = new DataCollector((RingArrayBlockingQueue<byte[]>)dataQueue);
        DataProcessor taskDataProcessing = new DataProcessor((RingArrayBlockingQueue<byte[]>)dataQueue);
        taskDataCollection.setDataProcessorRef(taskDataProcessing);
        taskDataProcessing.setDataCollectorRef(taskDataCollection);
        Future<Object> DataProcessorFutureResult = threadpool.submit(taskDataProcessing);
        Future<Object> DataCollectionFutureResult = threadpool.submit(taskDataCollection);
        while (true) {
            try {
                DataProcessorFutureResult.get();
                DataCollectionFutureResult.get();
            }
            catch (InterruptedException e) {
                continue;
            }
            catch (Exception e) {
                threadpool.shutdown();
                throw (SerialComException)new SerialComException(e.getMessage()).initCause((Throwable)e);
            }
            break;
        }
        threadpool.shutdown();
        return true;
    }

    public boolean sendFileY() throws IOException {
        boolean CONNECT = true;
        int BLOCK0SEND = 2;
        int BEGINSEND = 3;
        int WAITACK = 4;
        int ENDTX = 5;
        int ABORT = 6;
        int FINISHTX = 7;
        boolean gReceived = false;
        boolean needToSendBlock0 = true;
        String errMsg = null;
        int state = -1;
        byte[] data = null;
        long responseWaitTimeOut = 0L;
        long eotWaitTimeOut = 0L;
        int percentOfBlocksSent = 0;
        this.currentlySendingFileName = this.filesToSend[this.currentlyProcessingFilenumber].getName();
        this.lengthOfFileToSend = this.filesToSend[this.currentlyProcessingFilenumber].length();
        this.inStream = new BufferedInputStream(new FileInputStream(this.filesToSend[this.currentlyProcessingFilenumber]));
        state = 1;
        block31: while (true) {
            switch (state) {
                case 1: {
                    gReceived = false;
                    responseWaitTimeOut = System.currentTimeMillis() + 60000L;
                    block32: do {
                        if (gReceived) continue block31;
                        try {
                            data = this.scm.readBytes(this.handle, 1024);
                        }
                        catch (SerialComException exp) {
                            this.inStream.close();
                            throw exp;
                        }
                        if (data != null && data.length > 0) {
                            int x = 0;
                            while (x < data.length) {
                                if (data[x] == 71) {
                                    gReceived = true;
                                    if (needToSendBlock0) {
                                        state = 2;
                                        continue block32;
                                    }
                                    state = 3;
                                    continue block32;
                                }
                                ++x;
                            }
                            continue;
                        }
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException x) {
                            // empty catch block
                        }
                        if (gReceived || System.currentTimeMillis() < responseWaitTimeOut) continue;
                        errMsg = "Timedout while waiting for file receiver to initiate connection setup !";
                        state = 6;
                        continue block31;
                    } while (this.transferState == null || !this.transferState.isTransferToBeAborted());
                    this.inStream.close();
                    this.scm.writeBytes(this.handle, this.ABORT_CMD, 0);
                    return false;
                }
                case 2: {
                    if (this.transferState != null && this.transferState.isTransferToBeAborted()) {
                        this.scm.writeBytes(this.handle, this.ABORT_CMD, 0);
                        return false;
                    }
                    this.assembleBlock0();
                    try {
                        this.scm.writeBytes(this.handle, this.block0, 0);
                    }
                    catch (SerialComException exp) {
                        this.inStream.close();
                        throw exp;
                    }
                    needToSendBlock0 = false;
                    this.block0 = null;
                    this.blockNumber = 1;
                    state = 1;
                    continue block31;
                }
                case 3: {
                    if (this.transferState != null && this.transferState.isTransferToBeAborted()) {
                        this.scm.writeBytes(this.handle, this.ABORT_CMD, 0);
                        return false;
                    }
                    try {
                        data = this.scm.readBytes(this.handle, 2);
                        if (data != null && data.length > 0 && data[0] == 24 && data.length > 1 && data[1] == 24) {
                            errMsg = "Received abort command from file receiving end !";
                            state = 6;
                            continue block31;
                        }
                    }
                    catch (IOException exp) {
                        this.inStream.close();
                        throw exp;
                    }
                    this.assembleBlock();
                    if (this.noMoreData) {
                        state = 5;
                        continue block31;
                    }
                    try {
                        this.scm.writeBytes(this.handle, this.block, 0);
                    }
                    catch (SerialComException exp) {
                        this.inStream.close();
                        throw exp;
                    }
                    if (this.progressListener != null) {
                        ++this.numberOfBlocksSent;
                        percentOfBlocksSent = this.lengthOfFileToSend != 0L ? (int)(102400L * this.numberOfBlocksSent / this.lengthOfFileToSend) : 100;
                        if (percentOfBlocksSent >= 100) {
                            percentOfBlocksSent = 100;
                        }
                        this.progressListener.onYmodemSentProgressUpdate(this.currentlySendingFileName, this.numberOfBlocksSent, percentOfBlocksSent);
                    }
                    try {
                        if (this.osType == 2) {
                            Thread.sleep(250L);
                        } else {
                            Thread.sleep(200L);
                        }
                    }
                    catch (Exception exp) {
                        // empty catch block
                    }
                    ++this.blockNumber;
                    continue block31;
                }
                case 4: {
                    eotWaitTimeOut = System.currentTimeMillis() + 1500L;
                    do {
                        if (this.transferState != null && this.transferState.isTransferToBeAborted()) {
                            this.scm.writeBytes(this.handle, this.ABORT_CMD, 0);
                            return false;
                        }
                        try {
                            data = this.scm.readBytes(this.handle, 1);
                            if (data != null && data.length > 0 && data[0] == 24) {
                                errMsg = "Received abort command from file receiving end !";
                                state = 6;
                                continue block31;
                            }
                        }
                        catch (IOException exp) {
                            this.inStream.close();
                            throw exp;
                        }
                        if (data == null || data.length <= 0) continue;
                        if (data[0] == 6) {
                            ++this.currentlyProcessingFilenumber;
                            if (this.currentlyProcessingFilenumber >= this.filesToSend.length) {
                                state = 7;
                                continue block31;
                            }
                            this.lengthOfFileToSend = this.filesToSend[this.currentlyProcessingFilenumber].length();
                            this.inStream = new BufferedInputStream(new FileInputStream(this.filesToSend[this.currentlyProcessingFilenumber]));
                            gReceived = false;
                            responseWaitTimeOut = 0L;
                            percentOfBlocksSent = 0;
                            needToSendBlock0 = true;
                            this.noMoreData = false;
                            this.alreadySentEOFchar = false;
                            this.isFirstDataBytePending = false;
                            this.isSecondDataBytePending = false;
                            this.isThirdDataBytePending = false;
                            this.isLineFeedPending = false;
                            this.isCarriageReturnPending = false;
                            this.mark = -1;
                            this.limit = -1;
                            this.lastCharacterReceivedWasLF = false;
                            this.lastCharacterReceivedWasCR = false;
                            this.unprocessedByteInReceivedDataExist = false;
                            this.data0 = 0;
                            this.data1 = 0;
                            try {
                                Thread.sleep(200L);
                            }
                            catch (Exception exp) {
                                // empty catch block
                            }
                            state = 1;
                            continue block31;
                        }
                        if (data[0] == 24) {
                            errMsg = "Received abort command from file receiving end !";
                            state = 6;
                            continue block31;
                        }
                        if (System.currentTimeMillis() < eotWaitTimeOut) continue block31;
                        errMsg = "Timedout while waiting for EOT reception acknowledgement from file receiver !";
                        state = 6;
                        continue block31;
                    } while (System.currentTimeMillis() < eotWaitTimeOut);
                    errMsg = "Timedout while waiting for EOT reception acknowledgement from file receiver !";
                    state = 6;
                    continue block31;
                }
                case 5: {
                    try {
                        this.scm.writeSingleByte(this.handle, (byte)4);
                    }
                    catch (SerialComException exp) {
                        this.inStream.close();
                        throw exp;
                    }
                    this.inStream.close();
                    this.numberOfBlocksSent = 0L;
                    state = 4;
                    continue block31;
                }
                case 7: {
                    if (this.transferState != null && this.transferState.isTransferToBeAborted()) {
                        this.scm.writeBytes(this.handle, this.ABORT_CMD, 0);
                        return false;
                    }
                    this.assembleFinalBlock();
                    try {
                        this.scm.writeBytes(this.handle, this.block, 0);
                    }
                    catch (SerialComException exp) {
                        this.inStream.close();
                        throw exp;
                    }
                    return true;
                }
                case 6: {
                    this.inStream.close();
                    throw new SerialComTimeOutException(errMsg);
                }
            }
        }
    }

    private void assembleBlock0() throws IOException {
        int g = 0;
        int k = 0;
        int blockCRCval = 0;
        byte[] lenfm = null;
        this.currentlySendingFileName = this.filesToSend[this.currentlyProcessingFilenumber].getName();
        byte[] nameb = this.currentlySendingFileName.getBytes();
        long fileLength = this.filesToSend[this.currentlyProcessingFilenumber].length();
        String lenstr = String.valueOf(fileLength);
        byte[] lenb = lenstr.getBytes();
        long filemoddate = this.filesToSend[this.currentlyProcessingFilenumber].lastModified();
        String fmdstr = Long.toOctalString(filemoddate);
        byte[] lenfmd = fmdstr.getBytes();
        if (this.osType != 2) {
            String fmstr = Long.toOctalString(32768L);
            lenfm = fmstr.getBytes();
        }
        if ((g = lenfm == null ? 3 + nameb.length + 1 + lenb.length + 1 + lenfmd.length + 2 : 3 + nameb.length + 1 + lenb.length + 1 + lenfmd.length + 1 + lenfm.length + 2) <= 133) {
            this.block0 = new byte[133];
            this.block0[0] = 1;
        } else {
            this.block0 = new byte[1029];
            this.block0[0] = 2;
        }
        this.block0[1] = 0;
        this.block0[2] = -1;
        g = 3;
        k = 0;
        while (k < nameb.length) {
            this.block0[g] = nameb[k];
            ++g;
            ++k;
        }
        this.block0[g] = 0;
        ++g;
        k = 0;
        while (k < lenb.length) {
            this.block0[g] = lenb[k];
            ++g;
            ++k;
        }
        this.block0[g] = 32;
        ++g;
        k = 0;
        while (k < lenfmd.length) {
            this.block0[g] = lenfmd[k];
            ++g;
            ++k;
        }
        this.block0[g] = 32;
        ++g;
        if (lenfm != null) {
            k = 0;
            while (k < lenfm.length) {
                this.block0[g] = lenfm[k];
                ++g;
                ++k;
            }
        } else {
            this.block0[g] = 0;
            ++g;
        }
        this.block0[g] = 32;
        k = ++g;
        while (k <= this.block0.length - 3) {
            this.block0[k] = 0;
            ++k;
        }
        blockCRCval = this.crcCalculator.getCRC16CCITTValue(this.block0, 3, this.block0.length - 3);
        this.block0[this.block0.length - 2] = (byte)(blockCRCval >>> 8);
        this.block0[this.block0.length - 1] = (byte)blockCRCval;
    }

    private void assembleFinalBlock() throws IOException {
        int blockCRCval = 0;
        this.block[0] = 1;
        this.block[1] = 0;
        this.block[2] = -1;
        int d = 0;
        while (d < 128) {
            this.block[d + 3] = 0;
            ++d;
        }
        blockCRCval = this.crcCalculator.getCRC16CCITTValue(this.block, 3, 130);
        this.block[131] = (byte)(blockCRCval >>> 8);
        this.block[132] = (byte)blockCRCval;
    }

    private void assembleBlock() throws IOException {
        int x = 0;
        int numBytesRead = 0;
        int blockCRCval = 0;
        if (this.blockNumber > 255) {
            this.blockNumber = 0;
        }
        this.block[0] = 2;
        this.block[1] = (byte)this.blockNumber;
        this.block[2] = (byte)(~this.blockNumber);
        if (this.textMode) {
            x = 3;
            if (this.isFirstDataBytePending) {
                this.block[x] = this.firstPendingDataByte;
                ++x;
                this.isFirstDataBytePending = false;
                if (this.isSecondDataBytePending) {
                    this.block[x] = this.secondPendingDataByte;
                    ++x;
                    this.isSecondDataBytePending = false;
                    if (this.isThirdDataBytePending) {
                        this.block[x] = this.thirdPendingDataByte;
                        ++x;
                        this.isThirdDataBytePending = false;
                    }
                }
            }
            while (x < 1027) {
                if (this.mark == this.limit || this.mark == -1) {
                    this.limit = this.inStream.read(this.tmpSendBuffer, 0, 2048);
                    this.mark = 0;
                    if (this.limit < 0) {
                        if (this.isLineFeedPending) {
                            this.data0 = (byte)10;
                            this.isLineFeedPending = false;
                            this.data1 = (byte)-1;
                        } else if (this.isCarriageReturnPending) {
                            this.data0 = (byte)13;
                            this.isCarriageReturnPending = false;
                            this.data1 = (byte)-1;
                        } else {
                            this.data0 = (byte)-1;
                            this.data1 = (byte)-1;
                        }
                    } else if (this.limit == 1) {
                        if (this.isLineFeedPending) {
                            this.data0 = (byte)10;
                            this.isLineFeedPending = false;
                            this.data1 = this.tmpSendBuffer[this.mark];
                            ++this.mark;
                        } else if (this.isCarriageReturnPending) {
                            this.data0 = (byte)13;
                            this.isCarriageReturnPending = false;
                            this.data1 = this.tmpSendBuffer[this.mark];
                            ++this.mark;
                        } else {
                            this.data0 = this.tmpSendBuffer[this.mark];
                            ++this.mark;
                            this.data1 = (byte)-1;
                        }
                    } else if (this.isLineFeedPending) {
                        this.data0 = (byte)10;
                        this.isLineFeedPending = false;
                        this.data1 = this.tmpSendBuffer[this.mark];
                        ++this.mark;
                    } else if (this.isCarriageReturnPending) {
                        this.data0 = (byte)13;
                        this.isCarriageReturnPending = false;
                        this.data1 = this.tmpSendBuffer[this.mark];
                        ++this.mark;
                    } else {
                        this.data0 = this.tmpSendBuffer[this.mark];
                        ++this.mark;
                        this.data1 = this.tmpSendBuffer[this.mark];
                        ++this.mark;
                    }
                } else if (this.mark == this.limit - 1) {
                    if (this.isLineFeedPending) {
                        this.data0 = (byte)10;
                        this.isLineFeedPending = false;
                        this.data1 = this.tmpSendBuffer[this.mark];
                        ++this.mark;
                    } else if (this.isCarriageReturnPending) {
                        this.data0 = (byte)13;
                        this.isCarriageReturnPending = false;
                        this.data1 = this.tmpSendBuffer[this.mark];
                        ++this.mark;
                    } else {
                        this.data0 = this.tmpSendBuffer[this.mark];
                        ++this.mark;
                        this.limit = this.inStream.read(this.tmpSendBuffer, 0, 1024);
                        this.mark = 0;
                        if (this.limit < 0) {
                            this.data1 = (byte)-1;
                        } else {
                            this.data1 = this.tmpSendBuffer[this.mark];
                            ++this.mark;
                        }
                    }
                } else if (this.mark == 0 && this.limit == -1) {
                    if (this.isLineFeedPending) {
                        this.data0 = (byte)10;
                        this.isLineFeedPending = false;
                        this.data1 = (byte)-1;
                    } else if (this.isCarriageReturnPending) {
                        this.data0 = (byte)13;
                        this.isCarriageReturnPending = false;
                        this.data1 = (byte)-1;
                    } else {
                        this.data0 = (byte)-1;
                        this.data1 = (byte)-1;
                    }
                } else if (this.isLineFeedPending) {
                    this.data0 = (byte)10;
                    this.isLineFeedPending = false;
                    this.data1 = this.tmpSendBuffer[this.mark];
                    ++this.mark;
                } else if (this.isCarriageReturnPending) {
                    this.data0 = (byte)13;
                    this.isCarriageReturnPending = false;
                    this.data1 = this.tmpSendBuffer[this.mark];
                    ++this.mark;
                } else {
                    this.data0 = this.tmpSendBuffer[this.mark];
                    ++this.mark;
                    this.data1 = this.tmpSendBuffer[this.mark];
                    ++this.mark;
                }
                if (this.data0 == -1) {
                    if (this.alreadySentEOFchar) {
                        this.noMoreData = true;
                        return;
                    }
                    x += 0;
                    while (x < 1027) {
                        this.block[x] = 26;
                        ++x;
                    }
                    this.alreadySentEOFchar = true;
                    continue;
                }
                if (this.data0 != -1 && this.data1 == -1) {
                    if (this.data0 == 10 || this.data0 == 13) {
                        this.block[x] = 13;
                        if (++x < 1027) {
                            this.block[x] = 10;
                            ++x;
                            continue;
                        }
                        this.isFirstDataBytePending = true;
                        this.firstPendingDataByte = (byte)10;
                        continue;
                    }
                    this.block[x] = this.data0;
                    ++x;
                    continue;
                }
                if (this.data0 != 10 && this.data0 != 13) {
                    if (this.data1 != 10 && this.data1 != 13) {
                        this.block[x] = this.data0;
                        if (++x < 1027) {
                            this.block[x] = this.data1;
                            ++x;
                            continue;
                        }
                        this.isFirstDataBytePending = true;
                        this.firstPendingDataByte = this.data1;
                        continue;
                    }
                    if (this.data1 == 10) {
                        this.block[x] = this.data0;
                        ++x;
                        this.isLineFeedPending = true;
                        continue;
                    }
                    this.block[x] = this.data0;
                    ++x;
                    this.isCarriageReturnPending = true;
                    continue;
                }
                if (this.data0 == 13 && this.data1 == 10 || this.data0 == 10 && this.data1 == 13) {
                    this.block[x] = 13;
                    if (++x < 1027) {
                        this.block[x] = 10;
                        ++x;
                        continue;
                    }
                    this.isFirstDataBytePending = true;
                    this.firstPendingDataByte = (byte)10;
                    continue;
                }
                if (this.data0 == 10 && this.data1 != 13 && this.data1 != 10) {
                    this.block[x] = 13;
                    if (++x < 1027) {
                        this.block[x] = 10;
                        if (++x < 1027) {
                            this.block[x] = this.data1;
                            ++x;
                            continue;
                        }
                        this.isFirstDataBytePending = true;
                        this.firstPendingDataByte = this.data1;
                        continue;
                    }
                    this.isFirstDataBytePending = true;
                    this.firstPendingDataByte = (byte)10;
                    this.isSecondDataBytePending = true;
                    this.secondPendingDataByte = this.data1;
                    continue;
                }
                if (this.data0 == 13 && this.data1 != 13 && this.data1 != 10) {
                    this.block[x] = 13;
                    if (++x < 1027) {
                        this.block[x] = 10;
                        if (++x < 1027) {
                            this.block[x] = this.data1;
                            ++x;
                            continue;
                        }
                        this.isFirstDataBytePending = true;
                        this.firstPendingDataByte = this.data1;
                        continue;
                    }
                    this.isFirstDataBytePending = true;
                    this.firstPendingDataByte = (byte)10;
                    this.isSecondDataBytePending = true;
                    this.secondPendingDataByte = this.data1;
                    continue;
                }
                if ((this.data0 != 10 || this.data1 != 10) && (this.data0 != 13 || this.data1 != 13)) continue;
                this.block[x] = 13;
                if (++x < 1027) {
                    this.block[x] = 10;
                    if (++x < 1027) {
                        this.block[x] = 13;
                        if (++x < 1027) {
                            this.block[x] = 10;
                            ++x;
                            continue;
                        }
                        this.isFirstDataBytePending = true;
                        this.firstPendingDataByte = (byte)10;
                        continue;
                    }
                    this.isFirstDataBytePending = true;
                    this.firstPendingDataByte = (byte)13;
                    this.isSecondDataBytePending = true;
                    this.secondPendingDataByte = (byte)10;
                    continue;
                }
                this.isFirstDataBytePending = true;
                this.firstPendingDataByte = (byte)10;
                this.isSecondDataBytePending = true;
                this.secondPendingDataByte = (byte)13;
                this.isThirdDataBytePending = true;
                this.thirdPendingDataByte = (byte)10;
            }
        } else {
            numBytesRead = this.inStream.read(this.block, 3, 1024);
            if (numBytesRead != 1024) {
                if (numBytesRead > 0) {
                    x = numBytesRead + 3;
                    while (x < 1027) {
                        this.block[x] = 26;
                        ++x;
                    }
                } else {
                    this.noMoreData = true;
                    return;
                }
            }
        }
        blockCRCval = this.crcCalculator.getCRC16CCITTValue(this.block, 3, 1026);
        this.block[1027] = (byte)(blockCRCval >>> 8);
        this.block[1028] = (byte)blockCRCval;
    }

    private void processAndWrite(byte[] block, int dataSize) throws IOException {
        this.mark = 3;
        int q = 0;
        int processTillIndex = -1;
        processTillIndex = dataSize == 1024 ? 1025 : 129;
        while (this.mark <= processTillIndex) {
            if (!this.unprocessedByteInReceivedDataExist) {
                if (this.lastCharacterReceivedWasLF) {
                    this.data0 = (byte)10;
                    this.lastCharacterReceivedWasLF = false;
                } else if (this.lastCharacterReceivedWasCR) {
                    this.data0 = (byte)13;
                    this.lastCharacterReceivedWasCR = false;
                } else {
                    this.data0 = block[this.mark];
                    ++this.mark;
                }
                this.data1 = block[this.mark];
                ++this.mark;
            } else {
                this.data0 = this.unprocessedByteInLastReceivedBlock;
                this.unprocessedByteInReceivedDataExist = false;
                this.data1 = block[this.mark];
                ++this.mark;
            }
            if (this.data0 == 13) {
                if (this.data1 == 10) {
                    if (this.osType == 2) {
                        this.tmpReceiveBuffer[q] = 13;
                        this.tmpReceiveBuffer[q + 1] = 10;
                        q += 2;
                        continue;
                    }
                    if (this.osType != 4 && this.osType != 1) continue;
                    this.tmpReceiveBuffer[q] = 10;
                    ++q;
                    continue;
                }
                if (this.data1 == 13) {
                    if (this.osType == 2) {
                        this.tmpReceiveBuffer[q] = 13;
                        this.tmpReceiveBuffer[q + 1] = 10;
                        this.tmpReceiveBuffer[q + 2] = 13;
                        this.tmpReceiveBuffer[q + 3] = 10;
                        q += 4;
                        continue;
                    }
                    if (this.osType != 4 && this.osType != 1) continue;
                    this.tmpReceiveBuffer[q] = 10;
                    this.tmpReceiveBuffer[q + 1] = 10;
                    q += 2;
                    continue;
                }
                if (this.data1 == 26) {
                    if (this.osType == 2) {
                        this.tmpReceiveBuffer[q] = 13;
                        this.tmpReceiveBuffer[q + 1] = 10;
                        q += 2;
                        continue;
                    }
                    if (this.osType != 4 && this.osType != 1) continue;
                    this.tmpReceiveBuffer[q] = 10;
                    ++q;
                    continue;
                }
                if (this.osType == 2) {
                    this.tmpReceiveBuffer[q] = 13;
                    this.tmpReceiveBuffer[q + 1] = 10;
                    this.tmpReceiveBuffer[q + 2] = this.data1;
                    q += 3;
                    continue;
                }
                if (this.osType != 4 && this.osType != 1) continue;
                this.tmpReceiveBuffer[q] = 10;
                this.tmpReceiveBuffer[q + 1] = this.data1;
                q += 2;
                continue;
            }
            if (this.data0 == 10) {
                if (this.data1 == 10) {
                    if (this.osType == 2) {
                        this.tmpReceiveBuffer[q] = 13;
                        this.tmpReceiveBuffer[q + 1] = 10;
                        this.tmpReceiveBuffer[q + 2] = 13;
                        this.tmpReceiveBuffer[q + 3] = 10;
                        q += 4;
                        continue;
                    }
                    if (this.osType != 4 && this.osType != 1) continue;
                    this.tmpReceiveBuffer[q] = 10;
                    this.tmpReceiveBuffer[q + 1] = 10;
                    q += 2;
                    continue;
                }
                if (this.data1 == 13) {
                    if (this.osType == 2) {
                        this.tmpReceiveBuffer[q] = 13;
                        this.tmpReceiveBuffer[q + 1] = 10;
                        q += 2;
                        continue;
                    }
                    if (this.osType != 4 && this.osType != 1) continue;
                    this.tmpReceiveBuffer[q] = 10;
                    ++q;
                    continue;
                }
                if (this.data1 == 26) {
                    if (this.osType == 2) {
                        this.tmpReceiveBuffer[q] = 13;
                        this.tmpReceiveBuffer[q + 1] = 10;
                        q += 2;
                        continue;
                    }
                    if (this.osType != 4 && this.osType != 1) continue;
                    this.tmpReceiveBuffer[q] = 10;
                    ++q;
                    continue;
                }
                if (this.osType == 2) {
                    this.tmpReceiveBuffer[q] = 13;
                    this.tmpReceiveBuffer[q + 1] = 10;
                    this.tmpReceiveBuffer[q + 2] = this.data1;
                    q += 3;
                    continue;
                }
                if (this.osType != 4 && this.osType != 1) continue;
                this.tmpReceiveBuffer[q] = 10;
                this.tmpReceiveBuffer[q + 1] = this.data1;
                q += 2;
                continue;
            }
            if (this.data0 == 26) {
                if (this.data1 == 10) {
                    this.lastCharacterReceivedWasLF = true;
                    continue;
                }
                if (this.data1 == 13) {
                    this.lastCharacterReceivedWasCR = true;
                    continue;
                }
                if (this.data1 == 26) continue;
                this.tmpReceiveBuffer[q] = this.data1;
                ++q;
                continue;
            }
            if (this.data1 == 10) {
                this.tmpReceiveBuffer[q] = this.data0;
                ++q;
                this.lastCharacterReceivedWasLF = true;
                continue;
            }
            if (this.data1 == 13) {
                this.tmpReceiveBuffer[q] = this.data0;
                ++q;
                this.lastCharacterReceivedWasCR = true;
                continue;
            }
            if (this.data1 == 26) {
                this.tmpReceiveBuffer[q] = this.data0;
                ++q;
                continue;
            }
            this.tmpReceiveBuffer[q] = this.data0;
            this.tmpReceiveBuffer[q + 1] = this.data1;
            q += 2;
        }
        this.outStream.write(this.tmpReceiveBuffer, 0, q);
        if (this.mark == 1026 || this.mark == 130) {
            this.unprocessedByteInReceivedDataExist = true;
            this.unprocessedByteInLastReceivedBlock = block[this.mark];
        }
    }

    static /* synthetic */ void access$4(SerialComYModemG serialComYModemG, byte[] byArray) {
        serialComYModemG.block0 = byArray;
    }

    static /* synthetic */ byte[] access$5(SerialComYModemG serialComYModemG) {
        return serialComYModemG.block;
    }

    static /* synthetic */ byte[] access$6(SerialComYModemG serialComYModemG) {
        return serialComYModemG.block0;
    }

    static /* synthetic */ void access$7(SerialComYModemG serialComYModemG, long l) {
        serialComYModemG.numberOfBlocksReceived = l;
    }

    static /* synthetic */ int access$8(SerialComYModemG serialComYModemG) {
        return serialComYModemG.blockNumber;
    }

    static /* synthetic */ SerialComCRCUtil access$9(SerialComYModemG serialComYModemG) {
        return serialComYModemG.crcCalculator;
    }

    static /* synthetic */ void access$10(SerialComYModemG serialComYModemG, int n) {
        serialComYModemG.blockNumber = n;
    }

    static /* synthetic */ boolean access$11(SerialComYModemG serialComYModemG) {
        return serialComYModemG.textMode;
    }

    static /* synthetic */ void access$12(SerialComYModemG serialComYModemG, byte[] byArray, int n) throws IOException {
        serialComYModemG.processAndWrite(byArray, n);
    }

    static /* synthetic */ BufferedOutputStream access$13(SerialComYModemG serialComYModemG) {
        return serialComYModemG.outStream;
    }

    static /* synthetic */ ISerialComYmodemProgress access$14(SerialComYModemG serialComYModemG) {
        return serialComYModemG.progressListener;
    }

    static /* synthetic */ long access$15(SerialComYModemG serialComYModemG) {
        return serialComYModemG.numberOfBlocksReceived;
    }

    static /* synthetic */ void access$16(SerialComYModemG serialComYModemG, BufferedOutputStream bufferedOutputStream) {
        serialComYModemG.outStream = bufferedOutputStream;
    }

    private class DataCollector
    implements Callable<Object> {
        private DataProcessor dataProcessor;
        private final RingArrayBlockingQueue<byte[]> dataQueue;
        private volatile boolean exitThread = false;

        public DataCollector(RingArrayBlockingQueue<byte[]> dataQueue) {
            this.dataQueue = dataQueue;
        }

        @Override
        public Object call() throws Exception {
            byte[] data = null;
            while (!this.exitThread) {
                try {
                    data = SerialComYModemG.this.scm.readBytes(SerialComYModemG.this.handle, 1029);
                }
                catch (Exception e) {
                    this.dataProcessor.triggerExit();
                    throw e;
                }
                if (data != null && data.length > 0) {
                    try {
                        this.dataQueue.offer((Object)data);
                    }
                    catch (Exception e) {
                        this.dataProcessor.triggerExit();
                        if (this.exitThread) {
                            return null;
                        }
                        throw e;
                    }
                }
                try {
                    if (SerialComYModemG.this.osType != 1 && SerialComYModemG.this.osType != 4) continue;
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    if (!this.exitThread) continue;
                    this.dataProcessor.triggerExit();
                    return null;
                }
            }
            return null;
        }

        public void triggerExit() {
            this.exitThread = true;
            Thread.currentThread().interrupt();
        }

        public void setDataProcessorRef(DataProcessor dataProcessor) {
            this.dataProcessor = dataProcessor;
        }
    }

    private class DataProcessor
    implements Callable<Object> {
        private DataCollector dataCollector;
        private final RingArrayBlockingQueue<byte[]> dataQueue;
        private final String receiverDirAbsolutePath;
        private volatile boolean exitThread;

        public DataProcessor(RingArrayBlockingQueue<byte[]> dataQueue) {
            this.receiverDirAbsolutePath = SerialComYModemG.this.filesToReceive.getAbsolutePath();
            this.exitThread = false;
            this.dataQueue = dataQueue;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Object call() throws Exception {
            CONNECT = true;
            BLOCK0RCV = 2;
            BEGINRCV = 3;
            DATABLOCKRCV = 4;
            VERIFY = 5;
            DUMPDATA = 6;
            ABORT = 7;
            i = 0;
            x = 0;
            crcl = 0;
            state = 0;
            block0index = 0;
            dataBlockIndex = 0;
            blockCRCval = 0;
            receivingBlock0 = true;
            receivingDataBlock = false;
            spaceLeftInBlock0 = 0;
            spaceLeftInDataBlock = 0;
            localData = null;
            datablock = null;
            block133 = new byte[133];
            nameOfFileBeingReceived = null;
            isFileOpen = false;
            percentOfBlocksReceived = 0;
            currentlyProcessingFileLength = 0L;
            currentlyProcessingFileModifyInfo = 0L;
            currentlyProcessingFileMode = 0L;
            totalNumberOfDataBytesReadTillNow = 0L;
            expt = null;
            totalBytesRcvWhileRcvBlock0 = 0;
            extraDataIdx = 0;
            extraData = null;
            state = 1;
            block35: while (!this.exitThread) {
                block11 : switch (state) {
                    case 1: {
                        try {
                            SerialComYModemG.access$0(SerialComYModemG.this).writeSingleByte(SerialComYModemG.access$1(SerialComYModemG.this), (byte)71);
                        }
                        catch (Exception e) {
                            expt = e;
                            state = 7;
                            break;
                        }
                        while (true) {
                            try {
                                localData = (byte[])this.dataQueue.poll(1L, TimeUnit.MINUTES);
                                if (localData == null) {
                                    expt = new SerialComTimeOutException("Timedout while trying to connect to file sender !");
                                    state = 7;
                                    break block11;
                                }
                                state = 2;
                                break block11;
                            }
                            catch (InterruptedException e) {
                                if (!this.exitThread) continue;
                                return null;
                            }
                            catch (Exception e) {
                                expt = e;
                                state = 7;
                                break block11;
                            }
                            break;
                        }
                    }
                    case 2: {
                        totalBytesRcvWhileRcvBlock0 += localData.length;
                        if (localData[0] == true) {
                            SerialComYModemG.access$4(SerialComYModemG.this, block133);
                            spaceLeftInBlock0 = 133;
                            crcl = 131;
                        } else if (localData[0] == 2) {
                            SerialComYModemG.access$4(SerialComYModemG.this, SerialComYModemG.access$5(SerialComYModemG.this));
                            spaceLeftInBlock0 = 1029;
                            crcl = 1027;
                        } else {
                            expt = new SerialComException("Invalid character received !");
                            state = 7;
                            break;
                        }
                        while (true) {
                            if (localData.length < spaceLeftInBlock0) {
                                x = 0;
                                while (x < localData.length) {
                                    SerialComYModemG.access$6((SerialComYModemG)SerialComYModemG.this)[block0index] = localData[x];
                                    ++block0index;
                                    --spaceLeftInBlock0;
                                    ++x;
                                }
                            } else if (localData.length == spaceLeftInBlock0) {
                                x = 0;
                                while (x < localData.length) {
                                    SerialComYModemG.access$6((SerialComYModemG)SerialComYModemG.this)[block0index] = localData[x];
                                    ++block0index;
                                    --spaceLeftInBlock0;
                                    ++x;
                                }
                            } else {
                                i = spaceLeftInBlock0;
                                x = 0;
                                while (x < i) {
                                    SerialComYModemG.access$6((SerialComYModemG)SerialComYModemG.this)[block0index] = localData[x];
                                    ++block0index;
                                    --spaceLeftInBlock0;
                                    ++x;
                                }
                            }
                            if (spaceLeftInBlock0 <= 0) break;
                            try {
                                localData = (byte[])this.dataQueue.poll(2L, TimeUnit.SECONDS);
                                if (localData == null) {
                                    expt = new SerialComTimeOutException("Timedout while trying to receive block 0 from file sender !");
                                    state = 7;
                                }
                                ** GOTO lbl120
                            }
                            catch (InterruptedException e) {
                                if (this.exitThread) {
                                    state = 7;
                                }
                                ** GOTO lbl120
                            }
                            catch (Exception e) {
                                expt = e;
                                state = 7;
                            }
                            break;
lbl120:
                            // 2 sources

                            totalBytesRcvWhileRcvBlock0 += localData.length;
                        }
                        receivingBlock0 = true;
                        receivingDataBlock = false;
                        block0index = 0;
                        totalNumberOfDataBytesReadTillNow = 0L;
                        state = 5;
                        break;
                    }
                    case 3: {
                        try {
                            SerialComYModemG.access$0(SerialComYModemG.this).writeSingleByte(SerialComYModemG.access$1(SerialComYModemG.this), (byte)71);
                            receivingBlock0 = false;
                            receivingDataBlock = true;
                            datablock = null;
                            dataBlockIndex = 0;
                            state = 4;
                        }
                        catch (Exception e) {
                            expt = e;
                            state = 7;
                        }
                        continue block35;
                    }
                    case 4: {
                        if (extraData != null) {
                            if (extraData[extraDataIdx] == true) {
                                datablock = block133;
                                spaceLeftInDataBlock = 133;
                                crcl = 131;
                            } else if (extraData[extraDataIdx] == 2) {
                                datablock = SerialComYModemG.access$5(SerialComYModemG.this);
                                spaceLeftInDataBlock = 1029;
                                crcl = 1027;
                            } else {
                                expt = new SerialComException("Invalid character received !");
                                state = 7;
                                break;
                            }
                            if (spaceLeftInDataBlock > extraData.length - extraDataIdx) {
                                dataBlockIndex = 0;
                                x = 0;
                                while (x < extraData.length - extraDataIdx) {
                                    datablock[dataBlockIndex] = extraData[extraDataIdx];
                                    ++dataBlockIndex;
                                    ++extraDataIdx;
                                    --spaceLeftInDataBlock;
                                    ++x;
                                }
                                extraData = null;
                                extraDataIdx = 0;
                                break;
                            }
                            if (spaceLeftInDataBlock < extraData.length - extraDataIdx) {
                                x = 0;
                                while (x < spaceLeftInDataBlock) {
                                    datablock[x] = extraData[extraDataIdx];
                                    ++extraDataIdx;
                                    ++x;
                                }
                                receivingDataBlock = true;
                                state = 5;
                                break;
                            }
                            x = 0;
                            while (x < extraData.length - extraDataIdx) {
                                datablock[x] = extraData[extraDataIdx];
                                ++extraDataIdx;
                                --spaceLeftInDataBlock;
                                ++x;
                            }
                            extraData = null;
                            extraDataIdx = 0;
                            receivingDataBlock = true;
                            state = 5;
                            break;
                        }
                        try {
                            localData = (byte[])this.dataQueue.take();
                        }
                        catch (InterruptedException e) {
                            if (this.exitThread) {
                                state = 7;
                                break;
                            }
                        }
                        catch (Exception e) {
                            expt = e;
                            state = 7;
                            break;
                        }
                        if (datablock == null) {
                            if (localData[0] == 1) {
                                datablock = block133;
                                spaceLeftInDataBlock = 133;
                                crcl = 131;
                            } else if (localData[0] == 2) {
                                datablock = SerialComYModemG.access$5(SerialComYModemG.this);
                                spaceLeftInDataBlock = 1029;
                                crcl = 1027;
                            } else {
                                if (localData[0] == 4) {
                                    try {
                                        SerialComYModemG.access$0(SerialComYModemG.this).writeSingleByte(SerialComYModemG.access$1(SerialComYModemG.this), (byte)6);
                                        receivingBlock0 = true;
                                        receivingDataBlock = false;
                                        datablock = null;
                                        dataBlockIndex = 0;
                                        SerialComYModemG.access$7(SerialComYModemG.this, 0L);
                                        totalNumberOfDataBytesReadTillNow = 0L;
                                        state = 1;
                                    }
                                    catch (Exception e) {
                                        expt = e;
                                        state = 7;
                                    }
                                    continue block35;
                                }
                                expt = new SerialComException("Invalid character received !");
                                state = 7;
                                break;
                            }
                            dataBlockIndex = 0;
                        }
                        if (state != 4) break;
                        while (true) {
                            if (spaceLeftInDataBlock > localData.length) {
                                x = 0;
                                while (x < localData.length) {
                                    datablock[dataBlockIndex] = localData[x];
                                    ++dataBlockIndex;
                                    --spaceLeftInDataBlock;
                                    ++x;
                                }
                            } else {
                                if (spaceLeftInDataBlock < localData.length) {
                                    x = 0;
                                    while (x < spaceLeftInDataBlock) {
                                        datablock[dataBlockIndex] = localData[x];
                                        ++dataBlockIndex;
                                        ++x;
                                    }
                                    extraData = localData;
                                    extraDataIdx = x;
                                    state = 5;
                                    break block11;
                                }
                                x = 0;
                                while (x < localData.length) {
                                    datablock[dataBlockIndex] = localData[x];
                                    ++dataBlockIndex;
                                    ++x;
                                }
                                state = 5;
                                break block11;
                            }
                            try {
                                localData = (byte[])this.dataQueue.take();
                                continue;
                            }
                            catch (InterruptedException e) {
                                if (this.exitThread) ** break;
                                continue;
                                state = 7;
                                break block11;
                            }
                            catch (Exception e) {
                                expt = e;
                                state = 7;
                                break block11;
                            }
                            break;
                        }
                    }
                    case 5: {
                        if (receivingDataBlock) {
                            if (datablock[1] == false) {
                                expt = new SerialComException("Invalid block number received (block[1]=0) !");
                                state = 7;
                                break;
                            }
                            if (datablock[1] == (byte)(SerialComYModemG.access$8(SerialComYModemG.this) - 1 & 255)) {
                                state = 4;
                                break;
                            }
                            if (datablock[1] != (byte)SerialComYModemG.access$8(SerialComYModemG.this) || datablock[2] != (byte)(~SerialComYModemG.access$8(SerialComYModemG.this))) {
                                expt = new SerialComException("Invalid block number sequence received !");
                                state = 7;
                                break;
                            }
                            blockCRCval = SerialComYModemG.access$9(SerialComYModemG.this).getCRC16CCITTValue(datablock, 3, crcl - 1);
                            if (datablock[crcl] != (byte)(blockCRCval >>> 8) || datablock[crcl + 1] != (byte)blockCRCval) {
                                expt = new SerialComException("Invalid CRC (corrupted data block received) !");
                                state = 7;
                                break;
                            }
                            state = 6;
                            break;
                        }
                        if (!receivingBlock0) break;
                        if (SerialComYModemG.access$6(SerialComYModemG.this)[1] != 0 || SerialComYModemG.access$6(SerialComYModemG.this)[2] != -1) {
                            expt = new SerialComException("Invalid block number received !");
                            state = 7;
                            break;
                        }
                        blockCRCval = SerialComYModemG.access$9(SerialComYModemG.this).getCRC16CCITTValue(SerialComYModemG.access$6(SerialComYModemG.this), 3, crcl - 1);
                        if (SerialComYModemG.access$6(SerialComYModemG.this)[crcl] != (byte)(blockCRCval >>> 8) || SerialComYModemG.access$6(SerialComYModemG.this)[crcl + 1] != (byte)blockCRCval) {
                            expt = new SerialComException("Invalid CRC (corrupted block 0 or final block received) !");
                            state = 7;
                            break;
                        }
                        if (SerialComYModemG.access$6(SerialComYModemG.this)[crcl] == 0 && SerialComYModemG.access$6(SerialComYModemG.this)[crcl + 1] == 0) {
                            i = 3;
                            while (i < SerialComYModemG.access$6(SerialComYModemG.this).length) {
                                if (SerialComYModemG.access$6(SerialComYModemG.this)[i] != 0) break;
                                ++i;
                            }
                            if (i >= SerialComYModemG.access$6(SerialComYModemG.this).length) {
                                this.dataCollector.triggerExit();
                                return null;
                            }
                        }
                        SerialComYModemG.access$10(SerialComYModemG.this, 1);
                        state = 6;
                        break;
                    }
                    case 6: {
                        if (receivingDataBlock) {
                            totalNumberOfDataBytesReadTillNow += (long)(crcl - 3);
                            try {
                                if (SerialComYModemG.access$11(SerialComYModemG.this)) {
                                    SerialComYModemG.access$12(SerialComYModemG.this, datablock, crcl - 3);
                                } else if (currentlyProcessingFileLength != 0L) {
                                    if (totalNumberOfDataBytesReadTillNow <= currentlyProcessingFileLength) {
                                        SerialComYModemG.access$13(SerialComYModemG.this).write(datablock, 3, crcl - 3);
                                    } else {
                                        SerialComYModemG.access$13(SerialComYModemG.this).write(datablock, 3, (int)((long)(crcl - 3) - (totalNumberOfDataBytesReadTillNow - currentlyProcessingFileLength)));
                                    }
                                } else {
                                    SerialComYModemG.access$13(SerialComYModemG.this).write(datablock, 3, crcl - 3);
                                }
                            }
                            catch (Exception e) {
                                expt = e;
                                state = 7;
                                break;
                            }
                            if (SerialComYModemG.access$14(SerialComYModemG.this) != null) {
                                v0 = SerialComYModemG.this;
                                SerialComYModemG.access$7(v0, SerialComYModemG.access$15(v0) + 1L);
                                percentOfBlocksReceived = currentlyProcessingFileLength > 0L ? (int)((long)(crcl - 3) * SerialComYModemG.access$15(SerialComYModemG.this) * 100L / currentlyProcessingFileLength) : 100;
                                if (percentOfBlocksReceived >= 100) {
                                    percentOfBlocksReceived = 100;
                                }
                                SerialComYModemG.access$14(SerialComYModemG.this).onYmodemReceiveProgressUpdate(nameOfFileBeingReceived, SerialComYModemG.access$15(SerialComYModemG.this), percentOfBlocksReceived);
                            }
                            v1 = SerialComYModemG.this;
                            SerialComYModemG.access$10(v1, SerialComYModemG.access$8(v1) + 1);
                            if (SerialComYModemG.access$8(SerialComYModemG.this) > 255) {
                                SerialComYModemG.access$10(SerialComYModemG.this, 0);
                            }
                            datablock = null;
                            state = 4;
                            break;
                        }
                        if (!receivingBlock0) break;
                        x = 3;
                        while (x < SerialComYModemG.access$6(SerialComYModemG.this).length) {
                            if (SerialComYModemG.access$6(SerialComYModemG.this)[x] == 0) break;
                            ++x;
                        }
                        nameOfFileBeingReceived = new String(SerialComYModemG.access$6(SerialComYModemG.this), 3, x - 3);
                        if (nameOfFileBeingReceived == null || nameOfFileBeingReceived.length() == 0) {
                            expt = new SerialComException("Sender did not sent file name !");
                            state = 7;
                            break;
                        }
                        namefile = new File(this.receiverDirAbsolutePath, nameOfFileBeingReceived);
                        if (!namefile.exists()) {
                            try {
                                namefile.createNewFile();
                            }
                            catch (Exception e) {
                                expt = e;
                                state = 7;
                                break;
                            }
                        }
                        try {
                            SerialComYModemG.access$16(SerialComYModemG.this, new BufferedOutputStream(new FileOutputStream(namefile)));
                        }
                        catch (FileNotFoundException e) {
                            expt = e;
                            state = 7;
                            break;
                        }
                        isFileOpen = true;
                        i = ++x;
                        while (i < SerialComYModemG.access$6(SerialComYModemG.this).length) {
                            if (SerialComYModemG.access$6(SerialComYModemG.this)[i] == 32) break;
                            ++i;
                        }
                        currentlyProcessingFileLength = Long.valueOf(new String(SerialComYModemG.access$6(SerialComYModemG.this), x, i - x));
                        x = ++i;
                        while (x < SerialComYModemG.access$6(SerialComYModemG.this).length) {
                            if (SerialComYModemG.access$6(SerialComYModemG.this)[x] == 32) break;
                            ++x;
                        }
                        currentlyProcessingFileModifyInfo = Long.valueOf(new String(SerialComYModemG.access$6(SerialComYModemG.this), i, x - i), 8);
                        if (currentlyProcessingFileModifyInfo != 0L) {
                            namefile.setLastModified(currentlyProcessingFileModifyInfo);
                        }
                        i = ++x;
                        while (i < SerialComYModemG.access$6(SerialComYModemG.this).length) {
                            if (SerialComYModemG.access$6(SerialComYModemG.this)[i] == 32) break;
                            ++i;
                        }
                        currentlyProcessingFileMode = Long.valueOf(new String(SerialComYModemG.access$6(SerialComYModemG.this), x, i - x), 8);
                        try {
                            SerialComYModemG.access$0(SerialComYModemG.this).writeSingleByte(SerialComYModemG.access$1(SerialComYModemG.this), (byte)71);
                            receivingBlock0 = false;
                            receivingDataBlock = true;
                            datablock = null;
                            dataBlockIndex = 0;
                            state = 4;
                        }
                        catch (Exception e) {
                            expt = e;
                            state = 7;
                        }
                        continue block35;
                    }
                    case 7: {
                        this.dataCollector.triggerExit();
                        if (isFileOpen) {
                            SerialComYModemG.access$13(SerialComYModemG.this).flush();
                            SerialComYModemG.access$13(SerialComYModemG.this).close();
                            isFileOpen = false;
                        }
                        if (expt != null) {
                            throw expt;
                        }
                        return null;
                    }
                }
            }
            return null;
        }

        public void triggerExit() {
            this.exitThread = true;
            Thread.currentThread().interrupt();
        }

        public void setDataCollectorRef(DataCollector dataCollector) {
            this.dataCollector = dataCollector;
        }
    }
}

