/*
 * Decompiled with CFR 0.152.
 */
package com.serialpundit.serial.internal;

import com.serialpundit.core.SerialComException;
import com.serialpundit.core.SerialComSystemProperty;
import com.serialpundit.serial.internal.SerialComPortJNIBridge;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class SerialComCP210xManufacturingJNIBridge {
    public static boolean loadNativeLibrary(File libDirectory, String vlibName, int cpuArch, int osType, SerialComSystemProperty serialComSystemProperty) throws SerialComException {
        String fileSeparator;
        File libFile;
        block39: {
            String libToExtractFromJar = null;
            libFile = null;
            InputStream input = null;
            FileOutputStream output = null;
            fileSeparator = null;
            fileSeparator = serialComSystemProperty.getfileSeparator();
            if (fileSeparator == null || fileSeparator.length() == 0) {
                throw new SerialComException("The file.separator java system property is either null or empty !");
            }
            if (cpuArch == 2) {
                switch (osType) {
                    case 2: {
                        libToExtractFromJar = "spcp210xmwinx64.dll";
                        break;
                    }
                    case 1: {
                        libToExtractFromJar = "spcp210xmlnxx64.so";
                        break;
                    }
                    case 4: {
                        libToExtractFromJar = "spcp210xmmacx64.dylib";
                    }
                }
            } else if (cpuArch == 1) {
                switch (osType) {
                    case 2: {
                        libToExtractFromJar = "spcp210xmwinx86.dll";
                        break;
                    }
                    case 1: {
                        libToExtractFromJar = "spcp210xmlnxx86.so";
                        break;
                    }
                    case 4: {
                        libToExtractFromJar = "spcp210xmmacx86.dylib";
                    }
                }
            } else {
                throw new SerialComException("This architecture is unknown to this library. Please contact us !");
            }
            try {
                try {
                    libFile = new File(String.valueOf(libDirectory.getAbsolutePath()) + fileSeparator + libToExtractFromJar);
                    input = SerialComPortJNIBridge.class.getResourceAsStream("/" + libToExtractFromJar);
                    output = new FileOutputStream(libFile);
                    if (input != null) {
                        int read;
                        byte[] buffer = new byte[4096];
                        while ((read = input.read(buffer)) != -1) {
                            output.write(buffer, 0, read);
                        }
                        output.flush();
                        output.close();
                        output = null;
                        if (libFile == null || !libFile.exists() || !libFile.isFile()) {
                            throw new SerialComException("Can not extract native shared library " + libToExtractFromJar + " from sp-tty.jar file !");
                        }
                        break block39;
                    }
                    throw new SerialComException("Can not get shared library " + libToExtractFromJar + " resource as stream from sp-tty.jar file !");
                }
                catch (Exception e) {
                    throw (SerialComException)new SerialComException(libFile.toString()).initCause((Throwable)e);
                }
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        final File vlibFileFinal = new File(String.valueOf(libDirectory.getAbsolutePath()) + fileSeparator + vlibName);
        final File libFileFinal = libFile;
        try {
            AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    System.load(vlibFileFinal.toString());
                    return true;
                }
            });
        }
        catch (Exception e) {
            throw (SerialComException)new SerialComException("Could not load " + vlibFileFinal.toString() + " native library !").initCause((Throwable)e);
        }
        catch (UnsatisfiedLinkError e) {
            throw (SerialComException)new SerialComException(e.getMessage()).initCause((Throwable)e);
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    System.load(libFileFinal.toString());
                    return true;
                }
            });
        }
        catch (Exception e) {
            throw (SerialComException)new SerialComException("Could not load " + libFileFinal.toString() + " native library !").initCause((Throwable)e);
        }
        catch (UnsatisfiedLinkError e) {
            throw (SerialComException)new SerialComException(e.getMessage()).initCause((Throwable)e);
        }
        return true;
    }

    public native int getNumDevices();

    public native int reset(long var1);

    public native int createHexFile(long var1, String var3);

    public native String getPartNumber(long var1);

    public native String getDeviceManufacturerString(long var1);

    public native long open(int var1);

    public native int close(long var1);

    public native int setProductString(long var1, String var3);

    public native String getProductString(int var1, int var2);

    public native String getDeviceProductString(long var1);

    public native int setVid(long var1, int var3);

    public native int getDeviceVid(long var1);

    public native int setPid(long var1, int var3);

    public native int getDevicePid(long var1);

    public native int setSerialNumber(long var1, String var3);

    public native String getDeviceSerialNumber(long var1);

    public native int setInterfaceString(long var1, byte var3, String var4);

    public native String getDeviceInterfaceString(long var1, byte var3);

    public native int setSelfPower(long var1, boolean var3);

    public native int getSelfPower(long var1);

    public native int setMaxPower(long var1, byte var3);

    public native int getMaxPower(long var1);

    public native int setFlushBufferConfig(long var1, int var3);

    public native int getFlushBufferConfig(long var1);

    public native int setDeviceMode(long var1, byte var3, byte var4);

    public native byte[] getDeviceMode(long var1);

    public native int setDeviceVersion(long var1, int var3);

    public native int getDeviceVersion(long var1);

    public native int setBaudRateConfig(long var1, int var3, int var4, int var5, int var6);

    public native int[] getBaudRateConfig(long var1);

    public native int setPortConfig(long var1, int var3, int var4, int var5, int var6);

    public native int[] getPortConfig(long var1);

    public native int setDualPortConfig(long var1, int var3, int var4, int var5, int var6, int var7, int var8);

    public native int[] getDualPortConfig(long var1);

    public native int setQuadPortConfig(long var1, int[] var3, int[] var4, byte[] var5);

    public native int[] getQuadPortConfig(long var1);

    public native int setLockValue(long var1);

    public native int getLockValue(long var1);
}

