/*
 * Decompiled with CFR 0.152.
 */
package com.serialpundit.serial.internal;

import com.serialpundit.core.SerialComException;
import com.serialpundit.core.SerialComSystemProperty;
import com.serialpundit.serial.internal.SerialComPortJNIBridge;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class SerialComCP210xRuntimeJNIBridge {
    public static boolean loadNativeLibrary(File libDirectory, String vlibName, int cpuArch, int osType, SerialComSystemProperty serialComSystemProperty) throws SerialComException {
        String fileSeparator;
        File libFile;
        block39: {
            String libToExtractFromJar = null;
            libFile = null;
            InputStream input = null;
            FileOutputStream output = null;
            fileSeparator = null;
            fileSeparator = serialComSystemProperty.getfileSeparator();
            if (fileSeparator == null || fileSeparator.length() == 0) {
                throw new SerialComException("The file.separator java system property is either null or empty !");
            }
            if (cpuArch == 2) {
                switch (osType) {
                    case 2: {
                        libToExtractFromJar = "spcp210xrwinx64.dll";
                        break;
                    }
                    case 1: {
                        libToExtractFromJar = "spcp210xrlnxx64.so";
                        break;
                    }
                    case 4: {
                        libToExtractFromJar = "spcp210xrmacx64.dylib";
                    }
                }
            } else if (cpuArch == 1) {
                switch (osType) {
                    case 2: {
                        libToExtractFromJar = "spcp210xrwinx86.dll";
                        break;
                    }
                    case 1: {
                        libToExtractFromJar = "spcp210xrlnxx86.so";
                        break;
                    }
                    case 4: {
                        libToExtractFromJar = "spcp210xrmacx86.dylib";
                    }
                }
            } else {
                throw new SerialComException("This architecture is unknown to this library. Please contact us !");
            }
            try {
                try {
                    libFile = new File(String.valueOf(libDirectory.getAbsolutePath()) + fileSeparator + libToExtractFromJar);
                    input = SerialComPortJNIBridge.class.getResourceAsStream("/" + libToExtractFromJar);
                    output = new FileOutputStream(libFile);
                    if (input != null) {
                        int read;
                        byte[] buffer = new byte[4096];
                        while ((read = input.read(buffer)) != -1) {
                            output.write(buffer, 0, read);
                        }
                        output.flush();
                        output.close();
                        output = null;
                        if (libFile == null || !libFile.exists() || !libFile.isFile()) {
                            throw new SerialComException("Can not extract native shared library " + libToExtractFromJar + " from sp-tty.jar file !");
                        }
                        break block39;
                    }
                    throw new SerialComException("Can not get shared library " + libToExtractFromJar + " resource as stream from sp-tty.jar file !");
                }
                catch (Exception e) {
                    throw (SerialComException)new SerialComException(libFile.toString()).initCause((Throwable)e);
                }
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        final File vlibFileFinal = new File(String.valueOf(libDirectory.getAbsolutePath()) + fileSeparator + vlibName);
        final File libFileFinal = libFile;
        try {
            AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    System.load(vlibFileFinal.toString());
                    return true;
                }
            });
        }
        catch (Exception e) {
            throw (SerialComException)new SerialComException("Could not load " + vlibFileFinal.toString() + " native library !").initCause((Throwable)e);
        }
        catch (UnsatisfiedLinkError e) {
            throw (SerialComException)new SerialComException(e.getMessage()).initCause((Throwable)e);
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    System.load(libFileFinal.toString());
                    return true;
                }
            });
        }
        catch (Exception e) {
            throw (SerialComException)new SerialComException("Could not load " + libFileFinal.toString() + " native library !").initCause((Throwable)e);
        }
        catch (UnsatisfiedLinkError e) {
            throw (SerialComException)new SerialComException(e.getMessage()).initCause((Throwable)e);
        }
        return true;
    }

    public native int readLatch(long var1);

    public native int writeLatch(long var1, long var3, long var5);

    public native String getPartNumber(long var1);

    public native String getDeviceProductString(long var1);

    public native String getDeviceSerialNumber(long var1);

    public native String getDeviceInterfaceString(long var1);
}

