/*
 * Decompiled with CFR 0.152.
 */
package com.serialpundit.serial.internal;

import com.serialpundit.core.SerialComException;
import com.serialpundit.core.SerialComSystemProperty;
import com.serialpundit.serial.internal.SerialComPortJNIBridge;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class SerialComMCHPSIOJNIBridge {
    public static boolean loadNativeLibrary(File libDirectory, String vlibName, int cpuArch, int osType, SerialComSystemProperty serialComSystemProperty) throws SerialComException {
        String fileSeparator;
        File libFile;
        block39: {
            String libToExtractFromJar = null;
            libFile = null;
            InputStream input = null;
            FileOutputStream output = null;
            fileSeparator = null;
            fileSeparator = serialComSystemProperty.getfileSeparator();
            if (fileSeparator == null || fileSeparator.length() == 0) {
                throw new SerialComException("The file.separator java system property is either null or empty !");
            }
            if (cpuArch == 2) {
                switch (osType) {
                    case 2: {
                        libToExtractFromJar = "spmchpsiowinx64.dll";
                        break;
                    }
                    case 1: {
                        libToExtractFromJar = "spmchpsiolnxx64.so";
                        break;
                    }
                    case 4: {
                        libToExtractFromJar = "spmchpsiomacx64.dylib";
                    }
                }
            } else if (cpuArch == 1) {
                switch (osType) {
                    case 2: {
                        libToExtractFromJar = "spmchpsiowinx86.dll";
                        break;
                    }
                    case 1: {
                        libToExtractFromJar = "spmchpsiolnxx86.so";
                        break;
                    }
                    case 4: {
                        libToExtractFromJar = "spmchpsiomacx86.dylib";
                    }
                }
            } else {
                throw new SerialComException("This architecture is unknown to this library. Please contact us !");
            }
            try {
                try {
                    libFile = new File(String.valueOf(libDirectory.getAbsolutePath()) + fileSeparator + libToExtractFromJar);
                    input = SerialComPortJNIBridge.class.getResourceAsStream("/" + libToExtractFromJar);
                    output = new FileOutputStream(libFile);
                    if (input != null) {
                        int read;
                        byte[] buffer = new byte[4096];
                        while ((read = input.read(buffer)) != -1) {
                            output.write(buffer, 0, read);
                        }
                        output.flush();
                        output.close();
                        output = null;
                        if (libFile == null || !libFile.exists() || !libFile.isFile()) {
                            throw new SerialComException("Can not extract native shared library " + libToExtractFromJar + " from sp-tty.jar file !");
                        }
                        break block39;
                    }
                    throw new SerialComException("Can not get shared library " + libToExtractFromJar + " resource as stream from sp-tty.jar file !");
                }
                catch (Exception e) {
                    throw (SerialComException)new SerialComException(libFile.toString()).initCause((Throwable)e);
                }
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        final File vlibFileFinal = new File(String.valueOf(libDirectory.getAbsolutePath()) + fileSeparator + vlibName);
        final File libFileFinal = libFile;
        try {
            AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    SerialComMCHPSIOJNIBridge.loadAndLinkSimpleIODLL(vlibFileFinal.toString());
                    return true;
                }
            });
        }
        catch (Exception e) {
            throw (SerialComException)new SerialComException("Could not load " + vlibFileFinal.toString() + " native library !").initCause((Throwable)e);
        }
        catch (UnsatisfiedLinkError e) {
            throw (SerialComException)new SerialComException(e.getMessage()).initCause((Throwable)e);
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    System.load(libFileFinal.toString());
                    return true;
                }
            });
        }
        catch (Exception e) {
            throw (SerialComException)new SerialComException("Could not load " + libFileFinal.toString() + " native library !").initCause((Throwable)e);
        }
        catch (UnsatisfiedLinkError e) {
            throw (SerialComException)new SerialComException(e.getMessage()).initCause((Throwable)e);
        }
        return true;
    }

    private static native int loadAndLinkSimpleIODLL(String var0);

    public native int initMCP2200(int var1, int var2);

    public native int isConnected();

    public native int configureMCP2200(byte var1, long var2, int var4, int var5, boolean var6, boolean var7, boolean var8, boolean var9);

    public native int setPin(int var1);

    public native int clearPin(int var1);

    public native int readPinValue(int var1);

    public native int readPin(int var1);

    public native int writePort(int var1);

    public native int readPort();

    public native int readPortValue();

    public native int selectDevice(int var1);

    public native int getSelectedDevice();

    public native int getNumOfDevices();

    public native String getDeviceInfo(int var1);

    public native String getSelectedDeviceInfo();

    public native int readEEPROM(int var1);

    public native int writeEEPROM(int var1, short var2);

    public native int fnRxLED(int var1);

    public native int fnTxLED(int var1);

    public native int hardwareFlowControl(int var1);

    public native int fnULoad(int var1);

    public native int fnSuspend(int var1);

    public native int fnInvertUartPol(int var1);

    public native int fnSetBaudRate(long var1);

    public native int configureIO(short var1);

    public native int configureIoDefaultOutput(short var1, short var2);
}

