/*
 * Decompiled with CFR 0.152.
 */
package com.serialpundit.usb;

import com.serialpundit.core.SerialComException;
import com.serialpundit.core.SerialComPlatform;
import com.serialpundit.core.SerialComSystemProperty;
import com.serialpundit.usb.ISerialComUSBHotPlugListener;
import com.serialpundit.usb.SerialComUSBHID;
import com.serialpundit.usb.SerialComUSBPowerInfo;
import com.serialpundit.usb.SerialComUSBdevice;
import com.serialpundit.usb.internal.SerialComUSBJNIBridge;
import java.io.IOException;

public final class SerialComUSB {
    public static final int V_ALL = 0;
    public static final int V_FTDI = 1027;
    public static final int V_SLABS = 4292;
    public static final int V_MCHIP = 1240;
    public static final int V_PL = 1659;
    public static final int V_EXAR = 1250;
    public static final int V_ATML = 1003;
    public static final int V_MOSCHP = 38672;
    public static final int V_CYPRS = 1204;
    public static final int V_TI = 1105;
    public static final int V_WCH = 17224;
    public static final int V_QHE = 6790;
    public static final int V_NXP = 8137;
    public static final int V_RNSAS = 1033;
    public static final int DEV_ANY = 0;
    public static final int DEV_ADDED = 1;
    public static final int DEV_REMOVED = 2;
    private SerialComPlatform mSerialComPlatform;
    private final SerialComSystemProperty mSerialComSystemProperty;
    private final Object lockB = new Object();
    private static int osType = 0;
    private static int cpuArch = 0;
    private static int abiType = 0;
    private static final Object lockA = new Object();
    private static SerialComUSBJNIBridge mUSBJNIBridge;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerialComUSB(String libDirectory, String loadedLibName) throws IOException {
        this.mSerialComSystemProperty = new SerialComSystemProperty();
        Object object = lockA;
        synchronized (object) {
            if (osType <= 0) {
                this.mSerialComPlatform = new SerialComPlatform(this.mSerialComSystemProperty);
                osType = this.mSerialComPlatform.getOSType();
                if (osType == 0) {
                    throw new SerialComException("Could not identify operating system. Please report to us your environemnt so that we can add support for it !");
                }
                cpuArch = this.mSerialComPlatform.getCPUArch(osType);
                if (cpuArch == 0) {
                    throw new SerialComException("Could not identify CPU architecture. Please report to us your environemnt so that we can add support for it !");
                }
                if ((cpuArch == 15 || cpuArch == 14 || cpuArch == 13) && osType == 1) {
                    abiType = this.mSerialComPlatform.getABIType();
                }
            }
            if (mUSBJNIBridge == null) {
                mUSBJNIBridge = new SerialComUSBJNIBridge();
                SerialComUSBJNIBridge.loadNativeLibrary(libDirectory, loadedLibName, this.mSerialComSystemProperty, osType, cpuArch, abiType);
                mUSBJNIBridge.initNativeLib();
            }
        }
    }

    public SerialComUSBdevice[] listUSBdevicesWithInfo(int vendorFilter) throws SerialComException {
        int i = 0;
        int numOfDevices = 0;
        SerialComUSBdevice[] usbDevicesFound = null;
        if (vendorFilter < 0 || vendorFilter > 65535) {
            throw new IllegalArgumentException("Argument vendorFilter can not be negative or greater than 0xFFFF !");
        }
        String[] usbDevicesInfo = mUSBJNIBridge.listUSBdevicesWithInfo(vendorFilter);
        if (usbDevicesInfo != null) {
            if (usbDevicesInfo.length < 4) {
                return new SerialComUSBdevice[0];
            }
            numOfDevices = usbDevicesInfo.length / 6;
            usbDevicesFound = new SerialComUSBdevice[numOfDevices];
            int x = 0;
            while (x < numOfDevices) {
                usbDevicesFound[x] = new SerialComUSBdevice(usbDevicesInfo[i], usbDevicesInfo[i + 1], usbDevicesInfo[i + 2], usbDevicesInfo[i + 3], usbDevicesInfo[i + 4], usbDevicesInfo[i + 5]);
                i += 6;
                ++x;
            }
            return usbDevicesFound;
        }
        throw new SerialComException("Could not find USB devices. Please retry !");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerUSBHotPlugEventListener(ISerialComUSBHotPlugListener hotPlugListener, int filterVID, int filterPID, String serialNumber) throws SerialComException {
        int opaqueHandle = 0;
        if (hotPlugListener == null) {
            throw new IllegalArgumentException("Argument hotPlugListener can not be null !");
        }
        if (filterVID < 0 || filterPID < 0 || filterVID > 65535 || filterPID > 65535) {
            throw new IllegalArgumentException("USB VID or PID can not be negative number(s) or greater than 0xFFFF !");
        }
        Object object = this.lockB;
        synchronized (object) {
            opaqueHandle = mUSBJNIBridge.registerUSBHotPlugEventListener(hotPlugListener, filterVID, filterPID, serialNumber);
            if (opaqueHandle < 0) {
                throw new SerialComException("Could not register USB device hotplug listener. Please retry !");
            }
        }
        return opaqueHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterUSBHotPlugEventListener(int opaqueHandle) throws SerialComException {
        int ret = 0;
        if (opaqueHandle < 0) {
            throw new IllegalArgumentException("Argument opaqueHandle can not be negative !");
        }
        Object object = this.lockB;
        synchronized (object) {
            ret = mUSBJNIBridge.unregisterUSBHotPlugEventListener(opaqueHandle);
            if (ret < 0) {
                throw new SerialComException("Could not un-register USB device hotplug listener. Please retry !");
            }
        }
        return true;
    }

    public String[] findComPortFromUSBAttributes(int usbVidToMatch, int usbPidToMatch, String serialNumber) throws SerialComException {
        String[] comPortsInfo;
        if (usbVidToMatch < 0 || usbVidToMatch > 65535) {
            throw new IllegalArgumentException("Argument usbVidToMatch can not be negative or greater than 0xFFFF !");
        }
        if (usbPidToMatch < 0 || usbPidToMatch > 65535) {
            throw new IllegalArgumentException("Argument usbPidToMatch can not be negative or greater than 0xFFFF !");
        }
        String serialNum = null;
        if (serialNumber != null) {
            serialNum = serialNumber.toLowerCase();
        }
        if ((comPortsInfo = mUSBJNIBridge.findComPortFromUSBAttribute(usbVidToMatch, usbPidToMatch, serialNum)) == null) {
            throw new SerialComException("Could not find COM port for given device. Please retry !");
        }
        return comPortsInfo;
    }

    public String[] getFirmwareRevisionNumber(int usbvid, int usbpid, String serialNumber) throws SerialComException {
        String[] bcdCodedRevNumber;
        if (usbvid < 0 || usbvid > 65535) {
            throw new IllegalArgumentException("Argument usbvid can not be negative or greater than 0xFFFF !");
        }
        if (usbpid < 0 || usbpid > 65535) {
            throw new IllegalArgumentException("Argument usbpid can not be negative or greater than 0xFFFF !");
        }
        String serial = null;
        if (serialNumber != null) {
            serial = serialNumber.trim().toLowerCase();
        }
        if ((bcdCodedRevNumber = mUSBJNIBridge.getFirmwareRevisionNumber(usbvid, usbpid, serial)) == null) {
            throw new SerialComException("Could not get the bcdDevice field of USB device descriptor. Please retry !");
        }
        String[] fwver = new String[bcdCodedRevNumber.length];
        int x = 0;
        while (x < bcdCodedRevNumber.length) {
            int firmwareRevisionNum = Integer.parseInt(bcdCodedRevNumber[x]);
            fwver[x] = String.format("%x.%02x", (firmwareRevisionNum & 0xFF00) >> 8, firmwareRevisionNum & 0xFF);
            ++x;
        }
        return fwver;
    }

    public SerialComUSBPowerInfo getCDCUSBDevPowerInfo(String comPort) throws SerialComException {
        if (comPort == null) {
            throw new IllegalArgumentException("Argument comPort can not be null !");
        }
        String portNameVal = comPort.trim();
        if (portNameVal.length() == 0) {
            throw new IllegalArgumentException("Argument comPort can not be empty string !");
        }
        String[] usbPowerInfo = mUSBJNIBridge.getCDCUSBDevPowerInfo(portNameVal);
        if (usbPowerInfo != null) {
            if (usbPowerInfo.length > 2) {
                return new SerialComUSBPowerInfo(usbPowerInfo[0], usbPowerInfo[1], usbPowerInfo[2], usbPowerInfo[3], usbPowerInfo[4], usbPowerInfo[5]);
            }
        } else {
            throw new SerialComException("Could not find USB devices. Please retry !");
        }
        return null;
    }

    public boolean setLatencyTimer(String comPort, byte timerValue) throws SerialComException {
        int ret = mUSBJNIBridge.setLatencyTimer(comPort, timerValue);
        if (ret < 0) {
            throw new SerialComException("Could not set the latency timer value. Please retry !");
        }
        return true;
    }

    public int getLatencyTimer(String comPort) throws SerialComException {
        int value = mUSBJNIBridge.getLatencyTimer(comPort);
        if (value < 0) {
            throw new SerialComException("Could not get the latency timer value. Please retry !");
        }
        return value;
    }

    public boolean isUSBDevConnected(int vendorID, int productID, String serialNumber) throws SerialComException {
        if (vendorID < 0 || vendorID > 65535) {
            throw new IllegalArgumentException("Argument vendorID can not be negative or greater than 0xFFFF !");
        }
        if (productID < 0 || productID > 65535) {
            throw new IllegalArgumentException("Argument productID can not be negative or greater than 0xFFFF !");
        }
        int ret = mUSBJNIBridge.isUSBDevConnected(vendorID, productID, serialNumber);
        if (ret < 0) {
            throw new SerialComException("Unknown error occurred !");
        }
        return ret == 1;
    }

    public SerialComUSBHID getUSBHIDTransportInstance() throws SerialComException {
        return new SerialComUSBHID(mUSBJNIBridge);
    }
}

