/*
 * Decompiled with CFR 0.152.
 */
package com.serialpundit.usb;

import com.serialpundit.core.util.SerialComUtil;

public final class SerialComUSBPowerInfo {
    private String autoSuspendDelay;
    private String currentControlConfig;
    private String currentRuntimeStatus;
    private String isSelectiveSuspendSupported;
    private String isSelectiveSuspendEnabled;
    private String selectiveSuspendTimeoutValue;

    public SerialComUSBPowerInfo(String autoSuspendDelay, String currentControlConfig, String currentRuntimeStatus, String isSelectiveSuspendSupported, String isSelectiveSuspendEnabled, String selectiveSuspendTimeoutValue) {
        this.autoSuspendDelay = autoSuspendDelay;
        this.currentControlConfig = currentControlConfig;
        this.currentRuntimeStatus = currentRuntimeStatus;
        this.isSelectiveSuspendSupported = isSelectiveSuspendSupported;
        this.isSelectiveSuspendEnabled = isSelectiveSuspendEnabled;
        this.selectiveSuspendTimeoutValue = selectiveSuspendTimeoutValue;
    }

    public String getAutoSuspendDelay() {
        return this.autoSuspendDelay;
    }

    public String getCurrentControlConfig() {
        return this.currentControlConfig;
    }

    public String getCurrentRuntimeStatus() {
        return this.currentRuntimeStatus;
    }

    public Boolean isSelectiveSuspendSupported() {
        if (this.isSelectiveSuspendSupported.equals("true")) {
            return true;
        }
        return false;
    }

    public Boolean isSelectiveSuspendEnabled() {
        if (this.isSelectiveSuspendEnabled.equals("true")) {
            return true;
        }
        return false;
    }

    public int getSelectiveSuspendTimeout() {
        if ("---".equals(this.selectiveSuspendTimeoutValue)) {
            return 0;
        }
        return (int)SerialComUtil.hexStrToLongNumber((String)this.selectiveSuspendTimeoutValue);
    }

    public void dumpDevicePowerInfo() {
        System.out.println("Auto suspend delay (ms) : " + this.autoSuspendDelay + "\nControl configuration : " + this.currentControlConfig + "\nCurrent power status : " + this.currentRuntimeStatus + "\nIs selective suspend supported : " + this.isSelectiveSuspendSupported + "\nIs selective suspend enabled : " + this.isSelectiveSuspendEnabled + "\nSelective suspend timeout value : " + this.selectiveSuspendTimeoutValue);
    }
}

