/*
 * Decompiled with CFR 0.152.
 */
package com.serialpundit.usb;

import com.serialpundit.core.SerialComException;
import com.serialpundit.usb.SerialComUSBHIDdevice;
import com.serialpundit.usb.internal.SerialComUSBJNIBridge;

public final class SerialComUSBHID {
    private final SerialComUSBJNIBridge mUSBJNIBridge;

    public SerialComUSBHID(SerialComUSBJNIBridge mUSBJNIBridge) {
        this.mUSBJNIBridge = mUSBJNIBridge;
    }

    public SerialComUSBHIDdevice[] listUSBHIDdevicesWithInfo(int vendorFilter) throws SerialComException {
        int i = 0;
        int numOfDevices = 0;
        SerialComUSBHIDdevice[] usbHidDevicesFound = null;
        if (vendorFilter < 0 || vendorFilter > 65535) {
            throw new IllegalArgumentException("Argument vendorFilter can not be negative or greater than 0xFFFF !");
        }
        String[] usbhidDevicesInfo = this.mUSBJNIBridge.listUSBHIDdevicesWithInfo(vendorFilter);
        if (usbhidDevicesInfo != null) {
            if (usbhidDevicesInfo.length <= 3) {
                return new SerialComUSBHIDdevice[0];
            }
            numOfDevices = usbhidDevicesInfo.length / 8;
            usbHidDevicesFound = new SerialComUSBHIDdevice[numOfDevices];
            int x = 0;
            while (x < numOfDevices) {
                usbHidDevicesFound[x] = new SerialComUSBHIDdevice(usbhidDevicesInfo[i], usbhidDevicesInfo[i + 1], usbhidDevicesInfo[i + 2], usbhidDevicesInfo[i + 3], usbhidDevicesInfo[i + 4], usbhidDevicesInfo[i + 5], usbhidDevicesInfo[i + 6], usbhidDevicesInfo[i + 7]);
                i += 8;
                ++x;
            }
            return usbHidDevicesFound;
        }
        throw new SerialComException("Could not find USB HID devices. Please retry !");
    }
}

