/*
 * Decompiled with CFR 0.152.
 */
package com.serialpundit.usb.internal;

import com.serialpundit.core.SerialComException;
import com.serialpundit.core.SerialComSystemProperty;
import com.serialpundit.usb.ISerialComUSBHotPlugListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public final class SerialComUSBJNIBridge {
    private static final Comparator<String> comparator = new Comparator<String>(){

        @Override
        public int compare(String valueA, String valueB) {
            int bl;
            if (valueA.equalsIgnoreCase(valueB)) {
                return valueA.compareTo(valueB);
            }
            int al = valueA.length();
            int minLength = al <= (bl = valueB.length()) ? al : bl;
            int shiftA = 0;
            int shiftB = 0;
            int i = 0;
            while (i < minLength) {
                char charB;
                char charA = valueA.charAt(i - shiftA);
                if (charA != (charB = valueB.charAt(i - shiftB))) {
                    if (Character.isDigit(charA) && Character.isDigit(charB)) {
                        int[] resultsA = new int[]{-1, i - shiftA};
                        String numVal = "";
                        int x22 = i - shiftA;
                        while (x22 < al) {
                            resultsA[1] = x22;
                            char c = valueA.charAt(x22);
                            if (!Character.isDigit(c)) break;
                            numVal = String.valueOf(numVal) + c;
                            ++x22;
                        }
                        try {
                            resultsA[0] = Integer.valueOf(numVal);
                        }
                        catch (Exception x22) {
                            // empty catch block
                        }
                        int[] resultsB = new int[]{-1, i - shiftB};
                        numVal = "";
                        int x = i - shiftB;
                        while (x < bl) {
                            resultsB[1] = x;
                            char c = valueB.charAt(x);
                            if (!Character.isDigit(c)) break;
                            numVal = String.valueOf(numVal) + c;
                            ++x;
                        }
                        try {
                            resultsB[0] = Integer.valueOf(numVal);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (resultsA[0] != resultsB[0]) {
                            return resultsA[0] - resultsB[0];
                        }
                        if (al < bl) {
                            i = resultsA[1];
                            shiftB = resultsA[1] - resultsB[1];
                        } else {
                            i = resultsB[1];
                            shiftA = resultsB[1] - resultsA[1];
                        }
                    } else if (Character.toLowerCase(charA) - Character.toLowerCase(charB) != 0) {
                        return Character.toLowerCase(charA) - Character.toLowerCase(charB);
                    }
                }
                ++i;
            }
            return valueA.compareToIgnoreCase(valueB);
        }
    };

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean loadNativeLibrary(String directoryPath, String loadedLibName, SerialComSystemProperty serialComSystemProperty, int osType, int cpuArch, int abitype) throws SerialComException {
        String javaTmpDir = null;
        String userHomeDir = null;
        String fileSeparator = null;
        File baseDir = null;
        File workingDir = null;
        boolean isTmpDir = false;
        boolean isUserHomeDir = false;
        String libToExtractFromJar = null;
        File libFile = null;
        String libExtension = null;
        InputStream input = null;
        FileOutputStream output = null;
        fileSeparator = serialComSystemProperty.getfileSeparator();
        if (fileSeparator == null || fileSeparator.length() == 0) {
            throw new SerialComException("The file.separator java system property is either null or empty !");
        }
        if (directoryPath == null) {
            javaTmpDir = serialComSystemProperty.getJavaIOTmpDir();
            if (javaTmpDir == null || javaTmpDir.length() == 0) {
                throw new SerialComException("The java.io.tmpdir java system property is either null or empty !");
            }
            baseDir = new File(javaTmpDir);
            if (baseDir.exists() && baseDir.isDirectory() && baseDir.canWrite()) {
                isTmpDir = true;
            } else {
                userHomeDir = serialComSystemProperty.getUserHome();
                if (userHomeDir == null || userHomeDir.length() == 0) {
                    throw new SerialComException("The user.home java system property is either null or empty !");
                }
                baseDir = new File(userHomeDir);
                if (!baseDir.exists()) {
                    throw new SerialComException("User home directory does not exist. Also unable to access tmp/temp directory !");
                }
                if (!baseDir.isDirectory()) {
                    throw new SerialComException("User home directory is not a directory. Also unable to access tmp/temp directory !");
                }
                if (!baseDir.canWrite()) {
                    throw new SerialComException("User home directory is not writeable (permissions ??). Also unable to access tmp/temp directory !");
                }
                isUserHomeDir = true;
            }
            workingDir = new File(String.valueOf(baseDir.toString()) + fileSeparator + "sp_tuartx1");
            if (!workingDir.exists() && !workingDir.mkdir()) {
                if (isTmpDir) {
                    throw new SerialComException("Can not create sp_tuartx1 unique directory in tmp/temp directory !");
                }
                if (isUserHomeDir) {
                    throw new SerialComException("Can not create sp_tuartx1 unique directory in user's home directory !");
                }
            }
        } else {
            baseDir = new File(directoryPath);
            if (!baseDir.exists()) {
                throw new SerialComException("Given " + directoryPath + " directory does not exist !");
            }
            if (!baseDir.isDirectory()) {
                throw new SerialComException("Given " + directoryPath + " is not a directory !");
            }
            if (!baseDir.canWrite()) {
                throw new SerialComException("Given " + directoryPath + " directory is not writeable !");
            }
            workingDir = baseDir;
        }
        if (cpuArch == 2) {
            switch (osType) {
                case 2: {
                    libToExtractFromJar = "spusbwinx64.dll";
                    libExtension = ".dll";
                    break;
                }
                case 1: {
                    libToExtractFromJar = "spusblnxx64.so";
                    libExtension = ".so";
                    break;
                }
                case 4: {
                    libToExtractFromJar = "spusbmacx64.dylib";
                    libExtension = ".dylib";
                }
            }
        } else if (cpuArch == 1) {
            switch (osType) {
                case 2: {
                    libToExtractFromJar = "spusbwinx86.dll";
                    libExtension = ".dll";
                    break;
                }
                case 1: {
                    libToExtractFromJar = "spusblnxx86.so";
                    libExtension = ".so";
                    break;
                }
                case 4: {
                    libToExtractFromJar = "spusbmacx86.dylib";
                    libExtension = ".dylib";
                }
            }
        } else if (cpuArch == 15) {
            if (osType != 1) throw new SerialComException("Please report us your platform !");
            libExtension = ".so";
            if (abitype == 1) {
                libToExtractFromJar = "spusblnxarmv7hf.so";
            } else if (abitype == 2) {
                libToExtractFromJar = "spusblnxarmv7el.so";
            }
        } else if (cpuArch == 14) {
            if (osType != 1) throw new SerialComException("Please report us your platform !");
            libExtension = ".so";
            if (abitype == 1) {
                libToExtractFromJar = "spusblnxarmv6hf.so";
            } else if (abitype == 2) {
                libToExtractFromJar = "spusblnxarmv6el.so";
            }
        } else {
            if (cpuArch != 13) throw new SerialComException("This architecture is unknown to this library. Please contact us !");
            if (osType == 1) {
                libExtension = ".so";
                libToExtractFromJar = "spusblnxarmv5.so";
            }
        }
        try {
            try {
                int read;
                libFile = loadedLibName == null ? new File(String.valueOf(workingDir.getAbsolutePath()) + fileSeparator + libToExtractFromJar) : new File(String.valueOf(workingDir.getAbsolutePath()) + fileSeparator + loadedLibName.trim() + libExtension);
                input = SerialComUSBJNIBridge.class.getResourceAsStream("/" + libToExtractFromJar);
                output = new FileOutputStream(libFile);
                if (input == null) throw new SerialComException("Can not get shared library " + libToExtractFromJar + " resource as stream from sp-usb.jar file !");
                byte[] buffer = new byte[4096];
                while ((read = input.read(buffer)) != -1) {
                    output.write(buffer, 0, read);
                }
                output.flush();
                output.close();
                output = null;
                if (libFile == null || !libFile.exists() || !libFile.isFile()) {
                    throw new SerialComException("Can not extract native shared library " + libToExtractFromJar + " from sp-usb.jar file !");
                }
            }
            catch (Exception e) {
                throw (SerialComException)new SerialComException(libFile.toString()).initCause((Throwable)e);
            }
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception exception) {}
        }
        final File libFileFinal = libFile;
        try {
            AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    System.load(libFileFinal.toString());
                    return true;
                }
            });
            return true;
        }
        catch (Exception e) {
            throw (SerialComException)new SerialComException("Could not load " + libFile.toString() + " native library !").initCause((Throwable)e);
        }
    }

    public String[] findComPortFromUSBAttribute(int usbVidToMatch, int usbPidToMatch, String serialNumber) {
        String[] ports = this.findComPortFromUSBAttributes(usbVidToMatch, usbPidToMatch, serialNumber);
        if (ports != null) {
            if (ports.length < 2) {
                return ports;
            }
            ArrayList<String> portsFound = new ArrayList<String>();
            String[] stringArray = ports;
            int n = ports.length;
            int n2 = 0;
            while (n2 < n) {
                String portName = stringArray[n2];
                portsFound.add(portName);
                ++n2;
            }
            Collections.sort(portsFound, comparator);
            return portsFound.toArray(new String[portsFound.size()]);
        }
        return null;
    }

    public native void initNativeLib();

    public native String[] listUSBdevicesWithInfo(int var1);

    public native String[] getFirmwareRevisionNumber(int var1, int var2, String var3);

    public native int registerUSBHotPlugEventListener(ISerialComUSBHotPlugListener var1, int var2, int var3, String var4);

    public native int unregisterUSBHotPlugEventListener(int var1);

    public native int isUSBDevConnected(int var1, int var2, String var3);

    public native String[] findComPortFromUSBAttributes(int var1, int var2, String var3);

    public native String[] getCDCUSBDevPowerInfo(String var1);

    public native int setLatencyTimer(String var1, byte var2);

    public native int getLatencyTimer(String var1);

    public native String[] listUSBHIDdevicesWithInfo(int var1);
}

