/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.camel.stream;

import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.subjects.Subject;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.bidib.wizard.api.model.connection.AbstractMessageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BidibMessageStreamFunction {
    private static final Logger LOGGER = LoggerFactory.getLogger(BidibMessageStreamFunction.class);
    private volatile Subject<AbstractMessageEvent> subjectBidibMessages;
    private String connectionId;
    private Disposable dispMessageSubscription;
    private final CamelContext camelContext;

    public BidibMessageStreamFunction(CamelContext camelContext, String connectionId, Subject<AbstractMessageEvent> subjectBidibMessages) {
        this.subjectBidibMessages = subjectBidibMessages;
        this.camelContext = camelContext;
        this.connectionId = connectionId;
    }

    @PostConstruct
    public void initialize() {
        LOGGER.info("The BidibMessageStreamFunction is started for connectionId: {}", (Object)this.connectionId);
        ProducerTemplate producerTemplate = this.camelContext.createProducerTemplate();
        this.dispMessageSubscription = this.subjectBidibMessages.subscribe(event -> {
            LOGGER.info("Publish event: {}", event);
            producerTemplate.sendBodyAndHeader("direct:bidibmessages", event, "connectionId", (Object)this.connectionId);
        }, err -> LOGGER.warn("The message subscription signalled an error: {}", (Object)err.getMessage(), err), () -> LOGGER.warn("The message subscription has completed."));
    }

    @PreDestroy
    public void shutdown() {
        LOGGER.info("Shutdown the BidibMessageStreamFunction for connectionId: {}", (Object)this.connectionId);
        if (this.dispMessageSubscription != null) {
            this.dispMessageSubscription.dispose();
            this.dispMessageSubscription = null;
        }
    }
}

